/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.entity.businessfield;

import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.field.AssistantEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class AssistantField
extends BasedataField {
    private static final String ASSISTANT_ENTITY_ID = "b649c83f00000aac";
    private static final String ENTITY_ASSISTANT_GROUP = "bos_assistantdatagroup";
    private String asstTypeId;
    private String asstParentId;
    private String asstTypeNumber;
    private String asstCloudNumber;

    @SimplePropertyAttribute
    public String getAsstParentId() {
        return this.asstParentId;
    }

    public void setAsstParentId(String asstParentId) {
        this.asstParentId = asstParentId;
    }

    @SimplePropertyAttribute
    public String getAsstTypeId() {
        return this.asstTypeId;
    }

    public void setAsstTypeId(String typeId) {
        this.asstTypeId = typeId;
    }

    @SimplePropertyAttribute
    public String getAsstTypeNumber() {
        return this.asstTypeNumber;
    }

    public void setAsstTypeNumber(String asstTypeNumber) {
        this.asstTypeNumber = asstTypeNumber;
    }

    @SimplePropertyAttribute
    public String getAsstCloudNumber() {
        return this.asstCloudNumber;
    }

    public void setAsstCloudNumber(String asstCloudNumber) {
        this.asstCloudNumber = asstCloudNumber;
    }

    protected AssistantEdit createServerEditor() {
        AssistantEdit assistantEdit = new AssistantEdit();
        Field<?> fld = this.entityMetadata.getFieldById(this.asstParentId);
        if (fld != null) {
            assistantEdit.setControlPropName(fld.getKey().toLowerCase());
        }
        return assistantEdit;
    }

    @Override
    protected void setServerEditorProperties(FieldEdit editor) {
        super.setServerEditorProperties(editor);
        AssistantEdit assEdit = (AssistantEdit)editor;
        assEdit.setDisplayProp(this.getDisplayProp());
    }

    @Override
    protected AssistantProp createDynamicProperty() {
        AssistantProp asstProp = new AssistantProp();
        asstProp.setBaseEntityId(ASSISTANT_ENTITY_ID);
        this.setBaseEntityId(ASSISTANT_ENTITY_ID);
        return asstProp;
    }

    @Override
    public String getBaseEntityId() {
        return ASSISTANT_ENTITY_ID;
    }

    @Override
    protected void setDynamicProperty(BasedataProp prop) {
        super.setDynamicProperty(prop);
        String name = (String)prop.getDisplayName().getDefaultItem();
        if (this.asstTypeId != null) {
            AssistantProp asstProp = (AssistantProp)prop;
            asstProp.setAsstTypeId(this.asstTypeId);
            asstProp.setAsstParentId(this.asstParentId);
            asstProp.setAsstCloudNumber(this.asstCloudNumber);
            asstProp.setAsstTypeNumber(this.asstTypeNumber);
            this.resetTypeId(asstProp);
            prop.setDbIgnore(true);
        } else {
            this.addBuildError(2, "asstTypeId", String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5173\u8054\u7684\u201c\u8f85\u52a9\u8d44\u6599\u7c7b\u578b\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AssistantField_0", (String)"bos-metadata", (Object[])new Object[0]), name));
        }
    }

    private void resetTypeId(AssistantProp asstProp) {
        try {
            SqlBuilder builder = new SqlBuilder();
            builder.append("select top 1 fid from t_bas_assistantdata where ", new Object[0]).append("fid = ?", new Object[]{Long.valueOf(this.asstTypeId)});
            try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.basedata, (SqlBuilder)builder);){
                String cloudId;
                String typeId;
                if (!ds.hasNext() && this.asstCloudNumber != null && this.asstTypeNumber != null && StringUtils.isNotBlank((CharSequence)(typeId = this.getTypeId(cloudId = this.getCloudId())))) {
                    asstProp.setAsstTypeId(typeId);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getTypeId(String cloudId) {
        if (StringUtils.isBlank((CharSequence)this.asstTypeNumber) || StringUtils.isBlank((CharSequence)cloudId)) {
            return "";
        }
        SqlBuilder builder = new SqlBuilder();
        builder.append("select top 1 fid from t_bas_assistantdata where ", new Object[0]).append("fnumber = ?", new Object[]{this.asstTypeNumber}).append("and", new Object[0]).append("fbizcloudid = ?", new Object[]{cloudId});
        try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.basedata, (SqlBuilder)builder);){
            if (ds.hasNext()) {
                String string = ds.next().getString("fid");
                return string;
            }
        }
        return "";
    }

    private String getCloudId() {
        if (StringUtils.isBlank((CharSequence)this.asstCloudNumber)) {
            return "";
        }
        SqlBuilder builder = new SqlBuilder();
        builder.append("select top 1 fid from t_meta_bizcloud where ", new Object[0]).append("fnumber = ?", new Object[]{this.asstCloudNumber});
        try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.meta, (SqlBuilder)builder);){
            if (ds.hasNext()) {
                String string = ds.next().getString("fid");
                return string;
            }
        }
        return "";
    }

    @Override
    public Map<String, Object> createEditor() {
        Map<String, Object> ctlRet = super.createEditor();
        ctlRet.put("type", "basedata");
        if (this.isLableHyperlink()) {
            ctlRet.put("ln", this.isLableHyperlink());
        }
        ctlRet.put("ei", "bos_assistantdata_detail");
        if (StringUtils.isNotBlank((Object)this.getEmptyText())) {
            ctlRet.put("emptytip", this.getEmptyText());
        }
        if (!this.isAllowAutoList()) {
            ctlRet.put("al", this.isAllowAutoList());
        }
        if (!this.isCacheLookUpList()) {
            ctlRet.put("cl", this.isCacheLookUpList());
        }
        return ctlRet;
    }

    @Override
    public void resetItemId(Map<String, String> idMap) {
        super.resetItemId(idMap);
        String newid = idMap.get(this.getAsstParentId());
        if (newid != null) {
            this.setAsstParentId(newid);
        }
    }
}

