/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.entity.businessfield;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.field.BillStatusEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.metadata.entity.businessfield.billstatusfield.StatusItem;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.url.UrlService;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class BillStatusField
extends ComboField {
    private List<StatusItem> StatusItems = new ArrayList<StatusItem>();

    @Override
    public String getLock() {
        return "new,edit,view,submit,audit";
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=StatusItem.class)
    public List<StatusItem> getStatusItems() {
        return this.StatusItems;
    }

    public void setStatusItems(List<StatusItem> statusItems) {
        this.StatusItems = statusItems;
    }

    protected BillStatusEdit createServerEditor() {
        return new BillStatusEdit();
    }

    @Override
    public Map<String, Object> createEditor() {
        Map<String, Object> ctlRet = super.createEditor();
        List<Object> items = this.getStore(!this.isMustInput());
        ctlRet.put("st", items);
        return ctlRet;
    }

    private List<Object> getStore(boolean allowNull) {
        ArrayList<Object> items = new ArrayList<Object>();
        for (StatusItem item : this.StatusItems) {
            items.add(this.createEnumItem(item.getStatusKey(), item.getStatusName(), item.getStatusimage(), true, false));
        }
        return items;
    }

    private Object createEnumItem(Object value, String displayValue, String imageKey) {
        ArrayList<Object> item = new ArrayList<Object>();
        item.add(value);
        item.add(new LocaleString(displayValue));
        String fullPathImageKey = UrlService.getDomainContextUrl() + imageKey;
        item.add(fullPathImageKey);
        return item;
    }

    @Override
    public List<ComboItem> getItems() {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        int i = 0;
        for (StatusItem statusItem : this.StatusItems) {
            items.add(new ComboItem(i++, statusItem.getStatusName(), statusItem.getStatusKey(), statusItem.getStatusimage()));
        }
        return items;
    }

    @Override
    protected void setServerEditorProperties(FieldEdit editor) {
        super.setItems(this.getItems());
        super.setServerEditorProperties(editor);
    }

    @Override
    protected BillStatusProp createDynamicProperty() {
        return new BillStatusProp();
    }

    @Override
    protected void setDynamicProperty(ComboProp prop) {
        super.setDynamicProperty(prop);
        ArrayList<BillStatusProp.StatusItemPro> statusItems = new ArrayList<BillStatusProp.StatusItemPro>(10);
        for (StatusItem item : this.getStatusItems()) {
            BillStatusProp.StatusItemPro statusItem = new BillStatusProp.StatusItemPro();
            statusItem.setStatusKey(item.getStatusKey());
            statusItem.setStatusName(item.getStatusName());
            statusItem.setOperationerKey(item.getOperationerKey());
            statusItem.setOperationDateKey(item.getOperationDateKey());
            statusItem.setClearOperationKey(item.getClearOperationKey());
            statusItems.add(statusItem);
        }
        ((BillStatusProp)prop).setStatusItems(statusItems);
    }
}

