/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.entity.businessfield;

import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.form.field.GroupEdit;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class GroupField
extends BasedataField {
    private static final String BOS_GROUP = "bos_group";
    private String groupTableName;
    private boolean showTreeLower = true;
    private boolean needRefreshTree = true;

    @SimplePropertyAttribute(name="ShowTreeLower")
    @DefaultValueAttribute(value="true")
    public boolean isShowTreeLower() {
        return this.showTreeLower;
    }

    public void setShowTreeLower(boolean showTreeLower) {
        this.showTreeLower = showTreeLower;
    }

    @SimplePropertyAttribute
    public String getGroupTableName() {
        return this.groupTableName;
    }

    public void setGroupTableName(String groupTableName) {
        this.groupTableName = groupTableName;
    }

    @Override
    protected GroupProp createDynamicProperty() {
        GroupProp prop = new GroupProp();
        prop.setGroupTableName(this.groupTableName);
        prop.setShowTreeLower(this.showTreeLower);
        prop.setNeedRefreshTree(this.needRefreshTree);
        return prop;
    }

    protected GroupEdit createServerEditor() {
        return new GroupEdit();
    }

    public void updateRunTimeRefType(DynamicObjectType dt) {
        if (StringUtils.isBlank((CharSequence)this.getGroupTableName()) && !BOS_GROUP.equals(dt.getName())) {
            return;
        }
        String groupTable = this.getGroupTableName();
        if (StringUtils.isNotBlank((CharSequence)groupTable)) {
            String langTableName = String.format("%s_l", groupTable);
            dt.setAlias(groupTable);
            DynamicLocaleProperty localeProperty = (DynamicLocaleProperty)dt.getProperties().get((Object)"MultiLanguageText");
            localeProperty.setAlias(langTableName);
            for (IDataEntityProperty dataEntityProp : dt.getProperties()) {
                if (dataEntityProp instanceof ParentBasedataProp) {
                    EntityType subEntityProp = (EntityType)((ParentBasedataProp)dataEntityProp).getComplexType();
                    subEntityProp.setAlias(groupTable);
                    DynamicLocaleProperty localeProp = (DynamicLocaleProperty)subEntityProp.getProperties().get((Object)"MultiLanguageText");
                    localeProp.setAlias(langTableName);
                    localeProp.getDynamicCollectionItemPropertyType().setAlias(langTableName);
                    continue;
                }
                if (!(dataEntityProp instanceof DynamicLocaleProperty)) continue;
                ((DynamicLocaleProperty)dataEntityProp).setAlias(langTableName);
                ((DynamicLocaleProperty)dataEntityProp).getDynamicCollectionItemPropertyType().setAlias(langTableName);
            }
        }
    }

    private boolean isCustom() {
        return StringUtils.isBlank((CharSequence)this.getBaseEntityId()) || BOS_GROUP.equals(this.getBaseEntityId());
    }

    @SimplePropertyAttribute(name="IsNeedRefreshTree")
    @DefaultValueAttribute(value="true")
    public boolean isNeedRefreshTree() {
        return this.needRefreshTree;
    }

    public void setNeedRefreshTree(boolean isNeedRefreshTree) {
        this.needRefreshTree = isNeedRefreshTree;
    }
}

