/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.entity.businessfield;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.RuntimeMetaType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.ItemClassEdit;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.RuntimeEntityMeta;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.ItemClass;
import kd.bos.metadata.entity.businessfield.ItemClassTypeField;
import kd.bos.metadata.entity.businessfield.RefBasedata;
import kd.bos.metadata.entity.commonfield.Field;
import kd.sdk.annotation.SdkPublic;
import org.jetbrains.annotations.NotNull;

@SdkPublic
public class ItemClassField
extends BasedataField {
    private static final String BOS_METADATA = "bos-metadata";
    private String typeFieldId;

    public ItemClassField() {
        this.defValueType = 0;
    }

    @SimplePropertyAttribute
    public String getTypeFieldId() {
        return this.typeFieldId;
    }

    public void setTypeFieldId(String typeFieldId) {
        this.typeFieldId = typeFieldId;
    }

    @Override
    @SimplePropertyAttribute
    public String getEditSearchProp() {
        return super.getDisplayProp();
    }

    @Override
    public String getCompareGroupID() {
        return "8";
    }

    @Override
    public void addRefBasedata(Map<String, Set<String>> refObjectProps) {
        ItemClassTypeField field = (ItemClassTypeField)this.entityMetadata.getFieldById(this.getTypeFieldId());
        if (field != null) {
            for (RefBasedata refBasedata : field.getRefBasedatas()) {
                super.addRefProps(refObjectProps, refBasedata.getBaseEntityId(), super.getRuntimeRefProps(refBasedata.getRefProps()));
            }
        }
    }

    @Override
    public Field<?> getControlField() {
        return this.entityMetadata.getFieldById(this.typeFieldId);
    }

    @Override
    protected BasedataProp createDynamicProperty() {
        return new ItemClassProp();
    }

    @Override
    protected FieldEdit createServerEditor() {
        return new ItemClassEdit();
    }

    @Override
    public List<Map<String, Object>> createEntityTreeNodes(boolean isAllNode, int level) {
        ArrayList<Map<String, Object>> cols = new ArrayList<Map<String, Object>>();
        if (!isAllNode && StringUtils.isBlank((CharSequence)this.getFieldName())) {
            return cols;
        }
        cols.add(this.createEntityNode("id", this.getName().toString()));
        cols.add(this.createEntityNode("number", String.format(ResManager.loadKDString((String)"%s.\u7f16\u7801", (String)"ItemClassField_0", (String)BOS_METADATA, (Object[])new Object[0]), this.getName().toString())));
        cols.add(this.createEntityNode("name", String.format(ResManager.loadKDString((String)"%s.\u540d\u79f0", (String)"ItemClassField_1", (String)BOS_METADATA, (Object[])new Object[0]), this.getName().toString())));
        return cols;
    }

    @NotNull
    private Map<String, Object> createEntityNode(String fieldPropName, String name) {
        HashMap<String, Object> colNumber = new HashMap<String, Object>();
        colNumber.put("Id", String.format("%s.%s", this.getKey(), fieldPropName));
        colNumber.put("Type", "ListColumnAp");
        colNumber.put("DataType", "basedata");
        colNumber.put("Name", name);
        colNumber.put("CreateType", 1);
        colNumber.put("compareGroupId", "0,1,2,3");
        colNumber.put("IsMulti", false);
        colNumber.put("Custom", false);
        colNumber.put("SeqType", "NotSeq");
        colNumber.put("EntryEntity", false);
        colNumber.put("IsBaseData", true);
        colNumber.put("ClientType", "text");
        colNumber.put("FilterApType", "FilterColumnAp");
        colNumber.put("CommonFilterApType", "CommonFilterColumnAp");
        colNumber.put("SchemeFilterApType", "SchemeFilterColumnAp");
        colNumber.put("IsFieldPropAliasEmpty", StringUtils.isBlank((CharSequence)this.getFieldName()));
        return colNumber;
    }

    @Override
    protected void setBasedataProp(BasedataProp prop) {
        Field<?> field;
        Field<?> fld = this.entityMetadata.getFieldById(this.typeFieldId);
        if (fld != null) {
            ItemClassProp itemClassProp = (ItemClassProp)prop;
            itemClassProp.setTypePropName(fld.getKey().toLowerCase());
            itemClassProp.setDisplayProp(this.getDisplayProp());
            itemClassProp.setEditSearchProp(this.getEditSearchProp());
            itemClassProp.setShowUsed(this.isShowUsed());
        } else {
            this.addBuildError(2, "TypeFieldId", String.format(ResManager.loadKDString((String)"\u591a\u7c7b\u522b\u57fa\u7840\u8d44\u6599\u3010%s\u3011\u7684\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u672a\u8bbe\u7f6e\u3002", (String)"ItemClassField_2", (String)BOS_METADATA, (Object[])new Object[0]), this.getName()));
        }
        if (!StringUtils.isBlank((CharSequence)this.getOrgFieldId()) && (field = this.entityMetadata.getFieldById(this.getOrgFieldId())) != null) {
            prop.setOrgProp(field.getKey().toLowerCase());
        }
        prop.setDefValue(this.getDefValue());
        prop.setDefValue2(this.buildFieldDefValue());
    }

    @Override
    public void buildBaseDadaFieldFilter(List<RuntimeEntityMeta> metas) {
        ItemClassTypeField classTypeField = (ItemClassTypeField)this.getControlField();
        if (classTypeField != null) {
            for (ItemClass itemClass : classTypeField.getItemTypes()) {
                if (!StringUtils.isNotBlank((CharSequence)itemClass.getBaseEntityId()) || itemClass.getFilter() == null) continue;
                String entityNumber = MetadataDao.getEntityNumberById(itemClass.getBaseEntityId());
                RuntimeEntityMeta meta = this.createRuntimeEntityMeta();
                meta.setKey(this.getKey() + "." + entityNumber);
                meta.setType(RuntimeMetaType.BaseDataFieldFilter.getValue());
                meta.setData(itemClass.getFilter() == null ? "" : SerializationUtils.toJsonString((Object)itemClass.getFilter()));
                metas.add(meta);
            }
        }
    }

    @Override
    public int getFieldDBType() {
        return -5;
    }
}

