/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.entity.businessfield;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.ItemClassTypeEdit;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.businessfield.ItemClass;
import kd.bos.metadata.entity.businessfield.RefBasedata;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ItemClassTypeField
extends ComboField {
    private List<ItemClass> itemTypes = new ArrayList<ItemClass>();

    public ItemClassTypeField() {
        this.defValueType = 0;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=ItemClass.class)
    public List<ItemClass> getItemTypes() {
        return this.itemTypes;
    }

    public List<RefBasedata> getRefBasedatas() {
        ArrayList<RefBasedata> refBasedatas = new ArrayList<RefBasedata>(10);
        for (ItemClass item : this.itemTypes) {
            refBasedatas.add(item);
        }
        return refBasedatas;
    }

    @Override
    protected ComboProp createDynamicProperty() {
        return new ItemClassTypeProp();
    }

    @Override
    public List<ComboItem> getItems() {
        this.items.clear();
        for (ItemClass itemClass : this.getItemTypes()) {
            if (StringUtils.isBlank((CharSequence)itemClass.getBaseEntityId())) continue;
            String entityNumber = MetadataDao.getEntityNumberById(itemClass.getBaseEntityId());
            ComboItem item = new ComboItem();
            item.setCaption(itemClass.getCaption());
            item.setValue(entityNumber);
            this.items.add(item);
        }
        return this.items;
    }

    @Override
    protected void setDynamicProperty(ComboProp prop) {
        super.setDynamicProperty(prop);
        ArrayList<String> baseEntityIds = new ArrayList<String>(this.getRefBasedatas().size());
        HashMap<String, String> baseEntities = new HashMap<String, String>(this.getRefBasedatas().size());
        for (RefBasedata refBasedata : this.getRefBasedatas()) {
            if (StringUtils.isBlank((CharSequence)refBasedata.getBaseEntityId())) continue;
            String number = MetadataDao.getEntityNumberById(refBasedata.getBaseEntityId());
            if (number == null) {
                this.addBuildError(2, "BaseEntityId", String.format(ResManager.loadKDString((String)"%s\u5173\u8054\u7684\u57fa\u7840\u8d44\u6599\u4e0d\u5b58\u5728", (String)"ItemClassTypeField_0", (String)"bos-metadata", (Object[])new Object[0]), this.getName()));
            }
            baseEntityIds.add(number);
            baseEntities.put(number, refBasedata.getBaseEntityId());
        }
        ((ItemClassTypeProp)prop).setBaseEntityIds(baseEntityIds);
        ((ItemClassTypeProp)prop).setBaseEntities(baseEntities);
    }

    @Override
    public Map<String, Object> createEditor() {
        Map<String, Object> ctlRet = super.createEditor();
        ctlRet.put("fu", true);
        return ctlRet;
    }

    @Override
    protected FieldEdit createServerEditor() {
        return new ItemClassTypeEdit();
    }
}

