/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.entity.businessfield;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.MasterBasedataProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.MasterBasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.AbstractBasedataField;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class MasterIdField<T extends DynamicProperty>
extends AbstractBasedataField<T> {
    private int masterIdType = 0;

    @Override
    public String getFilterControlType() {
        return "basedata";
    }

    @Override
    public String getCompareGroupID() {
        return "0,1,2";
    }

    @Override
    public int getFieldDBType() {
        switch (this.getMasterIdType()) {
            case 2: {
                EntityMetadata refMeta = this.getRefBaseEntityMeta();
                if (refMeta != null && refMeta.getRootEntity().getPkType() == 0) {
                    return 12;
                }
                return -5;
            }
        }
        if (this.entityMetadata.getRootEntity().getPkType() == 0) {
            return 12;
        }
        return -5;
    }

    @SimplePropertyAttribute
    public int getMasterIdType() {
        return this.masterIdType;
    }

    public void setMasterIdType(int masterIdType) {
        this.masterIdType = masterIdType;
    }

    @Override
    protected FieldEdit createServerEditor() {
        Object editor = null;
        switch (this.getMasterIdType()) {
            case 2: {
                editor = new MasterBasedataEdit();
                break;
            }
            default: {
                editor = this.getFieldDBType() == 12 ? new TextEdit() : new DecimalEdit();
            }
        }
        return editor;
    }

    @Override
    protected void setServerEditorProperties(FieldEdit editor) {
        super.setServerEditorProperties(editor);
        if (this.getMasterIdType() == 2) {
            this.setServerBasedataEditor((BasedataEdit)editor);
        } else if (this.getFieldDBType() == 12) {
            // empty if block
        }
    }

    @Override
    public Map<String, Object> createEditor() {
        Map<String, Object> editor = super.createEditor();
        if (this.getMasterIdType() == 2) {
            this.setClientBasedataEditor(editor);
            editor.put("mi", true);
        } else {
            editor.put("mi", false);
            if (this.getFieldDBType() == 12) {
                this.setClientTextEditor(editor);
            } else {
                this.setClientIntEditor(editor);
            }
        }
        return editor;
    }

    @Override
    protected T createDynamicProperty() {
        Object prop = null;
        switch (this.getMasterIdType()) {
            case 2: {
                prop = new MasterBasedataProp();
                break;
            }
            default: {
                prop = this.getFieldDBType() == 12 ? new TextProp() : new BigIntProp();
            }
        }
        return (T)prop;
    }

    @Override
    protected void setDynamicProperty(T prop) {
        super.setDynamicProperty(prop);
        switch (this.getMasterIdType()) {
            case 2: {
                this.setBasedataProp((BasedataProp)prop);
                ((BasedataProp)prop).setMustInput(true);
                break;
            }
            case 0: {
                prop.setDbIgnore(true);
                this.setProp(prop);
                break;
            }
            case 1: {
                this.setProp(prop);
                break;
            }
            default: {
                this.setProp(prop);
            }
        }
    }

    public void setProp(T prop) {
        if (this.getFieldDBType() == 12) {
            ((TextProp)prop).setMaxLenth(36);
            ((TextProp)prop).setSysField(true);
        } else {
            ((BigIntProp)prop).setPrecision(18);
            ((BigIntProp)prop).setScale(0);
            ((BigIntProp)prop).setSysField(true);
        }
    }

    @Override
    public List<Map<String, Object>> createEntityTreeNodes(boolean isAllNode, int level) {
        List<Map<String, Object>> cols = new ArrayList<Map<String, Object>>();
        if (this.getMasterIdType() == 2) {
            cols = this.createRefBasedataTreeNodes(isAllNode, level);
        }
        return cols;
    }

    private void setClientTextEditor(Map<String, Object> editor) {
        editor.put("type", "text");
        if (StringUtils.isNotBlank((Object)this.getEmptyText())) {
            editor.put("emptytip", this.getEmptyText());
        }
        editor.put("maxlength", 36);
        editor.put("minlength", 0);
    }

    private void setClientIntEditor(Map<String, Object> editor) {
        editor.put("type", "number");
        editor.put("nt", "D");
        editor.put("pc", 18);
        editor.put("sc", 0);
    }
}

