/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.entity.businessfield;

import java.util.List;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.database.DbMetadataTable;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.SqlObject;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.PrintCountProp;
import kd.bos.metadata.entity.commonfield.IDBField;
import kd.bos.metadata.entity.commonfield.IntegerField;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class PrintCountField
extends IntegerField {
    private String recordModel;

    @Override
    public String getLock() {
        return "new,edit,view,submit,audit";
    }

    @Override
    protected DecimalProp createDynamicProperty() {
        return new PrintCountProp();
    }

    @SimplePropertyAttribute(name="RecordModel")
    public String getRecordModel() {
        return this.recordModel;
    }

    public void setRecordModel(String recordModel) {
        this.recordModel = recordModel;
    }

    @Override
    public DynamicProperty registerProperty(DynamicObjectType dt) {
        PrintCountProp printCountProp = (PrintCountProp)super.registerProperty(dt);
        printCountProp.setRecordModel(this.recordModel);
        return printCountProp;
    }

    @Override
    public String getDBDefValue() {
        return "0";
    }

    @Override
    public String getCreateTableFieldDesc() {
        String fieldDesc = "";
        if (this.getFieldName() == null || this.getFieldName().isEmpty()) {
            return fieldDesc;
        }
        fieldDesc = String.format("%s BIGINT DEFAULT('%s') %s", this.getFieldName(), this.getDBDefValue(), " NOT NULL");
        StringBuilder sb = new StringBuilder();
        if (fieldDesc.length() > 0) {
            sb.append(fieldDesc).append(",");
            if (this.isPrivacyField()) {
                sb.append(String.format("%s NCLOB NULL,", this.getFieldName() + "_pr"));
            }
            if (this.isEncrypt()) {
                sb.append(String.format("%s NCLOB NULL,", this.getEncryptFieldName()));
            }
        }
        return sb.toString();
    }

    @Override
    public void addAlterTableField(List<SqlObject> sqlList, String tableName, DbMetadataTable tableSchema, List<String> fieldsCommentSql) {
        if (!StringUtils.isEmpty((CharSequence)this.getFieldName())) {
            String sql;
            if (!IDBField.existsFieldInTableSchema(tableSchema, this.getFieldName())) {
                String fieldDesc = "";
                if (this.getFieldName() == null || this.getFieldName().isEmpty()) {
                    return;
                }
                fieldDesc = String.format("%s BIGINT DEFAULT('%s') %s", this.getFieldName(), this.getDBDefValue(), " NOT NULL");
                if (fieldDesc.length() > 0) {
                    String sql2 = String.format("ALTER TABLE %s ADD %s;", tableName, fieldDesc);
                    sqlList.add(new SqlObject(sql2, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
                    this.generateFieldsComment(tableName, fieldsCommentSql);
                }
            }
            if (this.isEncrypt() && !IDBField.existsFieldInTableSchema(tableSchema, this.getEncryptFieldName())) {
                sql = String.format("ALTER TABLE %s ADD %s NCLOB NULL;", tableName, this.getEncryptFieldName());
                sqlList.add(new SqlObject(sql, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
            }
            if (this.isPrivacyField() && !IDBField.existsFieldInTableSchema(tableSchema, this.getFieldName() + "_pr")) {
                sql = String.format("ALTER TABLE %s ADD %s NCLOB NULL;", tableName, this.getFieldName() + "_pr");
                sqlList.add(new SqlObject(sql, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
            }
        }
    }
}

