/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.entity.businessfield;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.RefBillProp;
import kd.bos.entity.property.RefProp;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.RefBillEdit;
import kd.bos.metadata.entity.BillEntity;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.AbstractRefBillField;
import kd.bos.metadata.entity.businessfield.BasedataEntitymetaReader;
import kd.bos.metadata.entity.businessfield.BillNoField;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class RefBillField
extends AbstractRefBillField<RefBillProp> {
    private boolean lableHyperlink;
    private boolean allowAutoList = true;
    private boolean cacheLookUpList = true;
    private boolean viewDetail = true;
    private boolean ignoreRefCheck = false;

    @Override
    public String getFilterControlType() {
        return "basedata";
    }

    @Override
    public String getCompareGroupID() {
        return "0,1,2";
    }

    @SimplePropertyAttribute(name="LableHyperlink")
    @DefaultValueAttribute(value="true")
    public boolean isLableHyperlink() {
        return this.lableHyperlink;
    }

    public void setLableHyperlink(boolean lableHyperlink) {
        this.lableHyperlink = lableHyperlink;
    }

    @SimplePropertyAttribute(name="AllowAutoList")
    @DefaultValueAttribute(value="true")
    public boolean isAllowAutoList() {
        return this.allowAutoList;
    }

    public void setAllowAutoList(boolean allowAutoList) {
        this.allowAutoList = allowAutoList;
    }

    @SimplePropertyAttribute(name="CacheLookUpList")
    @DefaultValueAttribute(value="true")
    public boolean isCacheLookUpList() {
        return this.cacheLookUpList;
    }

    public void setCacheLookUpList(boolean cacheLookUpList) {
        this.cacheLookUpList = cacheLookUpList;
    }

    @SimplePropertyAttribute(name="ViewDetail")
    @DefaultValueAttribute(value="true")
    public boolean isViewDetail() {
        return this.viewDetail;
    }

    public void setViewDetail(boolean viewDetail) {
        this.viewDetail = viewDetail;
    }

    @SimplePropertyAttribute(name="IgnoreRefCheck")
    public boolean isIgnoreRefCheck() {
        return this.ignoreRefCheck;
    }

    public void setIgnoreRefCheck(boolean ignoreRefCheck) {
        this.ignoreRefCheck = ignoreRefCheck;
    }

    @Override
    public int getFieldDBType() {
        EntityMetadata entityMetadata = BasedataEntitymetaReader.readEntityMeta(this.getBillEntityId());
        int pkType = -9;
        for (Entity<?, ?> entity : entityMetadata.getEntitys()) {
            if (!(entity instanceof BillEntity)) continue;
            pkType = ((BillEntity)entity).getPkType() == 0 ? 12 : -5;
            break;
        }
        return pkType;
    }

    @Override
    public int getFieldLen() {
        return 36;
    }

    @Override
    protected FieldEdit createServerEditor() {
        return new RefBillEdit();
    }

    @Override
    protected void setServerEditorProperties(FieldEdit editor) {
        super.setServerEditorProperties(editor);
        this.setServerRefBillEditor((RefBillEdit)editor);
    }

    @Override
    protected RefBillProp createDynamicProperty() {
        return new RefBillProp();
    }

    @Override
    protected void setDynamicProperty(RefBillProp prop) {
        super.setDynamicProperty(prop);
        prop.setMustInput(this.isMustInput());
        prop.setIgnoreRefCheck(this.isIgnoreRefCheck());
        this.setRefBillProp(prop);
    }

    @Override
    public Map<String, Object> createEditor() {
        EntityMetadata em;
        Map<String, Object> ctlRet = super.createEditor();
        this.setClientRefBillEditor(ctlRet);
        if (this.entityMetadata != null && (em = this.getRefBillEntityMeta()) != null) {
            ctlRet.put("ei", em.getKey());
        }
        if (this.lableHyperlink) {
            ctlRet.put("ln", this.lableHyperlink);
        }
        if (!this.allowAutoList) {
            ctlRet.put("al", this.allowAutoList);
        }
        if (!this.cacheLookUpList) {
            ctlRet.put("cl", this.cacheLookUpList);
        }
        if (!this.viewDetail) {
            ctlRet.put("vtb", this.viewDetail);
        }
        return ctlRet;
    }

    @Override
    public List<Map<String, Object>> createEntityTreeNodes(boolean isAllNode, int level) {
        return this.createRefBillTreeNodes(isAllNode, level);
    }

    @Override
    public List<RefProp> getRefProps() {
        long count;
        if (this.getRefBillEntityMeta() != null && this.getRefBillEntityMeta().getItems() != null) {
            for (EntityItem<?> item : this.getRefBillEntityMeta().getItems()) {
                if (!(item instanceof BillNoField)) continue;
                this.setDisplayProp(item.getKey());
                this.setNumberProp(item.getKey());
                this.setEditSearchProp(item.getKey());
                break;
            }
        }
        List<RefProp> refProps = super.getRefProps();
        String dispProp = this.getDisplayProp();
        if (StringUtils.isNotBlank((CharSequence)dispProp) && (count = refProps.stream().filter(r -> dispProp.equalsIgnoreCase(r.getName())).count()) == 0L) {
            RefProp refProp = new RefProp();
            refProp.setName(dispProp);
            refProps.add(refProp);
        }
        return refProps;
    }
}

