/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.entity.commonfield;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.format.IUseRegion;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.FieldDefValue;
import kd.bos.entity.property.FieldDefValueType;
import kd.bos.entity.property.PrivacyProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.DateTimeFormula;
import kd.bos.form.field.FieldEdit;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IPrivacyField;
import kd.bos.metadata.entity.fielddefvalue.DateTimeDefValue;
import kd.bos.metadata.entity.fielddefvalue.DateTimeOrgTZDefValue;
import kd.bos.metadata.entity.fielddefvalue.DefValueDesign;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class DateTimeField
extends Field<DateTimeProp>
implements IUseRegion,
IPrivacyField {
    private static final String BOS_METADATA = "bos-metadata";
    private String minDate;
    private String maxDate;
    private int timeZoneTransType = 0;
    private String relateOrg;
    private int regionType = 2;
    private String defValue;
    private DefValueDesign defValueDesign;
    private boolean useRegion;
    private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private LocaleString emptyText;
    private int privacyType;
    private String optionalRange;

    public DateTimeField() {
        this.defValueType = 2;
    }

    @SimplePropertyAttribute
    public String getMinDate() {
        return this.minDate;
    }

    public void setMinDate(String min) {
        this.minDate = min;
    }

    @SimplePropertyAttribute
    public String getMaxDate() {
        return this.maxDate;
    }

    public void setMaxDate(String max) {
        this.maxDate = max;
    }

    @Override
    public int getFieldDBType() {
        return 91;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="2")
    public int getRegionType() {
        return this.regionType;
    }

    public void setRegionType(int regionType) {
        this.regionType = regionType;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="0")
    public int getTimeZoneTransType() {
        return this.timeZoneTransType;
    }

    public void setTimeZoneTransType(int timeZoneTransType) {
        this.timeZoneTransType = timeZoneTransType;
    }

    @SimplePropertyAttribute
    public String getRelateOrg() {
        return this.relateOrg;
    }

    public void setRelateOrg(String relateOrg) {
        this.relateOrg = relateOrg;
    }

    @SimplePropertyAttribute
    public LocaleString getEmptyText() {
        return this.emptyText;
    }

    public void setEmptyText(LocaleString emptyText) {
        this.emptyText = emptyText;
    }

    @Override
    public Field<?> getControlField() {
        return StringUtils.isNotBlank((CharSequence)this.getRelateOrg()) ? this.entityMetadata.getFieldById(this.getRelateOrg()) : null;
    }

    @Override
    public DateTimeProp createDynamicProperty() {
        return new DateTimeProp();
    }

    @Override
    protected void setDynamicProperty(DateTimeProp prop) {
        EntityItem<?> item;
        super.setDynamicProperty(prop);
        prop.setEncrypt(this.isEncrypt());
        prop.setDefValue((Object)this.getDefValue());
        prop.setDefValue2(this.buildDefValue2());
        if ("ReportFormModel".equals(this.entityMetadata.getModelType()) && this.getTimeZoneTransType() == 2 && StringUtils.isBlank((CharSequence)this.getRelateOrg())) {
            this.addBuildError(2, this.getKey(), String.format(ResManager.loadKDString((String)"\u5b57\u6bb5%s\u8bbe\u4e3a\u7ec4\u7ec7\u65f6\u533a\u65f6\u5fc5\u987b\u5173\u8054\u7ec4\u7ec7\u5b57\u6bb5", (String)"DateTimeField_0", (String)BOS_METADATA, (Object[])new Object[0]), this.getName()));
        }
        prop.setTimeZoneTransType(this.getTimeZoneTransType());
        if (StringUtils.isNotBlank((CharSequence)this.getRelateOrg()) && (item = this.entityMetadata.getItemById(this.getRelateOrg())) != null) {
            prop.setRelateOrg(item.getKey());
        }
        prop.setUseRegion(this.useRegion);
        prop.setRegionType(this.regionType);
        if (StringUtils.isNotBlank((CharSequence)this.getMinDate())) {
            prop.setMinDate(this.toDate(prop.getDateFormat(), this.getMinDate()));
        }
        if (StringUtils.isNotBlank((CharSequence)this.getMaxDate())) {
            prop.setMaxDate(this.toDate(prop.getDateFormat(), this.getMaxDate()));
        }
    }

    private Date toDate(DateFormat format, String expr) {
        Object result = null;
        try {
            return format.parse(expr);
        }
        catch (ParseException parseException) {
            try {
                result = DateTimeFormula.getDateTimeFormula().runFormula(expr, new HashMap());
            }
            catch (Exception exp) {
                throw new KDBizException(ResManager.loadKDString((String)"\u516c\u5f0f\u6267\u884c\u51fa\u9519", (String)"DateTimeField_2", (String)BOS_METADATA, (Object[])new Object[0]));
            }
            if (result == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u516c\u5f0f\u65e0\u6548\uff1a%s", (String)"DateTimeField_4", (String)BOS_METADATA, (Object[])new Object[0]), expr));
            }
            if (result instanceof Date) {
                return (Date)result;
            }
            if (result instanceof String) {
                try {
                    return format.parse((String)result);
                }
                catch (ParseException e) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65e5\u671f\u6700\u5927\u503c\u6700\u5c0f\u503c\u5c5e\u6027\u683c\u5f0f\u5316\u5931\u8d25%s", (String)"DateTimeField_5", (String)BOS_METADATA, (Object[])new Object[0]), expr));
                }
            }
            return (Date)result;
        }
    }

    @Override
    public Map<String, Object> createEditor() {
        EntityItem<?> item;
        Map<String, Object> editor = super.createEditor();
        editor.put("type", "datetime");
        editor.put("min", StringUtils.isNotBlank((CharSequence)this.getMinDate()) ? this.toDate(this.dateFormat, this.getMinDate()) : "");
        editor.put("max", StringUtils.isNotBlank((CharSequence)this.getMaxDate()) ? this.toDate(this.dateFormat, this.getMaxDate()) : "");
        editor.put("regiontype", this.regionType);
        if (StringUtils.isNotBlank((CharSequence)this.getRelateOrg()) && (item = this.entityMetadata.getItemById(this.getRelateOrg())) != null) {
            editor.put("relateorg", item.getKey());
        }
        if (StringUtils.isNotBlank((Object)this.getEmptyText())) {
            editor.put("emptytip", this.getEmptyText());
        }
        return editor;
    }

    @Override
    protected void setServerEditorProperties(FieldEdit editor) {
        DateTimeEdit dateTimeEdit = (DateTimeEdit)editor;
        dateTimeEdit.setMinDate(this.getMinDate());
        dateTimeEdit.setMaxDate(this.getMaxDate());
        dateTimeEdit.setTimeZoneTransType(this.getTimeZoneTransType());
        super.setServerEditorProperties(editor);
    }

    @Override
    protected FieldEdit createServerEditor() {
        return new DateTimeEdit();
    }

    @SimplePropertyAttribute
    public String getDefValue() {
        return this.defValue;
    }

    public void setDefValue(String defValue) {
        this.defValue = defValue;
    }

    @ComplexPropertyAttribute
    public DefValueDesign getDefValueDesign() {
        return this.defValueDesign;
    }

    public void setDefValueDesign(DefValueDesign defValueDesign) {
        this.defValueDesign = defValueDesign;
    }

    @Override
    public String getCompareGroupID() {
        return "5,0,2,4";
    }

    @Override
    @SimplePropertyAttribute
    public int getPrivacyType() {
        return this.privacyType;
    }

    public void setPrivacyType(int privacyType) {
        this.privacyType = privacyType;
    }

    @SimplePropertyAttribute(name="SelectableRange")
    public String getOptionalRange() {
        return null;
    }

    public void setOptionalRange(String optionalRange) {
        this.optionalRange = optionalRange;
    }

    @Override
    public Map<String, Object> createEntityTreeNode() {
        Map<String, Object> col = super.createEntityTreeNode();
        col.put("Type", "DateListColumnAp");
        col.put("CommonFilterApType", "CommonDateFilterColumnAp");
        col.put("MobCommonFilterApType", "MobCommonDateFilterColumnAp");
        col.put("IsMulti", false);
        col.put("Custom", true);
        return col;
    }

    @Override
    public String getFilterControlType() {
        return "datetime";
    }

    private FieldDefValue buildDefValue2() {
        if (this.getDefValueDesign() == null || this.getDefValueDesign().getFuncType() == null) {
            return null;
        }
        FieldDefValue defValue2 = null;
        switch (this.getDefValueDesign().getFuncType()) {
            case "getToday": 
            case "getNow": 
            case "getTodaySysTZ": 
            case "getNowUserTZ": {
                defValue2 = new FieldDefValue();
                defValue2.setDefValueType(FieldDefValueType.Variable);
                defValue2.setVarName(this.getDefValueDesign().getFuncParameter());
                break;
            }
            case "toDate": {
                if (!StringUtils.isNotBlank((CharSequence)this.getDefValueDesign().getFuncParameter())) break;
                DateTimeDefValue toDate = (DateTimeDefValue)SerializationUtils.fromJsonString((String)this.getDefValueDesign().getFuncParameter(), DateTimeDefValue.class);
                defValue2 = toDate.buildDefValue2(this);
                break;
            }
            case "getTodayOrgTZ": {
                if (!StringUtils.isNotBlank((CharSequence)this.getDefValueDesign().getFuncParameter())) break;
                DateTimeOrgTZDefValue getDateOrgTz = (DateTimeOrgTZDefValue)SerializationUtils.fromJsonString((String)this.getDefValueDesign().getFuncParameter(), DateTimeOrgTZDefValue.class);
                defValue2 = new FieldDefValue();
                defValue2.setDefValueType(FieldDefValueType.Reference);
                defValue2.setFuncName(getDateOrgTz.getFuncName());
                defValue2.setFuncParameter(getDateOrgTz.getOrgField());
                break;
            }
        }
        return defValue2;
    }

    public void setUseRegion(boolean useRegion) {
        this.useRegion = useRegion;
    }

    @Override
    public DynamicProperty registerProperty(DynamicObjectType dt) {
        DynamicProperty prop = super.registerProperty(dt);
        if (this.privacyType != 0 && prop != null) {
            boolean dbIgnore = StringUtils.isBlank((CharSequence)this.getFieldName());
            ((DateTimeProp)prop).setPrivacyType((long)this.getPrivacyType());
            ((DateTimeProp)prop).setEncrypt(false);
            PrivacyProp property = new PrivacyProp();
            property.setName(prop.getName() + "_pr");
            property.setAlias(dbIgnore ? "" : prop.getAlias() + "_pr");
            property.setDbIgnore(dbIgnore);
            property.setOriginalPropKey(this.getKey());
            dt.registerSimpleProperty((DynamicSimpleProperty)property);
        }
        return prop;
    }

    public Date getDesignMinDate() {
        if (StringUtils.isBlank((CharSequence)this.getMinDate())) {
            return null;
        }
        return this.toDate(this.dateFormat, this.getMinDate());
    }

    public Date getDesignMaxDate() {
        if (StringUtils.isBlank((CharSequence)this.getMaxDate())) {
            return null;
        }
        return this.toDate(this.dateFormat, this.getMaxDate());
    }

    public FieldDefValue buildDesignDefValue() {
        return this.buildDefValue2();
    }
}

