/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.entity.commonfield;

import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.TextProp;
import kd.bos.form.field.EmailEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.metadata.entity.commonfield.Field;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class EmailField
extends Field<TextProp> {
    private String defValue;
    private LocaleString emptyText;
    private boolean password;
    private int maxLength = 50;

    @Override
    public int getFieldLen() {
        return 70;
    }

    @SimplePropertyAttribute
    public LocaleString getEmptyText() {
        return this.emptyText;
    }

    public void setEmptyText(LocaleString emptyText) {
        this.emptyText = emptyText;
    }

    @Override
    public int getFieldDBType() {
        return -9;
    }

    @Override
    public String getCompareGroupID() {
        return "0,1,2,3";
    }

    @Override
    public TextProp createDynamicProperty() {
        TextProp textProp = new TextProp();
        return textProp;
    }

    @Override
    protected void setDynamicProperty(TextProp prop) {
        super.setDynamicProperty(prop);
        prop.setDefValue((Object)this.getDefValue());
        prop.setMinLenth(0);
        prop.setMaxLenth(this.maxLength);
        prop.setPassword(this.isPassword());
    }

    @Override
    public Map<String, Object> createEditor() {
        Map<String, Object> editor = super.createEditor();
        if (this.isPassword()) {
            editor.put("type", "text");
        } else {
            editor.put("type", "email");
        }
        if (StringUtils.isNotBlank((Object)this.getEmptyText())) {
            editor.put("emptytip", this.getEmptyText());
        }
        editor.put("maxlength", this.maxLength);
        return editor;
    }

    @Override
    protected FieldEdit createServerEditor() {
        EmailEdit edit = new EmailEdit();
        return edit;
    }

    @Override
    public String getFilterControlType() {
        return "text";
    }

    @Override
    public String getRptColFieldType() {
        return "text";
    }

    @SimplePropertyAttribute
    public String getDefValue() {
        return this.defValue;
    }

    public void setDefValue(String defValue) {
        this.defValue = defValue;
    }

    @SimplePropertyAttribute(name="Password")
    public boolean isPassword() {
        return this.password;
    }

    public void setPassword(boolean value) {
        this.password = value;
    }
}

