/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.entity.commonfield;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.BasedataTypeEnum;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.GeoPointProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.GeoPointEdit;
import kd.bos.list.SeqColumnType;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IDBField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class GeoPointField
extends Field<GeoPointProp> {
    private static final String BOS_METADATA = "bos-metadata";
    private static final String TEXT = "text";
    private static final String NUMBER = "number";
    private static final String DECIMAL = "decimal";
    private LocaleString emptyText;
    private static final long serialVersionUID = -6018365604596132945L;
    private String addressFieldName;
    private String longitudeFieldName;
    private String latitudeFieldName;

    @SimplePropertyAttribute
    public String getAddressFieldName() {
        return this.addressFieldName;
    }

    public void setAddressFieldName(String addressFieldName) {
        this.addressFieldName = addressFieldName;
    }

    @SimplePropertyAttribute
    public String getLongitudeFieldName() {
        return this.longitudeFieldName;
    }

    public void setLongitudeFieldName(String longitudeFieldName) {
        this.longitudeFieldName = longitudeFieldName;
    }

    @SimplePropertyAttribute
    public String getLatitudeFieldName() {
        return this.latitudeFieldName;
    }

    public void setLatitudeFieldName(String latitudeFieldName) {
        this.latitudeFieldName = latitudeFieldName;
    }

    @Override
    protected FieldEdit createServerEditor() {
        return new GeoPointEdit();
    }

    @Override
    protected GeoPointProp createDynamicProperty() {
        return new GeoPointProp();
    }

    @SimplePropertyAttribute
    public LocaleString getEmptyText() {
        return this.emptyText;
    }

    public void setEmptyText(LocaleString value) {
        this.emptyText = value;
    }

    @Override
    public DynamicProperty registerProperty(DynamicObjectType dt) {
        DynamicProperty prop = super.registerProperty(dt);
        if (prop == null) {
            throw new NullPointerException("registerproperty error,GeoPointProp is null");
        }
        prop.setDbIgnore(StringUtils.isBlank((CharSequence)this.getFieldName()));
        LocaleString loDisplayName = new LocaleString(this.getKey() + "_" + "lo");
        LocaleString laDisplayName = new LocaleString(this.getKey() + "_" + "la");
        LocaleString addressDisplayName = new LocaleString(this.getKey() + "_" + "ad");
        if (this.getName() != null) {
            this.getName().forEach((k, v) -> {
                loDisplayName.put(k, (Object)String.format("%s_%s", v, ResManager.loadKDString((String)"\u7ecf\u5ea6", (String)"GeoPointField_4", (String)BOS_METADATA, (Object[])new Object[0])));
                laDisplayName.put(k, (Object)String.format("%s_%s", v, ResManager.loadKDString((String)"\u7eac\u5ea6", (String)"GeoPointField_5", (String)BOS_METADATA, (Object[])new Object[0])));
                addressDisplayName.put(k, (Object)String.format("%s_%s", v, ResManager.loadKDString((String)"\u8be6\u7ec6\u5730\u5740", (String)"GeoPointField_6", (String)BOS_METADATA, (Object[])new Object[0])));
            });
        }
        this.registerPointProperty(dt, prop, this.getKey() + "_" + "lo", loDisplayName, this.longitudeFieldName);
        this.registerPointProperty(dt, prop, this.getKey() + "_" + "la", laDisplayName, this.latitudeFieldName);
        TextProp dp = new TextProp();
        dp.setName(this.getKey() + "_" + "ad");
        dp.setAlias(this.addressFieldName);
        dp.setTableGroup(prop.getTableGroup());
        dp.setDisplayName(addressDisplayName);
        dp.setFeatures(this.getFeatures().getValue());
        dp.setSysField(true);
        dp.setDbIgnore(StringUtils.isBlank((CharSequence)this.addressFieldName));
        dt.registerSimpleProperty((DynamicSimpleProperty)dp);
        return prop;
    }

    private void registerPointProperty(DynamicObjectType dt, DynamicProperty prop, String propName, LocaleString displayName, String fldName) {
        DecimalProp dp = new DecimalProp();
        dp.setName(propName);
        dp.setAlias(fldName);
        dp.setTableGroup(prop.getTableGroup());
        dp.setDisplayName(displayName);
        dp.setDbIgnore(StringUtils.isBlank((CharSequence)fldName));
        dp.setEnableNull(true);
        dp.setFeatures(this.getFeatures().getValue());
        dp.setSysField(true);
        dt.registerSimpleProperty((DynamicSimpleProperty)dp);
    }

    @Override
    protected void setDynamicProperty(GeoPointProp prop) {
        String errorMsg;
        super.setDynamicProperty(prop);
        if (StringUtils.isBlank((CharSequence)this.getFieldName())) {
            return;
        }
        String lineSeparator = System.getProperty("line.separator");
        if (StringUtils.isBlank((CharSequence)this.getLongitudeFieldName())) {
            errorMsg = String.format(ResManager.loadKDString((String)" %s.\u7ecf\u5ea6\u5b57\u6bb5\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GeoPointField_7", (String)BOS_METADATA, (Object[])new Object[0]), this.getName().toString());
            this.addBuildError(2, "BaseEntityId", errorMsg + lineSeparator);
        }
        if (StringUtils.isBlank((CharSequence)this.getLatitudeFieldName())) {
            errorMsg = String.format(ResManager.loadKDString((String)" %s.\u7ef4\u5ea6\u5b57\u6bb5\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GeoPointField_8", (String)BOS_METADATA, (Object[])new Object[0]), this.getName().toString());
            this.addBuildError(2, "BaseEntityId", errorMsg + lineSeparator);
        }
        if (StringUtils.isBlank((CharSequence)this.getAddressFieldName())) {
            errorMsg = String.format(ResManager.loadKDString((String)" %s.\u8be6\u7ec6\u5730\u5740\u5b57\u6bb5\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GeoPointField_9", (String)BOS_METADATA, (Object[])new Object[0]), this.getName().toString());
            this.addBuildError(2, "BaseEntityId", errorMsg + lineSeparator);
        }
    }

    @Override
    public Map<String, Object> createEditor() {
        Map<String, Object> editor = super.createEditor();
        editor.put("type", "geopoint");
        if (StringUtils.isNotBlank((Object)this.getEmptyText())) {
            editor.put("emptytip", this.getEmptyText());
        }
        return editor;
    }

    @Override
    public List<Map<String, Object>> createEntityTreeNodes(boolean isAllNode, int level, boolean isIncludeEntry) {
        ArrayList<Map<String, Object>> entityNodes = new ArrayList<Map<String, Object>>();
        entityNodes.add(this.createEntityTreeNodeByName(this.getKey() + "_" + "ad", this.getAddressFieldName(), String.format("%s.%s", this.getName().toString(), new LocaleString(ResManager.loadKDString((String)"\u8be6\u7ec6\u5730\u5740", (String)"GeoPointField_6", (String)BOS_METADATA, (Object[])new Object[0])).toString()), "ListColumnAp", TEXT, TEXT));
        return entityNodes;
    }

    private Map<String, Object> createEntityTreeNodeByName(String key, String fieldName, String name, String type, String clientType, String dataType) {
        HashMap<String, Object> col = new HashMap<String, Object>(5);
        col.put("Id", key);
        col.put("Type", type);
        col.put("DataType", dataType);
        col.put("Name", name);
        col.put("CreateType", 1);
        col.put("compareGroupId", "0,4");
        col.put("IsMulti", false);
        col.put("Custom", false);
        col.put("ZeroShow", true);
        col.put("SeqType", SeqColumnType.NotSeq);
        EntityItem<?> entityItem = this.entityMetadata.getItemById(this.getParentId());
        col.put("EntryEntity", entityItem instanceof EntryEntity);
        col.put("IsBaseData", false);
        col.put("BaseDateType", BasedataTypeEnum.None);
        col.put("ClientType", clientType);
        col.put("FilterApType", "FilterColumnAp");
        col.put("CommonFilterApType", "CommonFilterColumnAp");
        col.put("SchemeFilterApType", "SchemeFilterColumnAp");
        col.put("IsFieldPropAliasEmpty", StringUtils.isBlank((CharSequence)fieldName));
        col.put("Encrypt", this.isEncrypt());
        return col;
    }

    @Override
    public int getFieldDBType() {
        return 2022;
    }

    @Override
    public List<IDBField> getDBFields() {
        ArrayList<IDBField> list = new ArrayList<IDBField>();
        list.add(this);
        DecimalField latitudeField = new DecimalField();
        latitudeField.setFieldName(this.getLatitudeFieldName());
        list.add(latitudeField);
        DecimalField longitudeField = new DecimalField();
        longitudeField.setFieldName(this.getLongitudeFieldName());
        list.add(longitudeField);
        TextField addressField = new TextField();
        addressField.setFieldName(this.getAddressFieldName());
        list.add(addressField);
        return list;
    }
}

