/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.entity.commonfield;

import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.database.DbMetadataTable;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.SqlObject;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IPrivacyField;
import kd.bos.session.SystemPropertyUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public interface IDBField {
    public static final String NVARCHAR_DEFAULT_SQL = "%s NVARCHAR(50) DEFAULT(' ') NOT NULL";
    public static final String BIG_INT = "%s BIGINT";
    public static final String BIG_INT_NOTNULL = "%s BIGINT DEFAULT(%s) NOT NULL";
    public static final String NCLOB_NULL = "%s NCLOB NULL,";
    public static final String ALTER_ADD_SQL = "ALTER TABLE %s ADD %s;";
    public static final String ALTER_ADD_NCLOB_SQL = "ALTER TABLE %s ADD %s NCLOB NULL;";
    public static final String COMMENT_KSQL = "COMMENT ON COLUMN %1$s.%2$s IS '%3$s';";

    default public int getFieldLen() {
        return 50;
    }

    default public int getPrecision() {
        return 23;
    }

    default public int getScale() {
        return 10;
    }

    public int getFieldDBType();

    default public String getDBDefValue() {
        return " ";
    }

    public String getFieldName();

    public static String genFieldDesc(IDBField field) {
        String fieldDesc = "";
        if (field.getFieldName() == null || field.getFieldName().isEmpty()) {
            return fieldDesc;
        }
        switch (field.getFieldDBType()) {
            case 1: {
                fieldDesc = String.format("%s CHAR(1) DEFAULT('%s') NOT NULL", field.getFieldName(), field.getDBDefValue());
                break;
            }
            case 12: {
                fieldDesc = String.format("%s NVARCHAR(%s) DEFAULT('%s') NOT NULL", field.getFieldName(), field.getFieldLen(), field.getDBDefValue());
                break;
            }
            case 2022: {
                fieldDesc = String.format("%s GEOGRAPHY", field.getFieldName());
                break;
            }
            case -9: {
                fieldDesc = String.format("%s NVARCHAR(%s) DEFAULT('%s') NOT NULL", field.getFieldName(), field.getFieldLen(), field.getDBDefValue());
                break;
            }
            case 91: {
                fieldDesc = String.format("%s DATETIME ", field.getFieldName());
                break;
            }
            case 4: {
                if (StringUtils.isNotBlank((CharSequence)field.getDBDefValue())) {
                    fieldDesc = String.format("%s INT DEFAULT('%s') %s", field.getFieldName(), field.getDBDefValue(), " NOT NULL");
                    break;
                }
                fieldDesc = String.format("%s INT", field.getFieldName());
                break;
            }
            case 3: {
                fieldDesc = String.format("%s DECIMAL(%s,%s)", field.getFieldName(), field.getPrecision(), field.getScale());
                break;
            }
            case 2004: {
                fieldDesc = String.format("%s BLOB NULL", field.getFieldName());
                break;
            }
            case 2011: {
                fieldDesc = String.format("%s NCLOB NULL", field.getFieldName());
                break;
            }
            case -5: {
                if (StringUtils.isNotBlank((CharSequence)field.getDBDefValue())) {
                    fieldDesc = String.format(BIG_INT_NOTNULL, field.getFieldName(), field.getDBDefValue());
                    break;
                }
                fieldDesc = String.format(BIG_INT, field.getFieldName());
                break;
            }
            case 2009: {
                fieldDesc = String.format("%s XMLTYPE NULL", field.getFieldName());
                break;
            }
            default: {
                fieldDesc = String.format(NVARCHAR_DEFAULT_SQL, field.getFieldName());
            }
        }
        return fieldDesc;
    }

    default public String getCreateTableFieldDesc() {
        String fieldDesc = IDBField.genFieldDesc(this);
        StringBuilder sb = new StringBuilder();
        if (fieldDesc.length() > 0) {
            sb.append(fieldDesc).append(",");
            if (this.isPrivacyField()) {
                sb.append(String.format(NCLOB_NULL, this.getFieldName() + "_pr"));
            }
            if (this.isEncrypt()) {
                sb.append(String.format(NCLOB_NULL, this.getEncryptFieldName()));
            }
        }
        return sb.toString();
    }

    public boolean isEncrypt();

    public String getEncryptFieldName();

    default public boolean isPrivacyField() {
        return this instanceof IPrivacyField && ((IPrivacyField)((Object)this)).getPrivacyType() > 0;
    }

    default public void addAlterTableField(List<SqlObject> sqlList, String tableName, DbMetadataTable tableSchema) {
        if (!StringUtils.isEmpty((CharSequence)this.getFieldName())) {
            String sql;
            String fieldDesc;
            if (!IDBField.existsFieldInTableSchema(tableSchema, this.getFieldName()) && (fieldDesc = IDBField.genFieldDesc(this)).length() > 0) {
                String sql2 = String.format(ALTER_ADD_SQL, tableName, fieldDesc);
                sqlList.add(new SqlObject(sql2, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
            }
            if (this.isEncrypt() && !IDBField.existsFieldInTableSchema(tableSchema, this.getEncryptFieldName())) {
                sql = String.format(ALTER_ADD_NCLOB_SQL, tableName, this.getEncryptFieldName());
                sqlList.add(new SqlObject(sql, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
            }
            if (this.isPrivacyField() && !IDBField.existsFieldInTableSchema(tableSchema, this.getFieldName() + "_pr")) {
                sql = String.format(ALTER_ADD_NCLOB_SQL, tableName, this.getFieldName() + "_pr");
                sqlList.add(new SqlObject(sql, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
            }
        }
    }

    default public void addAlterTableField(List<SqlObject> sqlList, String tableName, DbMetadataTable tableSchema, List<String> fieldsCommentSql) {
        if (!StringUtils.isEmpty((CharSequence)this.getFieldName())) {
            String sql;
            String fieldDesc;
            if (!IDBField.existsFieldInTableSchema(tableSchema, this.getFieldName()) && (fieldDesc = IDBField.genFieldDesc(this)).length() > 0) {
                String sql2 = String.format(ALTER_ADD_SQL, tableName, fieldDesc);
                sqlList.add(new SqlObject(sql2, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
                this.generateFieldsComment(tableName, fieldsCommentSql);
            }
            if (this.isEncrypt() && !IDBField.existsFieldInTableSchema(tableSchema, this.getEncryptFieldName())) {
                sql = String.format(ALTER_ADD_NCLOB_SQL, tableName, this.getEncryptFieldName());
                sqlList.add(new SqlObject(sql, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
            }
            if (this.isPrivacyField() && !IDBField.existsFieldInTableSchema(tableSchema, this.getFieldName() + "_pr")) {
                sql = String.format(ALTER_ADD_NCLOB_SQL, tableName, this.getFieldName() + "_pr");
                sqlList.add(new SqlObject(sql, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
            }
        }
    }

    public static boolean existsFieldInTableSchema(DbMetadataTable tableSchema, String fieldName) {
        boolean exists = false;
        if (tableSchema != null && !StringUtils.isEmpty((CharSequence)fieldName)) {
            Object value = null;
            exists = tableSchema.getColumns().TryGetValue(fieldName, new RefObject(value));
        }
        return exists;
    }

    default public void generateFieldsComment(String tableName, List<String> fieldsCommentSql) {
        if (SystemPropertyUtils.getBooleanExt((String)RequestContext.get().getTenantId(), (String)"add.fieldcomment").booleanValue() && this instanceof Field) {
            LocaleString fieldLocalName = ((Field)this).getName();
            String fieldName = this.getFieldName();
            if (fieldLocalName != null && StringUtils.isNotBlank((CharSequence)fieldName)) {
                fieldsCommentSql.add(String.format(COMMENT_KSQL, tableName, fieldName, fieldLocalName.getLocaleValue()));
            }
        }
    }
}

