/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.entity.commonfield;

import java.util.Map;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.TextProp;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IPrivacyField;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class TextField
extends Field<TextProp>
implements IPrivacyField {
    private int minLength;
    private int maxLength = 50;
    private boolean password;
    private LocaleString emptyText;
    private LocaleString lockedEmptyTip;
    private boolean showTooltip;
    private int editStyle;
    private String defValue;
    private String textBtnIcon;
    private boolean sensitiveInfo;
    private int privacyType;
    private boolean showEye;
    private boolean yzjVoiceInput;
    private String textFormat = "";

    public TextField() {
        this.defValueType = 1;
        this.mustInputType = 1;
    }

    @SimplePropertyAttribute
    public String getTextBtnIcon() {
        return this.textBtnIcon;
    }

    public void setTextBtnIcon(String textBtnIcon) {
        this.textBtnIcon = textBtnIcon;
    }

    @SimplePropertyAttribute
    public int getMinLength() {
        return this.minLength;
    }

    @Override
    public Map<String, Object> createEntityTreeNode() {
        Map<String, Object> col = super.createEntityTreeNode();
        col.put("Encrypt", this.isEncrypt());
        return col;
    }

    public void setMinLength(int value) {
        this.minLength = value;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="50")
    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int value) {
        this.maxLength = value;
    }

    @SimplePropertyAttribute
    public int getEditStyle() {
        return this.editStyle;
    }

    public void setEditStyle(int editStyle) {
        this.editStyle = editStyle;
    }

    @Override
    public int getFieldDBType() {
        return -9;
    }

    @SimplePropertyAttribute(name="Password")
    public boolean isPassword() {
        return this.password;
    }

    public void setPassword(boolean value) {
        this.password = value;
    }

    @SimplePropertyAttribute(name="SensitiveInfo")
    public boolean isSensitiveInfo() {
        return this.sensitiveInfo;
    }

    public void setSensitiveInfo(boolean sensitiveInfo) {
        this.sensitiveInfo = sensitiveInfo;
    }

    @SimplePropertyAttribute
    public LocaleString getEmptyText() {
        return this.emptyText;
    }

    public void setEmptyText(LocaleString value) {
        this.emptyText = value;
    }

    @SimplePropertyAttribute
    public LocaleString getLockedEmptyTip() {
        return this.lockedEmptyTip;
    }

    public void setLockedEmptyTip(LocaleString lockedEmptyTip) {
        this.lockedEmptyTip = lockedEmptyTip;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="")
    public String getTextFormat() {
        return this.textFormat;
    }

    public void setTextFormat(String textFormat) {
        this.textFormat = textFormat;
    }

    @SimplePropertyAttribute(name="ShowEye")
    @DefaultValueAttribute(value="false")
    public boolean isShowEye() {
        return this.showEye;
    }

    public void setShowEye(boolean showEye) {
        this.showEye = showEye;
    }

    @SimplePropertyAttribute(name="ShowTooltip")
    public boolean isShowTooltip() {
        return this.showTooltip;
    }

    @Override
    public String getCompareGroupID() {
        return "0,1,2,3";
    }

    public void setShowTooltip(boolean value) {
        this.showTooltip = value;
    }

    @Override
    public TextProp createDynamicProperty() {
        TextProp textProp = new TextProp();
        textProp.setPassword(this.isPassword());
        textProp.setShowEye(this.isShowEye());
        return textProp;
    }

    @Override
    protected void setDynamicProperty(TextProp prop) {
        super.setDynamicProperty(prop);
        prop.setEncrypt(this.isEncrypt());
        prop.setMaxLenth(this.getMaxLength());
        prop.setMinLenth(this.getMinLength());
        prop.setDefValue((Object)this.getDefValue());
    }

    @Override
    public Map<String, Object> createEditor() {
        Map<String, Object> editor = super.createEditor();
        if (this.isPassword()) {
            editor.put("type", "passwordbox");
        } else {
            editor.put("type", "text");
        }
        if (StringUtils.isNotBlank((Object)this.getEmptyText())) {
            editor.put("emptytip", this.getEmptyText());
        }
        if (StringUtils.isNotBlank((Object)this.getLockedEmptyTip())) {
            editor.put("lockedemptytip", this.getLockedEmptyTip());
        }
        if (this.isShowTooltip()) {
            editor.put("isshowtooltip", this.isShowTooltip());
        }
        editor.put("maxlength", this.getMaxLength());
        editor.put("minlength", this.minLength);
        switch (this.getEditStyle()) {
            case 0: {
                break;
            }
            case 1: {
                editor.put("eb", false);
                editor.put("showEditButton", true);
                break;
            }
            case 2: {
                editor.put("eb", true);
                editor.put("showEditButton", true);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.getTextBtnIcon())) {
            editor.put("fontClass", this.getTextBtnIcon());
        }
        if (this.isYzjVoiceInput()) {
            editor.put("yzjvi", this.isYzjVoiceInput());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getTextFormat())) {
            editor.put("tfmt", this.getTextFormat());
        }
        if (this.isPassword() && this.isShowEye()) {
            editor.put("showEye", this.isShowEye());
        }
        return editor;
    }

    @Override
    protected FieldEdit createServerEditor() {
        TextEdit edit = new TextEdit();
        edit.setSensitiveInfo(this.isSensitiveInfo());
        return edit;
    }

    @SimplePropertyAttribute
    public String getDefValue() {
        return this.defValue;
    }

    public void setDefValue(String defValue) {
        this.defValue = defValue;
    }

    @Override
    public String getFilterControlType() {
        return "text";
    }

    @Override
    public String getRptColFieldType() {
        return "text";
    }

    @SimplePropertyAttribute(name="YzjVoiceInput")
    public boolean isYzjVoiceInput() {
        return this.yzjVoiceInput;
    }

    public void setYzjVoiceInput(boolean yzjVoiceInput) {
        this.yzjVoiceInput = yzjVoiceInput;
    }

    @Override
    @SimplePropertyAttribute
    public int getPrivacyType() {
        return this.privacyType;
    }

    public void setPrivacyType(int privacyType) {
        this.privacyType = privacyType;
    }

    @Override
    public DynamicProperty registerProperty(DynamicObjectType dt) {
        DynamicProperty prop = super.registerProperty(dt);
        return prop;
    }

    @Override
    public int getFieldLen() {
        int len = this.getMaxLength();
        if (len <= 0) {
            len = 50;
        }
        return len;
    }
}

