/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.entity.operation;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.ISupportInitialize;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractElement;
import kd.bos.metadata.Plugin;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.operation.OpBizRuleElement;
import kd.bos.metadata.entity.operation.OperationParameter;
import kd.bos.metadata.entity.validation.Validation;
import kd.bos.metadata.form.rule.FieldId;
import kd.bos.metadata.perm.PermissionItem;
import kd.sdk.annotation.SdkPublic;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

@SdkPublic
public class Operation
extends AbstractElement
implements ISupportInitialize {
    private static final Log log = LogFactory.getLog(Operation.class);
    private static final String OPERATION_TYPE = "OperationType";
    private static final String MODEL_TYPE = "ModelType";
    private String OperationType;
    private List<Validation> validations = new ArrayList<Validation>();
    private List<Plugin> plugins = new ArrayList<Plugin>();
    private OperationParameter parameter;
    private LocaleString confirmMsg;
    private LocaleString successMsg;
    private List<FieldId> refreshFields = new ArrayList<FieldId>();
    private boolean logEnable;
    private boolean opMessageEnable;
    private boolean saveAndSubmit;
    private PermissionItem permissionItem = new PermissionItem();
    private String permissionItemId;
    private List<OpBizRuleElement> opBizRules = new ArrayList<OpBizRuleElement>();

    @SimplePropertyAttribute
    public String getOperationType() {
        return this.OperationType;
    }

    public void setOperationType(String operationType) {
        this.OperationType = operationType;
    }

    @ComplexPropertyAttribute
    public OperationParameter getParameter() {
        return this.parameter;
    }

    public void setParameter(OperationParameter parameter) {
        this.parameter = parameter;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=Validation.class)
    public List<Validation> getValidations() {
        return this.validations;
    }

    public void setValidations(List<Validation> validations) {
        this.validations = validations;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=Plugin.class)
    public List<Plugin> getPlugins() {
        return this.plugins;
    }

    public void setPlugins(List<Plugin> plugins) {
        this.plugins = plugins;
    }

    @SimplePropertyAttribute
    public String getPermissionItemId() {
        if (this.permissionItemId != null) {
            return this.permissionItemId;
        }
        if (this.permissionItem != null) {
            this.permissionItemId = this.permissionItem.getItemId();
            return this.permissionItem.getItemId();
        }
        return null;
    }

    public void setPermissionItemId(String permissionItemId) {
        this.permissionItemId = permissionItemId;
    }

    @ComplexPropertyAttribute
    @Deprecated
    public PermissionItem getPermissionItem() {
        return this.permissionItem;
    }

    public void setPermissionItem(PermissionItem permissionItems) {
        this.permissionItem = permissionItems;
    }

    public Map<String, Object> createFormOperate() {
        HashMap<String, Object> op = new HashMap<String, Object>();
        op.put("key", this.getKey());
        op.put("type", this.getOperationType());
        return op;
    }

    public Map<String, Object> createEntityOperate(EntityMetadata metadata) {
        Map<String, Object> map;
        HashMap<String, Object> op = new HashMap<String, Object>();
        op.put("key", this.getKey());
        op.put("type", this.getOperationType());
        op.put("name", this.getName());
        ArrayList<Map<String, Object>> validates = new ArrayList<Map<String, Object>>(10);
        for (Validation validation : this.validations) {
            validates.add(validation.createValidate(metadata));
        }
        op.put("validations", validates);
        ArrayList<kd.bos.entity.plugin.Plugin> plugins = new ArrayList<kd.bos.entity.plugin.Plugin>();
        for (Plugin p : this.plugins) {
            if (!p.isEnabled()) continue;
            kd.bos.entity.plugin.Plugin pl = new kd.bos.entity.plugin.Plugin();
            pl.setClassName(p.getClassName());
            pl.setType(p.getType());
            plugins.add(pl);
        }
        op.put("plugins", plugins);
        if (this.parameter != null && (map = this.parameter.createEntityOperateParameter(metadata)) != null) {
            op.put("parameter", map);
        }
        if (!this.opBizRules.isEmpty()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (OpBizRuleElement rule : this.opBizRules) {
                if (!rule.isEnable()) continue;
                arrayList.add(rule.buildRuntimeMetadata());
            }
            op.put("opbiz", arrayList);
        }
        op.put("confirmMsg", this.confirmMsg);
        op.put("successMsg", this.successMsg);
        op.put("refreshFields", this.buildRunTimeRefreshFields(metadata));
        op.put("logEnable", this.logEnable);
        op.put("opMessageEnable", this.opMessageEnable);
        op.put("saveAndSubmit", this.saveAndSubmit);
        return op;
    }

    @Deprecated
    public static Map<String, Map<String, Object>> getOperationTypesMap() {
        HashMap<String, Map<String, Object>> operateTypeMaps = null;
        if (operateTypeMaps == null) {
            List<Map<String, Object>> operateTypes = Operation.getOperationTypes();
            operateTypeMaps = new HashMap<String, Map<String, Object>>(operateTypes.size());
            for (Map<String, Object> opType : operateTypes) {
                operateTypeMaps.put((String)opType.get(OPERATION_TYPE), opType);
            }
        }
        return operateTypeMaps;
    }

    @Deprecated
    public static List<Map<String, Object>> getOperationTypes() {
        ArrayList operateTypes = null;
        if (operateTypes == null) {
            operateTypes = new ArrayList();
            SAXReader reader = new SAXReader();
            Document document = null;
            try (InputStream is = Operation.class.getResourceAsStream("/OperationType.xml");){
                document = reader.read((Reader)new InputStreamReader(is, "UTF-8"));
                Element root = document.getRootElement();
                Iterator iterator = root.elementIterator();
                while (iterator.hasNext()) {
                    Element e = (Element)iterator.next();
                    HashMap<String, String> op = new HashMap<String, String>();
                    op.put("Id", e.elementText("Id"));
                    op.put("Key", e.elementText("Key"));
                    op.put("Name", e.elementText("Name"));
                    op.put(OPERATION_TYPE, e.elementText(OPERATION_TYPE));
                    op.put("WebApi", e.elementText("WebApi"));
                    op.put(MODEL_TYPE, e.elementText(MODEL_TYPE));
                    operateTypes.add(op);
                }
            }
            catch (IOException | DocumentException e) {
                log.error(e);
                throw new KDException(e, BosErrorCode.bOS, new Object[]{ResManager.loadKDString((String)"\u64cd\u4f5c\u7c7b\u578b\u5143\u6570\u636e\u52a0\u8f7d\u5931\u8d25\uff01", (String)"Operation_0", (String)"bos-metadata", (Object[])new Object[0])});
            }
            Object[] sqlParas = new SqlParameter[]{};
            List list = (List)DB.query((DBRoute)DBRoute.meta, (String)"select FID, FKEY, FNAME, FOPERATIONTYPE, FTYPE, FMODELTYPE from T_BAS_Operation", (Object[])sqlParas, (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

                public List<Map<String, Object>> handle(ResultSet rs) throws Exception {
                    ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(10);
                    while (rs.next()) {
                        HashMap<String, Object> op = new HashMap<String, Object>();
                        op.put("Id", rs.getLong("FID"));
                        op.put("Key", rs.getString("FKEY"));
                        op.put("Name", rs.getString("FNAME"));
                        op.put(Operation.OPERATION_TYPE, rs.getString("FOPERATIONTYPE"));
                        op.put(Operation.MODEL_TYPE, rs.getString("FMODELTYPE"));
                        list.add(op);
                    }
                    return list;
                }
            });
            operateTypes.addAll(list);
        }
        return operateTypes;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=FieldId.class)
    public List<FieldId> getRefreshFields() {
        return this.refreshFields;
    }

    public void setRefreshFields(List<FieldId> refreshFields) {
        this.refreshFields = refreshFields;
    }

    private List<FieldId> buildRunTimeRefreshFields(EntityMetadata metadata) {
        ArrayList<FieldId> runtimeFieldIds = new ArrayList<FieldId>();
        Field<?> temp = null;
        for (FieldId f : this.refreshFields) {
            temp = metadata.getFieldById(f.getId());
            runtimeFieldIds.add(temp == null ? f : new FieldId(temp.getKey()));
        }
        return runtimeFieldIds;
    }

    @SimplePropertyAttribute
    public LocaleString getConfirmMsg() {
        return this.confirmMsg;
    }

    public void setConfirmMsg(LocaleString confirmMsg) {
        this.confirmMsg = confirmMsg;
    }

    @SimplePropertyAttribute
    public LocaleString getSuccessMsg() {
        return this.successMsg;
    }

    public void setSuccessMsg(LocaleString successMsg) {
        this.successMsg = successMsg;
    }

    @SimplePropertyAttribute(name="LogEnable")
    public boolean isLogEnable() {
        return this.logEnable;
    }

    public void setLogEnable(boolean logEnable) {
        this.logEnable = logEnable;
    }

    @SimplePropertyAttribute(name="OpMessageEnable")
    public boolean isOpMessageEnable() {
        return this.opMessageEnable;
    }

    public void setOpMessageEnable(boolean opMessageEnable) {
        this.opMessageEnable = opMessageEnable;
    }

    @SimplePropertyAttribute(name="SaveAndSubmit")
    public boolean isSaveAndSubmit() {
        return this.saveAndSubmit;
    }

    public void setSaveAndSubmit(boolean saveAndSubmit) {
        this.saveAndSubmit = saveAndSubmit;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=OpBizRuleElement.class)
    public List<OpBizRuleElement> getOpBizRules() {
        return this.opBizRules;
    }

    public void setOpBizRules(List<OpBizRuleElement> opBizRules) {
        this.opBizRules = opBizRules;
    }

    @Override
    public void endInit() {
        super.endInit();
        this.plugins.sort(new Comparator<Plugin>(){

            @Override
            public int compare(Plugin arg0, Plugin arg1) {
                return arg0.getRowKey() - arg1.getRowKey();
            }
        });
    }
}

