/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.entity.report;

import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.ColumnStyle;
import kd.bos.entity.report.PictureReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.form.field.BasedataPropEdit;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.BasedataPropField;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.report.FieldTypeBuilder;
import kd.bos.metadata.form.control.EntryFieldAp;

public class ReportColumnBuilder {
    public ReportColumn createReportColumn(EntryFieldAp field) {
        ReportColumn column = new ReportColumn();
        this.createReportColumn(field, column);
        return column;
    }

    public void createReportColumn(EntryFieldAp field, ReportColumn column) {
        ColumnStyle style = new ColumnStyle();
        Field<?> f = field.getField();
        String fieldType = FieldTypeBuilder.getFieldType(f);
        if (fieldType != null) {
            column.setFieldType(fieldType);
        }
        if (f instanceof BasedataPropField) {
            BasedataPropEdit edit = (BasedataPropEdit)f.buildServerEditor();
            column.setRefBasedataProp(edit.getRefBasedataProp());
            column.setDisplayProp(edit.getRefDisplayProp());
        } else {
            if (f instanceof DecimalField) {
                column.setScale(((DecimalField)f).getScale());
                if ("default".equalsIgnoreCase(field.getTextAlign()) || StringUtils.isBlank((CharSequence)field.getTextAlign())) {
                    style.setTextAlign("right");
                }
            } else if (f instanceof BasedataField) {
                column.setDisplayProp(((BasedataField)f).getDisplayProp());
            } else if (f instanceof MulBasedataField) {
                column.setDisplayProp(((MulBasedataField)f).getDisplayProp());
            } else if (f instanceof CheckBoxField) {
                column.setCheckBoxReportShowStyle(field.getCheckBoxReportShowStyle());
                column.setOTitleReport(field.getOTitleReport());
                column.setXTitleReport(field.getXTitleReport());
            }
            if (!StringUtils.isEmpty((CharSequence)field.getDataSourceField())) {
                column.setDateIndex(field.getDataSourceField().toLowerCase());
            }
        }
        Map<String, Object> editor = f.createEditor();
        if ("picture".equals(editor.get("type"))) {
            column.setPicture(true);
            if (column instanceof PictureReportColumn && editor.containsKey("lockPreview")) {
                PictureReportColumn pictureReportColumn = (PictureReportColumn)column;
                pictureReportColumn.setEntryLockPreview(((Boolean)editor.get("lockPreview")).booleanValue());
            }
        }
        style.setTextAlign(field.getTextAlign());
        column.setFieldKey(field.getKey());
        column.setCaption(field.getName());
        column.setWidth(field.getWidth());
        if (field.getField() instanceof DecimalField) {
            column.setNeedFormat(((DecimalField)f).isNeedFormat());
            column.setZeroShow(((DecimalField)field.getField()).isZeroShow());
        }
        column.setCtlTips(field.getCtlTips());
        column.setHide(StringUtils.isEmpty((CharSequence)field.getVisible()) || field.isInvisible());
        column.setHyperlink(field.isHyperlink());
        column.setFreeze(field.isFreeze());
        column.setTableHeaderCellBackColor(field.getTableHeaderCellBackColor());
        style.setForeColor(field.getForeColor());
        style.setBackColor(field.getBackColor());
        style.setRadius(field.getRadius());
        style.setFontSize(field.getFontSize());
        column.setStyle(style);
    }
}

