/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.entity.report;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.report.ComboReportColumn;
import kd.bos.entity.report.DateTimeReportColumn;
import kd.bos.entity.report.DecimalReportColumn;
import kd.bos.entity.report.MulComboReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.report.CheckBoxGroupReportColumnBuilder;
import kd.bos.metadata.entity.report.ComboReportColumnBuilder;
import kd.bos.metadata.entity.report.DateTimeReportColumnBuilder;
import kd.bos.metadata.entity.report.DecimalReportColumnBuilder;
import kd.bos.metadata.entity.report.FlexReportColumnBuilder;
import kd.bos.metadata.entity.report.MulBasedataReportColumnBuilder;
import kd.bos.metadata.entity.report.MulComboReportColumnBuilder;
import kd.bos.metadata.entity.report.PictureReportColumnBuilder;
import kd.bos.metadata.entity.report.RadioOptGroupReportColumnBuilder;
import kd.bos.metadata.entity.report.ReportColumnBuilder;
import kd.bos.metadata.entity.report.TextReportColumnBuilder;
import kd.bos.metadata.entity.report.TimeReportColumnBuilder;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ReportColumnFactory {
    private static Map<String, String> fieldTypeMap = new HashMap<String, String>();
    private static boolean isQueryDataSource = false;

    private ReportColumnFactory() {
        throw new IllegalStateException("Utility class");
    }

    public static void setFieldType(String key, String value) {
        fieldTypeMap.put(key, value);
    }

    public static String getFieldType(String key) {
        return fieldTypeMap.get(key);
    }

    public static boolean isQueryDataSource() {
        return isQueryDataSource;
    }

    public static void setQueryDataSource(boolean isQueryDataSource) {
        ReportColumnFactory.isQueryDataSource = isQueryDataSource;
    }

    public static ReportColumn createReportColumnBuilder(EntryFieldAp field) {
        Boolean isQueryDataSource;
        Field<?> f = field.getField();
        String fieldType = f.getClass().getName();
        String className = fieldTypeMap.get(fieldType);
        if (className == null) {
            className = fieldTypeMap.get("default");
        }
        Boolean bl = isQueryDataSource = ThreadCache.get((Object)"isQueryDataSource") instanceof Boolean ? (Boolean)ThreadCache.get((Object)"isQueryDataSource") : Boolean.FALSE;
        if (f instanceof MulBasedataField && !isQueryDataSource.booleanValue()) {
            className = fieldTypeMap.get("default");
        }
        ReportColumnBuilder builder = (ReportColumnBuilder)TypesContainer.getOrRegisterSingletonInstance((String)className);
        return builder.createReportColumn(field);
    }

    public static ReportColumn createTextColumn(LocaleString caption, String fieldKey) {
        ReportColumn column = new ReportColumn();
        column.setCaption(caption);
        column.setFieldKey(fieldKey);
        column.setFieldType("text");
        return column;
    }

    public static ReportColumn createIntegerColumn(LocaleString caption, String fieldKey) {
        ReportColumn column = new ReportColumn();
        column.setCaption(caption);
        column.setFieldKey(fieldKey);
        column.setFieldType("integer");
        return column;
    }

    public static ReportColumn createDecimalColumn(LocaleString caption, String fieldKey, int scale) {
        DecimalReportColumn column = new DecimalReportColumn();
        column.setCaption(caption);
        column.setFieldKey(fieldKey);
        column.setScale(scale);
        column.setFieldType("decimal");
        return column;
    }

    public static ReportColumn createAmountColumn(LocaleString caption, String fieldKey, String currencyField) {
        ReportColumn column = new ReportColumn();
        column.setCaption(caption);
        column.setFieldKey(fieldKey);
        column.setCurrencyField(currencyField);
        column.setFieldType("amount");
        return column;
    }

    public static ReportColumn createPriceColumn(LocaleString caption, String fieldKey, String currencyField) {
        ReportColumn column = new ReportColumn();
        column.setCaption(caption);
        column.setFieldKey(fieldKey);
        column.setCurrencyField(currencyField);
        column.setFieldType("price");
        return column;
    }

    public static ReportColumn createComboColumn(LocaleString caption, String fieldKey, int showStyle, List<ValueMapItem> comboItems) {
        ComboReportColumn column = new ComboReportColumn();
        column.setCaption(caption);
        column.setFieldKey(fieldKey);
        column.setComboShowStyle(showStyle);
        column.setComboItems(comboItems);
        column.setFieldType("combofield");
        return column;
    }

    public static ReportColumn createMulComboColumn(LocaleString caption, String fieldKey, int showStyle, List<ValueMapItem> comboItems) {
        MulComboReportColumn column = new MulComboReportColumn();
        column.setCaption(caption);
        column.setFieldKey(fieldKey);
        column.setComboShowStyle(showStyle);
        column.setComboItems(comboItems);
        column.setFieldType("combofield");
        return column;
    }

    public static ReportColumn createQtyColumn(LocaleString caption, String fieldKey, String measureUnitField) {
        ReportColumn column = new ReportColumn();
        column.setCaption(caption);
        column.setFieldKey(fieldKey);
        column.setMeasureUnitField(measureUnitField);
        column.setFieldType("qty");
        return column;
    }

    public static ReportColumn createBaseDataColumn(LocaleString caption, String fieldKey, String entityId, String displayProp) {
        ReportColumn column = new ReportColumn();
        column.setCaption(caption);
        column.setFieldKey(fieldKey);
        column.setEntityId(entityId);
        column.setDisplayProp(displayProp);
        column.setFieldType("basedata");
        return column;
    }

    public static ReportColumn createFlexColumn(LocaleString caption, String fieldKey, String entityId, String displayProp) {
        ReportColumn column = new ReportColumn();
        column.setCaption(caption);
        column.setFieldKey(fieldKey);
        column.setEntityId(entityId);
        column.setDisplayProp(displayProp);
        column.setFieldType("flex");
        return column;
    }

    public static ReportColumn createBaseDataPropColumn(LocaleString caption, String fieldKey, String refBasedataProp, String displayProp, String fieldType) {
        ReportColumn column = new ReportColumn();
        column.setCaption(caption);
        column.setFieldKey(fieldKey);
        column.setRefBasedataProp(refBasedataProp);
        column.setDisplayProp(displayProp);
        column.setFieldType(fieldType);
        return column;
    }

    public static ReportColumn createDateTimeColumn(LocaleString caption, String fieldKey, String mask) {
        DateTimeReportColumn column = new DateTimeReportColumn();
        column.setCaption(caption);
        column.setFieldKey(fieldKey);
        column.setMask(mask);
        column.setFieldType("date");
        return column;
    }

    static {
        String commonPrefix = "kd.bos.metadata.entity.commonfield.";
        String bussinessPrefix = "kd.bos.metadata.entity.businessfield.";
        fieldTypeMap.put(commonPrefix + "MulComboField", MulComboReportColumnBuilder.class.getName());
        fieldTypeMap.put(commonPrefix + "ComboField", ComboReportColumnBuilder.class.getName());
        fieldTypeMap.put(commonPrefix + "RadioOptGroupField", RadioOptGroupReportColumnBuilder.class.getName());
        fieldTypeMap.put(commonPrefix + "CheckBoxGroupField", CheckBoxGroupReportColumnBuilder.class.getName());
        fieldTypeMap.put(commonPrefix + "DecimalField", DecimalReportColumnBuilder.class.getName());
        fieldTypeMap.put(commonPrefix + "IntegerField", DecimalReportColumnBuilder.class.getName());
        fieldTypeMap.put(commonPrefix + "BigIntField", DecimalReportColumnBuilder.class.getName());
        fieldTypeMap.put(commonPrefix + "StepperField", DecimalReportColumnBuilder.class.getName());
        fieldTypeMap.put(commonPrefix + "FormulaField", DecimalReportColumnBuilder.class.getName());
        fieldTypeMap.put(bussinessPrefix + "QtyField", DecimalReportColumnBuilder.class.getName());
        fieldTypeMap.put(bussinessPrefix + "AmountField", DecimalReportColumnBuilder.class.getName());
        fieldTypeMap.put(bussinessPrefix + "PriceField", DecimalReportColumnBuilder.class.getName());
        fieldTypeMap.put(bussinessPrefix + "BaseUnitqtyField", DecimalReportColumnBuilder.class.getName());
        fieldTypeMap.put(bussinessPrefix + "ItemClassTypeField", ComboReportColumnBuilder.class.getName());
        fieldTypeMap.put(bussinessPrefix + "BillStatusField", ComboReportColumnBuilder.class.getName());
        fieldTypeMap.put(commonPrefix + "RadioGroupField", ComboReportColumnBuilder.class.getName());
        fieldTypeMap.put(commonPrefix + "AttachmentCountField", DecimalReportColumnBuilder.class.getName());
        fieldTypeMap.put(bussinessPrefix + "PrintCountField", DecimalReportColumnBuilder.class.getName());
        fieldTypeMap.put(commonPrefix + "TimeField", TimeReportColumnBuilder.class.getName());
        fieldTypeMap.put(commonPrefix + "DateField", DateTimeReportColumnBuilder.class.getName());
        fieldTypeMap.put(commonPrefix + "DateTimeField", DateTimeReportColumnBuilder.class.getName());
        fieldTypeMap.put(bussinessPrefix + "MulBasedataField", MulBasedataReportColumnBuilder.class.getName());
        fieldTypeMap.put(commonPrefix + "TelephoneField", TextReportColumnBuilder.class.getName());
        fieldTypeMap.put(commonPrefix + "PictureField", PictureReportColumnBuilder.class.getName());
        fieldTypeMap.put(bussinessPrefix + "FlexField", FlexReportColumnBuilder.class.getName());
        fieldTypeMap.put("default", ReportColumnBuilder.class.getName());
    }
}

