/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.entity.rule;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.entity.IIsvFlag;
import kd.bos.entity.rule.BR;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.formula.FormulaEngine;
import kd.bos.metadata.entity.rule.BizRuleAction;
import kd.bos.metadata.exception.ErrorInfo;

public class BizRule
implements IIsvFlag {
    private String id;
    private LocaleString description;
    private boolean enabled = true;
    private String preCondition;
    private LocaleString preDescription = new LocaleString();
    private int seq;
    private List<BizRuleAction> trueActions = new ArrayList<BizRuleAction>();
    private List<BizRuleAction> falseActions = new ArrayList<BizRuleAction>();
    private int raiseEventType;
    private List<ErrorInfo> errorInfos = new ArrayList<ErrorInfo>();
    private Set<String> dependencyFields = new HashSet<String>();
    private static final String BOS_METADATA = "bos-metadata";
    private String isvStr = "";

    public void setIsv(String isvStr) {
        this.isvStr = isvStr;
    }

    public String getIsv() {
        return this.isvStr;
    }

    @SimplePropertyAttribute(isPrimaryKey=true)
    public String getId() {
        if (StringUtils.isBlank((CharSequence)this.id)) {
            this.id = Uuid16.create().toString();
        }
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    @SimplePropertyAttribute
    public int getSeq() {
        return this.seq;
    }

    public void setSeq(int seq) {
        this.seq = seq;
    }

    @SimplePropertyAttribute
    public LocaleString getDescription() {
        return this.description;
    }

    public void setDescription(LocaleString description) {
        this.description = description;
    }

    @SimplePropertyAttribute(name="Enabled")
    @DefaultValueAttribute(value="true")
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @SimplePropertyAttribute
    public int getRET() {
        return this.raiseEventType;
    }

    public void setRET(int raiseEventType) {
        this.raiseEventType = raiseEventType;
    }

    @Deprecated
    public String getPreDescription() {
        String description = this.preDescription.toString();
        return description == null ? "" : description;
    }

    public void setPreDescription(String preDescription) {
        this.preDescription = new LocaleString(preDescription);
    }

    @SimplePropertyAttribute(name="PreDescription")
    public LocaleString getLocalPreDescription() {
        return this.preDescription;
    }

    public void setLocalPreDescription(LocaleString localPreDescription) {
        this.preDescription = localPreDescription;
    }

    @SimplePropertyAttribute
    public String getPreCondition() {
        return this.preCondition;
    }

    public void setPreCondition(String preCondition) {
        this.preCondition = preCondition;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=BizRuleAction.class)
    public List<BizRuleAction> getTrueActions() {
        return this.trueActions;
    }

    public void setTrueActions(List<BizRuleAction> value) {
        if (value != null) {
            this.trueActions = value;
        }
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=BizRuleAction.class)
    public List<BizRuleAction> getFalseActions() {
        return this.falseActions;
    }

    public List<ErrorInfo> getErrorInfos() {
        return this.errorInfos;
    }

    public BR buildEntityRule(String source) {
        this.errorInfos.clear();
        BR rule = new BR();
        rule.setSource(source);
        rule.setPreCondition(this.preCondition);
        rule.setLocalPreDescription(this.preDescription);
        rule.setRET(this.raiseEventType);
        rule.setDescription(this.description == null ? this.preDescription.toString() : this.description.toString());
        rule.setEnabled(this.enabled);
        rule.setSeq(this.seq);
        if (StringUtils.isNotBlank((CharSequence)this.preCondition)) {
            try {
                String[] vars;
                for (String var : vars = FormulaEngine.extractVariables((String)this.preCondition)) {
                    if (!StringUtils.isNotBlank((CharSequence)var)) continue;
                    this.dependencyFields.add(var.split("\\.")[0]);
                }
            }
            catch (Exception e) {
                String formulaValidStr = ResManager.loadKDString((String)"\u8ba1\u7b97\u5b9a\u4e49\u516c\u5f0f\u6821\u9a8c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\uff1a'%s'", (String)"BizRule_0", (String)BOS_METADATA, (Object[])new Object[0]);
                String msg = String.format(formulaValidStr, this.preCondition);
                throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{msg, e});
            }
        }
        this.buildActions(this.trueActions, rule.getTrueActions());
        this.buildActions(this.falseActions, rule.getFalseActions());
        if (!this.dependencyFields.isEmpty()) {
            rule.setDepFldKeys(StringUtils.join((Object[])this.dependencyFields.toArray(), (String)","));
        }
        return rule;
    }

    private void buildActions(List<BizRuleAction> designActions, List<Map<String, Object>> runActions) {
        for (BizRuleAction action : designActions) {
            action.addDependencyFields(this.dependencyFields);
            Map<String, Object> brAction = action.buildAction();
            if (action.getErrorInfos().isEmpty()) {
                runActions.add(brAction);
                this.dependencyFields.addAll(action.getDependencyFields());
                continue;
            }
            this.errorInfos.addAll(action.getErrorInfos());
        }
    }
}

