/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.extensible;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.data.BusinessDataReader;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.BOSRuntime;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.RuntimeMetaType;
import kd.bos.entity.operate.OperationType;
import kd.bos.entity.operate.OperationTypeCache;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.DesignMeta;
import kd.bos.metadata.dao.CacheType;
import kd.bos.metadata.dao.IMetadataNode;
import kd.bos.metadata.dao.MetaCacheUtils;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.entity.DesignEntityMeta;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.RuntimeEntityMeta;
import kd.bos.metadata.entity.commonfield.DropdownItem;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.operation.Operation;
import kd.bos.metadata.exception.ErrorInfo;
import kd.bos.metadata.extensible.BizObjExtMeta;
import kd.bos.metadata.form.BillFormAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.DesignFormMeta;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.RuntimeFormMeta;
import kd.bos.metadata.form.control.ButtonAp;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.util.CollectionUtils;

public class BizObjExtPreviewService {
    private static final Log logger = LogFactory.getLog(BizObjExtPreviewService.class);
    private static final String DELETE_FROM = "delete from ";
    private static final String MOCK_TEST_SUFFIX = "_qkzmt";
    private static final Set<String> operationWhitelist = new HashSet<String>(Arrays.asList("new", "view", "refresh", "first", "previous", "next", "last", "calllist"));
    public static ThreadLocal<String> testObjectCache = new ThreadLocal();

    public static void startTestMode(String id) {
        testObjectCache.set(id);
    }

    public static void endTestMode() {
        testObjectCache.remove();
    }

    public static void fillLocale(IMetadataNode rootNode) {
        if (rootNode == null) {
            return;
        }
        IMetadataNode childNode = rootNode.getChildNode();
        if (childNode != null && childNode.getId().equals(testObjectCache.get())) {
            BizObjExtMeta bizObjExtMeta = (BizObjExtMeta)BusinessDataReader.read((Object)testObjectCache.get(), (IDataEntityType)OrmUtils.getDataEntityType(BizObjExtMeta.class), (Boolean)false);
            if (bizObjExtMeta == null) {
                logger.info("\u6269\u5c55\u5143\u6570\u636e\u4e0d\u5b58\u5728\u3002{}", (Object)testObjectCache.get());
                return;
            }
            if (!"1".equals(bizObjExtMeta.getStatus()) && !"2".equals(bizObjExtMeta.getStatus())) {
                return;
            }
            childNode.setLoacleXml(new LocaleString(""));
        }
        if (childNode != null) {
            BizObjExtPreviewService.fillLocale(childNode);
        }
    }

    public static void changeToPreviewMetadata(DesignMeta designMeta) {
        if (designMeta != null && designMeta.getId().equals(testObjectCache.get())) {
            BizObjExtMeta bizObjExtMeta = (BizObjExtMeta)BusinessDataReader.read((Object)testObjectCache.get(), (IDataEntityType)OrmUtils.getDataEntityType(BizObjExtMeta.class), (Boolean)false);
            if (bizObjExtMeta == null) {
                logger.info("\u6269\u5c55\u5143\u6570\u636e\u4e0d\u5b58\u5728\u3002{}", (Object)testObjectCache.get());
                return;
            }
            if (!"1".equals(bizObjExtMeta.getStatus()) && !"2".equals(bizObjExtMeta.getStatus())) {
                return;
            }
            if (designMeta instanceof DesignFormMeta) {
                if (StringUtils.isNotBlank((CharSequence)bizObjExtMeta.getFormdata())) {
                    designMeta.setDataXml(bizObjExtMeta.getFormdata());
                }
            } else if (designMeta instanceof DesignEntityMeta) {
                if (StringUtils.isNotBlank((CharSequence)bizObjExtMeta.getEntitydata())) {
                    designMeta.setDataXml(bizObjExtMeta.getEntitydata());
                }
            } else {
                logger.info("\u65e0\u6548\u7684\u8bbe\u8ba1\u65f6\u5143\u6570\u636e.{}", (Object)designMeta.getClass().getName());
            }
        }
    }

    private static void throwExceptionIfExistsError(List<ErrorInfo> list) {
        if (list.isEmpty()) {
            return;
        }
        ErrorInfo errorInfo = null;
        for (ErrorInfo e : list) {
            if (e.getLevel() != 2) continue;
            errorInfo = e;
            break;
        }
        if (errorInfo != null) {
            throw new KDBizException(errorInfo.getError());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void buildTestRuntimeMeta(String id) {
        try {
            String key;
            BizObjExtPreviewService.startTestMode(id);
            boolean isNotLayout = false;
            FormMetadata formmetadata = (FormMetadata)MetadataDao.readRuntimeMeta(id, MetaCategory.Form);
            EntityMetadata entitymetdata = (EntityMetadata)MetadataDao.readRuntimeMeta(formmetadata.getEntityId(), MetaCategory.Entity);
            isNotLayout = formmetadata.getId().equals(entitymetdata.getId());
            BizObjExtPreviewService.removeOperation(formmetadata, entitymetdata.getRootEntity().getOperations());
            if (formmetadata.getRootAp() instanceof BillFormAp) {
                BillFormAp billFormAp = (BillFormAp)formmetadata.getRootAp();
                BizObjExtPreviewService.removeOperation(billFormAp.getListMeta(), entitymetdata.getRootEntity().getOperations());
                BizObjExtPreviewService.removeOperation(billFormAp.getMobListMeta(), entitymetdata.getRootEntity().getOperations());
                BizObjExtPreviewService.removeOperation(billFormAp.getMobMeta(), entitymetdata.getRootEntity().getOperations());
            }
            String masterKey = key = formmetadata.getKey();
            String masterId = formmetadata.getId();
            if (!StringUtils.isBlank((CharSequence)formmetadata.getMasterId())) {
                masterKey = MetadataDao.getNumberById(formmetadata.getMasterId());
                masterId = formmetadata.getMasterId();
            }
            formmetadata.bindEntityMetadata(entitymetdata);
            formmetadata.setKey(masterKey + MOCK_TEST_SUFFIX);
            if (isNotLayout) {
                entitymetdata.setKey(masterKey + MOCK_TEST_SUFFIX);
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
            String version = String.format("%s.%s.%s", BOSRuntime.getVersion(), 1, sdf.format(new Date()));
            List<RuntimeFormMeta> runtimeFormMetas = formmetadata.buildRuntimeMetadata(version);
            BizObjExtPreviewService.throwExceptionIfExistsError(formmetadata.getBuildErrors());
            String newId = "A" + masterId.substring(1);
            for (RuntimeFormMeta runtimeFormMeta : runtimeFormMetas) {
                runtimeFormMeta.setId(newId);
                if (runtimeFormMeta.getKey().equals("List") && (runtimeFormMeta.getType() == RuntimeMetaType.List.getValue() || runtimeFormMeta.getType() == RuntimeMetaType.MobList.getValue())) {
                    runtimeFormMeta.setData(runtimeFormMeta.getData().replace(key, masterKey + MOCK_TEST_SUFFIX));
                }
                if (!runtimeFormMeta.getKey().equals("Config") || runtimeFormMeta.getType() != RuntimeMetaType.List.getValue() && runtimeFormMeta.getType() != RuntimeMetaType.MobList.getValue()) continue;
                FormConfig data = (FormConfig)SerializationUtils.fromJsonString((String)runtimeFormMeta.getData(), FormConfig.class);
                data.setListOpenLayoutBill(masterKey + MOCK_TEST_SUFFIX);
                runtimeFormMeta.setData(SerializationUtils.toJsonString((Object)data));
            }
            BizObjExtPreviewService.saveRuntimeMetaToDB(newId, runtimeFormMetas.toArray(), RuntimeFormMeta.class);
            BizObjExtPreviewService.clearCache(formmetadata);
            if (isNotLayout) {
                BizObjExtPreviewService.clearNewFields(entitymetdata);
                List<RuntimeEntityMeta> runtimeEntityMetas = entitymetdata.buildRuntimeMetadata(version);
                BizObjExtPreviewService.throwExceptionIfExistsError(entitymetdata.getBuildErrors());
                for (RuntimeEntityMeta runtimeEntityMeta : runtimeEntityMetas) {
                    runtimeEntityMeta.setId(newId);
                }
                BizObjExtPreviewService.saveRuntimeMetaToDB(newId, runtimeEntityMetas.toArray(), RuntimeEntityMeta.class);
                BizObjExtPreviewService.clearCache(entitymetdata);
            }
        }
        finally {
            BizObjExtPreviewService.endTestMode();
        }
    }

    private static void clearNewFields(EntityMetadata entitymetdata) {
        EntityMetadata parentMetadata = (EntityMetadata)new MetadataReader().readMeta(entitymetdata.getParentId(), OrmUtils.getDataEntityType(DesignEntityMeta.class), true, true);
        HashSet<String> keys = new HashSet<String>(16);
        for (EntityItem<?> item : parentMetadata.getItems()) {
            keys.add(item.getKey());
        }
        String id = entitymetdata.getId();
        for (EntityItem<?> item : entitymetdata.getItems()) {
            if (!(item instanceof Field) || item.getId().equals(id) || keys.contains(item.getKey())) continue;
            ((Field)item).setFieldName("");
        }
    }

    private static void changeOperationType(List<Operation> operationList) {
        if (CollectionUtils.isEmpty(operationList)) {
            return;
        }
        for (Operation operation : operationList) {
            OperationType operationType = OperationTypeCache.LoadSingle((String)operation.getOperationType());
            if (operationType == null || !StringUtils.isNotBlank((CharSequence)operationType.getOpServiceClass())) continue;
            operation.setOperationType("donothing");
        }
    }

    private static void removeOperation(FormMetadata formMetadata, List<Operation> operationList) {
        if (CollectionUtils.isEmpty(operationList)) {
            return;
        }
        if (formMetadata != null) {
            HashSet<String> entityOp = new HashSet<String>(16);
            for (Operation operation : operationList) {
                if (operationWhitelist.contains(operation.getOperationType())) continue;
                entityOp.add(operation.getKey());
            }
            for (ControlAp controlAp : formMetadata.getItems()) {
                List<DropdownItem> dropdownItems;
                if (!(controlAp instanceof ButtonAp)) continue;
                String operationKey = ((ButtonAp)controlAp).getOperationKey();
                if (entityOp.contains(operationKey)) {
                    ((ButtonAp)controlAp).setOperationKey("");
                }
                if (!CollectionUtils.isNotEmpty(dropdownItems = ((ButtonAp)controlAp).getDropdownItems())) continue;
                for (DropdownItem dropdownItem : dropdownItems) {
                    operationKey = dropdownItem.getOperationKey();
                    if (!entityOp.contains(operationKey)) continue;
                    dropdownItem.setOperationKey("");
                }
            }
        }
    }

    private static void clearCache(AbstractMetadata metadata) {
        if (metadata instanceof EntityMetadata) {
            EntityMetadata entityMetadata = (EntityMetadata)metadata;
            MetaCacheUtils.removeDistributeCache(entityMetadata.getKey());
            MetaCacheUtils.removeDistributeCache(metadata.getId(), "entitynumber", 0);
            EntityMetadataCache.removeDataEntityTypeLocalCache((String)entityMetadata.getKey());
            MainEntity rootEntity = entityMetadata.getRootEntity();
            if (StringUtils.isNotBlank((CharSequence)rootEntity.getTableName())) {
                DataEntityCacheManager cm = new DataEntityCacheManager(rootEntity.getTableName());
                cm.removeByDt();
            }
        } else if (metadata instanceof FormMetadata) {
            String key = ((FormMetadata)metadata).getKey();
            String mobKey = String.format("%s_mob", key);
            String filterKey = String.format("%s_filter", key);
            MetaCacheUtils.removeDistributeCache(key, mobKey, filterKey);
            MetaCacheUtils.removeDistributeCache(metadata.getId(), "formnumber", 0);
            FormMetadataCache.removeLocalCache((String)key);
            FormMetadataCache.removeLocalCache((String)mobKey);
            FormMetadataCache.removeLocalCache((String)filterKey);
            String cacheVerKey = CacheType.getCacheVersionKey(key);
            MetaCacheUtils.putDistributeCache(key, cacheVerKey, 0, String.valueOf(new Date().getTime()));
        }
    }

    private static void deleteRuntimeMeta(IDataEntityType runtimeMetaType, String id) {
        ArrayList sqlParams = new ArrayList();
        DBRoute dbRoute = new DBRoute(runtimeMetaType.getDBRouteKey());
        String readSql = "select fnumber, fkey, ftype from " + runtimeMetaType.getAlias() + " where fid = ? ";
        SqlParameter idParam = new SqlParameter("FID", 12, (Object)id);
        ResultSetHandler action = rs -> {
            while (rs.next()) {
                String number = rs.getString(1);
                String key = rs.getString(2);
                int type = rs.getInt(3);
                SqlParameter[] params = new SqlParameter[]{new SqlParameter("FNUMBER", 12, (Object)number), new SqlParameter("FKEY", 12, (Object)key), new SqlParameter("FTYPE", 4, (Object)type)};
                sqlParams.add(params);
            }
            return true;
        };
        DB.query((DBRoute)dbRoute, (String)readSql, (Object[])new SqlParameter[]{idParam}, (ResultSetHandler)action);
        if (!sqlParams.isEmpty()) {
            String deleteSql = DELETE_FROM + runtimeMetaType.getAlias() + " where fnumber = ? and fkey = ? and ftype = ?";
            DB.executeBatch((DBRoute)dbRoute, (String)deleteSql, sqlParams);
        }
    }

    private static void saveRuntimeMetaToDB(String id, Object[] runtimeMetas, Class<?> claz) {
        IDataEntityType runtimeMetaType = OrmUtils.getDataEntityType(claz);
        BizObjExtPreviewService.deleteRuntimeMeta(runtimeMetaType, id);
        BusinessDataWriter.save((IDataEntityType)runtimeMetaType, (Object[])runtimeMetas);
    }
}

