/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.extensible;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.cache.ThreadCache;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractElement;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.entity.DesignEntityMeta;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.operation.Operation;
import kd.bos.metadata.extensible.ExtElement;
import kd.bos.metadata.extensible.ExtLockTypeEnum;
import kd.bos.metadata.extensible.ExtPropertyConfig;
import kd.bos.metadata.extensible.Item;
import kd.bos.metadata.extensible.Prop;
import kd.bos.metadata.form.BillFormAp;
import kd.bos.metadata.form.DesignFormMeta;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.service.CoreLicenseService;

public class ExtensibleDao {
    private static final Log LOG = LogFactory.getLog(ExtensibleDao.class);
    private static final String EXTLOCKTYPELIST = "extlocktypelist";

    private static LocalMemoryCache getLocalCache() {
        return (LocalMemoryCache)ThreadCache.get((Object)"kd.bos.metadata.extensible.ExtensibleDao", () -> {
            CacheConfigInfo info = new CacheConfigInfo();
            info.setTimeout(3600);
            info.setMaxItemSize(10000);
            return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(CacheKeyUtil.getAcctId(), "extconfig", info);
        }, (boolean)true);
    }

    public static ExtLockTypeEnum getExtLockType(AbstractMetadata metadata, String type, String modelType, String element, String property) {
        ExtLockTypeEnum commonExtLockType;
        List<ExtElement> extElements;
        if (metadata == null) {
            return ExtLockTypeEnum.defaults;
        }
        if (!"BillFormModel".equals(modelType) && !"BaseFormModel".equals(modelType)) {
            return ExtLockTypeEnum.defaults;
        }
        if (!"2".equalsIgnoreCase(metadata.getDevType())) {
            return ExtLockTypeEnum.defaults;
        }
        if ("kdxk".equals(metadata.getIsv())) {
            return ExtLockTypeEnum.defaults;
        }
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readMeta(metadata.getMasterId(), MetaCategory.Form);
        if (formMetadata != null && metadata.getIsv().equals(formMetadata.getIsv())) {
            return ExtLockTypeEnum.defaults;
        }
        List<ExtElement> list = extElements = metadata instanceof FormMetadata ? ((FormMetadata)metadata).getExtElements() : ((EntityMetadata)metadata).getExtElements();
        if (extElements != null) {
            for (ExtElement extElement : extElements) {
                if (!extElement.getType().equalsIgnoreCase(type)) continue;
                List<Item> items = extElement.getItems();
                block9: for (Item item : items) {
                    if (!item.getId().equalsIgnoreCase(element)) continue;
                    List<Prop> props = item.getProps();
                    for (Prop prop : props) {
                        if (!prop.getId().equalsIgnoreCase(property)) continue;
                        if (prop.getLockType() == ExtLockTypeEnum.defaults) continue block9;
                        return prop.getLockType();
                    }
                }
            }
        }
        if (!metadata.isEnableGlobalExtLimits()) {
            return ExtLockTypeEnum.defaults;
        }
        switch (type) {
            case "FormRule": {
                commonExtLockType = ExtensibleDao.getCommonExtLockType("Field", modelType, "", "ClientRules");
                if (!StringUtils.isNotBlank((CharSequence)property) || commonExtLockType != ExtLockTypeEnum.speciallock) break;
                commonExtLockType = ExtLockTypeEnum.lock;
                break;
            }
            case "BizRule": {
                commonExtLockType = ExtensibleDao.getCommonExtLockType("Field", modelType, "", "Rules");
                if (!StringUtils.isNotBlank((CharSequence)property) || commonExtLockType != ExtLockTypeEnum.speciallock) break;
                commonExtLockType = ExtLockTypeEnum.lock;
                break;
            }
            default: {
                commonExtLockType = ExtensibleDao.getCommonExtLockType(type, modelType, element, property);
            }
        }
        return commonExtLockType;
    }

    public static ExtLockTypeEnum getOperationExtLockType(AbstractMetadata metadata, String type, String modelType, String opId, String opType, String property) {
        List<ExtElement> extElements;
        if (metadata == null) {
            return ExtLockTypeEnum.defaults;
        }
        if (!"BillFormModel".equals(modelType) && !"BaseFormModel".equals(modelType)) {
            return ExtLockTypeEnum.defaults;
        }
        if (!"2".equalsIgnoreCase(metadata.getDevType())) {
            return ExtLockTypeEnum.defaults;
        }
        if ("kdxk".equals(metadata.getIsv())) {
            return ExtLockTypeEnum.defaults;
        }
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readMeta(metadata.getMasterId(), MetaCategory.Form);
        if (formMetadata != null && metadata.getIsv().equals(formMetadata.getIsv())) {
            return ExtLockTypeEnum.defaults;
        }
        List<ExtElement> list = extElements = metadata instanceof FormMetadata ? ((FormMetadata)metadata).getExtElements() : ((EntityMetadata)metadata).getExtElements();
        if (extElements != null) {
            for (ExtElement extElement : extElements) {
                if (!extElement.getType().equalsIgnoreCase(type)) continue;
                List<Item> items = extElement.getItems();
                block1: for (Item item : items) {
                    if (!item.getId().equalsIgnoreCase(opId)) continue;
                    List<Prop> props = item.getProps();
                    for (Prop prop : props) {
                        if (!prop.getId().equalsIgnoreCase(property)) continue;
                        if (prop.getLockType() == ExtLockTypeEnum.defaults) continue block1;
                        return prop.getLockType();
                    }
                }
            }
        }
        if (!metadata.isEnableGlobalExtLimits()) {
            return ExtLockTypeEnum.defaults;
        }
        return ExtensibleDao.getCommonExtLockType(type, modelType, opType, property);
    }

    public static ExtLockTypeEnum getExtLockType(AbstractMetadata metadata, String type, String modelType, String element, String property, String oriBillIvs) {
        ExtLockTypeEnum commonExtLockType;
        List<ExtElement> extElements;
        if (metadata == null) {
            return ExtLockTypeEnum.defaults;
        }
        if (!"BillFormModel".equals(modelType) && !"BaseFormModel".equals(modelType)) {
            return ExtLockTypeEnum.defaults;
        }
        if (!"2".equalsIgnoreCase(metadata.getDevType())) {
            return ExtLockTypeEnum.defaults;
        }
        if ("kdxk".equals(metadata.getIsv())) {
            return ExtLockTypeEnum.defaults;
        }
        if (metadata.getIsv().equals(oriBillIvs)) {
            return ExtLockTypeEnum.defaults;
        }
        List<ExtElement> list = extElements = metadata instanceof FormMetadata ? ((FormMetadata)metadata).getExtElements() : ((EntityMetadata)metadata).getExtElements();
        if (extElements != null) {
            for (ExtElement extElement : extElements) {
                if (!extElement.getType().equalsIgnoreCase(type)) continue;
                List<Item> items = extElement.getItems();
                block9: for (Item item : items) {
                    if (!item.getId().equalsIgnoreCase(element)) continue;
                    List<Prop> props = item.getProps();
                    for (Prop prop : props) {
                        if (!prop.getId().equalsIgnoreCase(property)) continue;
                        if (prop.getLockType() == ExtLockTypeEnum.defaults) continue block9;
                        return prop.getLockType();
                    }
                }
            }
        }
        if (!metadata.isEnableGlobalExtLimits()) {
            return ExtLockTypeEnum.defaults;
        }
        switch (type) {
            case "FormRule": {
                commonExtLockType = ExtensibleDao.getCommonExtLockType("Field", modelType, "", "ClientRules");
                if (!StringUtils.isNotBlank((CharSequence)property) || commonExtLockType != ExtLockTypeEnum.speciallock) break;
                commonExtLockType = ExtLockTypeEnum.lock;
                break;
            }
            case "BizRule": {
                commonExtLockType = ExtensibleDao.getCommonExtLockType("Field", modelType, "", "Rules");
                if (!StringUtils.isNotBlank((CharSequence)property) || commonExtLockType != ExtLockTypeEnum.speciallock) break;
                commonExtLockType = ExtLockTypeEnum.lock;
                break;
            }
            default: {
                commonExtLockType = ExtensibleDao.getCommonExtLockType(type, modelType, element, property);
            }
        }
        return commonExtLockType;
    }

    public static ExtLockTypeEnum getExtLockType(String entityId, String type, String modelType, String element, String property) {
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readMeta(entityId, MetaCategory.Entity);
        return ExtensibleDao.getExtLockType(entityMetadata, type, modelType, element, property);
    }

    public static Set<String> getBaseOperationPropIds(IPageCache pageCache, String entityId, String opId, String propertyName) {
        String s = pageCache.get("operation_" + opId + "_" + propertyName);
        if (StringUtils.isNotBlank((CharSequence)s)) {
            return (Set)SerializationUtils.fromJsonString((String)s, Set.class);
        }
        DesignEntityMeta designEntityMeta = (DesignEntityMeta)BusinessDataReader.read((Object)entityId, (IDataEntityType)OrmUtils.getDataEntityType(DesignEntityMeta.class), (Boolean)false);
        if (!"2".equals(designEntityMeta.getDevType())) {
            return new HashSet<String>(1);
        }
        AbstractMetadata metadata = ExtensibleDao.getBaseMetadata(designEntityMeta.getParentId(), OrmUtils.getDataEntityType(DesignEntityMeta.class));
        MainEntity mainEntity = (MainEntity)((EntityMetadata)metadata).getItems().get(0);
        List<Operation> items = mainEntity.getOperations();
        Set<String> idSet = ExtensibleDao.getKeySet(items, opId, propertyName);
        pageCache.put("operation_" + opId + "_" + propertyName, SerializationUtils.toJsonString(idSet));
        return idSet;
    }

    public static AbstractMetadata getBaseMetadata(String parentId, MetaCategory metaCategory) {
        return ExtensibleDao.getBaseMetadata(parentId, metaCategory == MetaCategory.Form ? OrmUtils.getDataEntityType(DesignFormMeta.class) : OrmUtils.getDataEntityType(DesignEntityMeta.class));
    }

    protected static AbstractMetadata getBaseMetadata(String parentId, IDataEntityType dataEntityType) {
        return new MetadataReader().readMeta(parentId, dataEntityType, false, true);
    }

    public static Set<String> getBasePropIds(IPageCache pageCache, MetaCategory metaCategory, String entityId, String elementId, String propertyName) {
        return ExtensibleDao.getBasePropIds(pageCache, metaCategory, entityId, elementId, propertyName, true, null);
    }

    public static Set<String> getBasePropIds(IPageCache pageCache, MetaCategory metaCategory, String entityId, String elementId, String propertyName, boolean checkLock, Function<Object, Set<String>> getComplexFunc) {
        String s = pageCache.get("base_" + elementId + "_" + propertyName);
        if (StringUtils.isNotBlank((CharSequence)s)) {
            return (Set)SerializationUtils.fromJsonString((String)s, Set.class);
        }
        AbstractMetadata entityMetadata = MetadataDao.readMeta(entityId, metaCategory);
        if (entityMetadata == null) {
            return Collections.emptySet();
        }
        if (!"2".equals(entityMetadata.getDevType())) {
            return Collections.emptySet();
        }
        ExtLockTypeEnum extLockType = ExtensibleDao.getExtLockType(entityMetadata, "Field", entityMetadata.getModelType(), elementId, propertyName);
        if (checkLock && (extLockType == ExtLockTypeEnum.defaults || extLockType == ExtLockTypeEnum.unlock)) {
            pageCache.put("base_" + elementId + "_" + propertyName, SerializationUtils.toJsonString(Collections.emptySet()));
            return Collections.emptySet();
        }
        AbstractMetadata metadata = new MetadataReader().readMeta(entityMetadata.getParentId(), metaCategory == MetaCategory.Form ? OrmUtils.getDataEntityType(DesignFormMeta.class) : OrmUtils.getDataEntityType(DesignEntityMeta.class), false, true);
        if (metadata == null) {
            return Collections.emptySet();
        }
        List<AbstractElement> items = metaCategory == MetaCategory.Form ? ((FormMetadata)metadata).getItems() : ((EntityMetadata)metadata).getItems();
        Set<String> idSet = ExtensibleDao.getKeySet(items, elementId, propertyName, getComplexFunc);
        if (metaCategory == MetaCategory.Form && ((FormMetadata)metadata).getRootAp() instanceof BillFormAp) {
            FormMetadata mobileListMeta;
            FormMetadata mobileMeta;
            FormMetadata listMeta;
            if (idSet.isEmpty() && (listMeta = ((BillFormAp)((FormMetadata)metadata).getRootAp()).getListMeta()) != null) {
                idSet = ExtensibleDao.getKeySet(listMeta.getItems(), elementId, propertyName, getComplexFunc);
            }
            if (idSet.isEmpty() && (mobileMeta = ((BillFormAp)((FormMetadata)metadata).getRootAp()).getMobMeta()) != null) {
                idSet = ExtensibleDao.getKeySet(mobileMeta.getItems(), elementId, propertyName, getComplexFunc);
            }
            if (idSet.isEmpty() && (mobileListMeta = ((BillFormAp)((FormMetadata)metadata).getRootAp()).getMobListMeta()) != null) {
                idSet = ExtensibleDao.getKeySet(mobileListMeta.getItems(), elementId, propertyName, getComplexFunc);
            }
        }
        pageCache.put("base_" + elementId + "_" + propertyName, SerializationUtils.toJsonString(idSet));
        return idSet;
    }

    private static Set<String> getKeySet(List<?> items, String elementId, String propertyName) {
        return ExtensibleDao.getKeySet(items, elementId, propertyName, null);
    }

    private static Set<String> getKeySet(List<?> items, String elementId, String propertyName, Function<Object, Set<String>> getComplexFunc) {
        for (Object item : items) {
            if (!(item instanceof AbstractElement) || !elementId.equals(((AbstractElement)item).getId())) continue;
            IDataEntityType dataEntityType = OrmUtils.getDataEntityType(item.getClass());
            IDataEntityProperty property = (IDataEntityProperty)dataEntityType.getProperties().get((Object)propertyName);
            if (property != null) {
                Object listValue = property.getValue(item);
                if (listValue instanceof String) {
                    return new HashSet<String>(Collections.singletonList((String)listValue));
                }
                if (listValue != null && !(listValue instanceof List)) {
                    if (getComplexFunc != null) {
                        return getComplexFunc.apply(listValue);
                    }
                    throw new IllegalArgumentException(propertyName);
                }
                List list = (List)listValue;
                HashSet<String> set = new HashSet<String>(16);
                if (list != null && !list.isEmpty()) {
                    Class<?> aClass = list.get(0).getClass();
                    String aClssName = aClass.getSimpleName();
                    if (("DropdownItem".equals(aClssName) || "LongPressItem".equals(aClssName)) && getComplexFunc != null) {
                        return getComplexFunc.apply(listValue);
                    }
                    IDataEntityType propertyType = OrmUtils.getDataEntityType(aClass);
                    ISimpleProperty primaryKey = propertyType.getPrimaryKey();
                    for (Object t : list) {
                        Object value = primaryKey.getValue(t);
                        set.add(value.toString());
                    }
                }
                return set;
            }
            return Collections.emptySet();
        }
        return Collections.emptySet();
    }

    public static ExtLockTypeEnum getCommonExtLockType(String type, String modelType, String element, String property) {
        Map map;
        String key = type + "|" + modelType + "|" + element + "|" + property;
        if (ExtensibleDao.getLocalCache().contains(key)) {
            return (ExtLockTypeEnum)((Object)ExtensibleDao.getLocalCache().get(key));
        }
        if (ExtensibleDao.getLocalCache().contains(EXTLOCKTYPELIST)) {
            map = (Map)ExtensibleDao.getLocalCache().get(EXTLOCKTYPELIST);
        } else {
            map = ExtensibleDao.loadExtPropertyConfigList();
            ExtensibleDao.getLocalCache().put(EXTLOCKTYPELIST, (Object)map);
        }
        ExtPropertyConfig result = null;
        if (map.containsKey(key)) {
            result = (ExtPropertyConfig)map.get(key);
        } else {
            key = type + "|" + modelType + "||" + property;
            result = (ExtPropertyConfig)map.get(key);
            if (result == null) {
                key = type + "||" + element + "|" + property;
                result = (ExtPropertyConfig)map.get(key);
            }
            if (result == null) {
                key = type + "|||" + property;
                result = (ExtPropertyConfig)map.get(key);
            }
        }
        ExtensibleDao.getLocalCache().put(key, (Object)(result == null ? ExtLockTypeEnum.defaults : result.getExtLockType()));
        return result == null ? ExtLockTypeEnum.defaults : result.getExtLockType();
    }

    private static boolean isXK() {
        int modelType = CoreLicenseService.getModelType();
        return 2 == modelType || 4 == modelType;
    }

    private static Map<String, ExtPropertyConfig> loadExtPropertyConfigList() {
        InputStream stream;
        if (ExtensibleDao.isXK()) {
            stream = ExtensibleDao.class.getResourceAsStream("/BizExtendControl/XKExtPropertyConfig.json");
            if (stream == null) {
                stream = ExtensibleDao.class.getResourceAsStream("/ExtendControl/XKExtPropertyConfig.json");
                LOG.info("XK extended control file : /ExtendControl/XKExtPropertyConfig.json");
            } else {
                LOG.info("XK extended control file : /BizExtendControl/XKExtPropertyConfig.json");
            }
        } else {
            stream = ExtensibleDao.class.getResourceAsStream("/BizExtendControl/ExtPropertyConfig.json");
            if (stream == null) {
                stream = ExtensibleDao.class.getResourceAsStream("/ExtendControl/ExtPropertyConfig.json");
                LOG.info("XH extended control file : /ExtendControl/ExtPropertyConfig.json");
            } else {
                LOG.info("XH extended control file : /BizExtendControl/ExtPropertyConfig.json");
            }
        }
        if (stream == null) {
            return Collections.emptyMap();
        }
        HashMap<String, ExtPropertyConfig> extPropertyConfigHashMap = new HashMap<String, ExtPropertyConfig>(16);
        try {
            JSONObject data = JSON.parseObject((String)ExtensibleDao.getContent(stream));
            JSONArray list = data.getJSONArray("data");
            for (int i = 0; i < list.size(); ++i) {
                JSONObject json = list.getJSONObject(i);
                ExtPropertyConfig config = new ExtPropertyConfig();
                config.setType(json.getString("type"));
                config.setModelType(json.getString("modeltype"));
                config.setElement(json.getString("element"));
                config.setPropertyName(json.getString("propertyname"));
                config.setExtLockType(Enum.valueOf(ExtLockTypeEnum.class, json.getString("locktype")));
                extPropertyConfigHashMap.put(config.getType() + "|" + config.getModelType() + "|" + config.getElement() + "|" + config.getPropertyName(), config);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return extPropertyConfigHashMap;
    }

    private static String getContent(InputStream in) throws IOException {
        String content;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] buffer = new byte[1024];
            int len = -1;
            while ((len = in.read(buffer)) != -1) {
                bos.write(buffer, 0, len);
            }
            bos.flush();
            in.close();
            byte[] data = bos.toByteArray();
            content = new String(data, 0, data.length, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return content;
    }

    public static Map<String, Set<String>> getLightProperties(String typeName) {
        Map propertiesMap;
        String localKey = "light_properties_" + typeName;
        if (ExtensibleDao.getLocalCache().contains(localKey)) {
            propertiesMap = (Map)ExtensibleDao.getLocalCache().get(localKey);
        } else {
            propertiesMap = ExtensibleDao.loadLightProperties(typeName);
            ExtensibleDao.getLocalCache().put(localKey, (Object)propertiesMap);
        }
        return propertiesMap;
    }

    private static Map<String, Set<String>> loadLightProperties(String typeName) {
        HashMap<String, Set<String>> properMap = new HashMap<String, Set<String>>(16);
        InputStream lightStream = ExtensibleDao.class.getResourceAsStream("/ExtendControl/LightExtPropertyConfig.json");
        if (lightStream == null) {
            return properMap;
        }
        try {
            JSONObject data = JSON.parseObject((String)ExtensibleDao.getContent(lightStream));
            JSONArray jsonArray = data.getJSONArray(typeName);
            if (jsonArray == null) {
                return properMap;
            }
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject json = jsonArray.getJSONObject(i);
                String incs = json.getString("includeProperties");
                String[] split = StringUtils.split((String)incs, (String)",");
                HashSet<String> propertySet = new HashSet<String>(Arrays.asList(split));
                properMap.put(json.getString("field"), propertySet);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return properMap;
    }
}

