/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.flex;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.db.DBRoute;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.FlexEntityType;
import kd.bos.entity.RuntimeMetaType;
import kd.bos.entity.flex.CreateFlexMetaArgs;
import kd.bos.entity.flex.FlexEntityMetaUtils;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.entity.flex.FlexType;
import kd.bos.entity.plugin.Plugin;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.ControlTypes;
import kd.bos.form.FormConfig;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.FormRoot;
import kd.bos.form.control.Control;
import kd.bos.form.field.AssistantFlexEdit;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.BasedataFlexEdit;
import kd.bos.form.field.DecimalFlexEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.OrgFlexEdit;
import kd.bos.form.field.TextFlexEdit;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.businessfield.AbstractBasedataField;
import kd.bos.metadata.entity.businessfield.AssistantField;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormAp;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.RuntimeFormMeta;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.metadata.form.rule.FormRule;

public class RuntimeFlexMeta {
    private static final Log LOG = LogFactory.getLog(RuntimeFlexMeta.class);
    private static final String BOS_METADATA = "bos-metadata";
    private String localeId = "zh_CN";
    private String entryKey = "entryentity";
    private String uuid;
    private String formNumber;
    private FlexType flexType;
    private String flexFieldKey;
    private List<Long> showFrequentIds = new ArrayList<Long>(10);
    private List<FlexProperty> flexProperties;
    private List<FlexProperty> flexPropertyArrays = new ArrayList<FlexProperty>();
    private List<String> controlJsonStringList;
    private FormConfig formConfig;
    private Map<String, Object> controls;
    private FlexEntityType dt;

    public RuntimeFlexMeta(CreateFlexMetaArgs args) {
        ArrayList<FlexProperty> tmpFlexProperties = new ArrayList();
        if (!args.getPropertyIds().isEmpty()) {
            this.showFrequentIds = args.getShowFrequentIds();
            tmpFlexProperties = FlexEntityMetaUtils.getFlexProperty((List)args.getPropertyIds());
            boolean i = false;
            for (Long id : args.getPropertyIds()) {
                for (FlexProperty flexProperty : tmpFlexProperties) {
                    if (id.longValue() != flexProperty.getId()) continue;
                    this.flexPropertyArrays.add(flexProperty);
                }
            }
        }
        this.initFlexMeta(args.getFormNumber(), args.getFlexFieldKey(), args.getFlexTypeId(), tmpFlexProperties);
    }

    public FormConfig getFormConfig() {
        if (this.formConfig == null) {
            this.buildRuntimeFormMeta();
        }
        return this.formConfig;
    }

    public Map<String, Object> getClientFormMeta() {
        if (this.controls == null) {
            FormAp formAp = this.createFormAp();
            this.controls = formAp.createControl();
            HashMap clientRuleActions = new HashMap();
            if (clientRuleActions.size() > 0) {
                this.controls.put("acts", clientRuleActions);
            }
        }
        return this.controls;
    }

    public List<String> getControls() {
        if (this.controlJsonStringList == null) {
            this.buildRuntimeFormMeta();
        }
        return this.controlJsonStringList;
    }

    public FlexEntityType getDataEntityType() {
        String uid = Uuid8.generateShortUuid();
        if (this.dt == null) {
            this.dt = this.buildRuntimeEntityMeta();
            if (this.dt.getFlexProperties().size() != this.flexProperties.size()) {
                LOG.error(String.format("RuntimeFlexMeta.getDataEntityType.info:1 %s -- dt.getFlexProperties().size()=%s, flexProperties.size()=%s", uid, this.dt.getFlexProperties().size(), this.flexProperties.size()));
            }
        }
        if (this.dt.getFlexProperties().size() != this.flexProperties.size()) {
            LOG.error(String.format("RuntimeFlexMeta.getDataEntityType.info:2  %s -- dt.getFlexProperties().size()=%s, flexProperties.size()=%s", uid, this.dt.getFlexProperties().size(), this.flexProperties.size()));
        }
        return this.dt;
    }

    private void initFlexMeta(String formNumber, String flexFieldKey, int flexTypeId, List<FlexProperty> flexProperties) {
        this.flexFieldKey = flexFieldKey;
        this.flexProperties = flexProperties;
        this.uuid = Uuid8.generateShortUuid();
        this.formNumber = formNumber;
        this.flexType = FlexEntityMetaUtils.getFlexType((int)flexTypeId);
        this.controlJsonStringList = new ArrayList<String>();
    }

    private List<RuntimeFormMeta> buildRuntimeFormMeta() {
        ArrayList<RuntimeFormMeta> runtimeFormMetas = new ArrayList<RuntimeFormMeta>();
        FormConfig formConfig = this.createFormConfig();
        RuntimeFormMeta configMeta = new RuntimeFormMeta();
        configMeta.setId(this.uuid);
        configMeta.setKey(this.flexType.getFormNumber() + "__" + this.flexFieldKey);
        configMeta.setNumber(this.flexType.getFormNumber());
        configMeta.setType(RuntimeMetaType.Config.getValue());
        configMeta.setData(SerializationUtils.toJsonString((Object)formConfig));
        runtimeFormMetas.add(configMeta);
        RuntimeFormMeta verMeta = new RuntimeFormMeta();
        verMeta.setId(this.uuid);
        verMeta.setKey(this.flexType.getFormNumber() + "__" + this.flexFieldKey);
        verMeta.setNumber(this.flexType.getFormNumber());
        verMeta.setType(RuntimeMetaType.Version.getValue());
        verMeta.setData(formConfig.getVersion());
        runtimeFormMetas.add(verMeta);
        this.buildRuntimeControls(runtimeFormMetas);
        this.buildRuntimeClient(runtimeFormMetas);
        return runtimeFormMetas;
    }

    private void buildRuntimeControls(List<RuntimeFormMeta> runtimeFormMetas) {
        this.controlJsonStringList.clear();
        FormRoot container = new FormRoot();
        container.setKey(this.getFlexKey("flexContainer"));
        Container fieldsetpanel = new Container();
        fieldsetpanel.setKey("fieldsetpanelap");
        container.getItems().add(fieldsetpanel);
        for (FlexProperty propertyObject : this.flexPropertyArrays) {
            fieldsetpanel.getItems().add(this.createFieldEdit(propertyObject));
        }
        Container flexpanel = new Container();
        flexpanel.setKey(this.flexType.getFormNumber() + "__flexpanelap");
        container.getItems().add(flexpanel);
        this.buildRuntimeControl(runtimeFormMetas, (Container)container);
    }

    private void buildRuntimeClient(List<RuntimeFormMeta> runtimeFormMetas) {
        FormAp formAp = this.createFormAp();
        Map<String, Object> ctl = formAp.createControl();
        HashMap clientRuleActions = new HashMap();
        if (clientRuleActions.size() > 0) {
            ctl.put("acts", clientRuleActions);
        }
        this.controls = ctl;
        RuntimeFormMeta meta = new RuntimeFormMeta();
        meta.setId(formAp.getId());
        meta.setKey(formAp.getKey());
        meta.setNumber(formAp.getKey());
        meta.setType(RuntimeMetaType.Client.getValue());
        meta.setData(SerializationUtils.toJsonString(ctl));
        runtimeFormMetas.add(meta);
    }

    private FormAp createFormAp() {
        FormAp formAp = new FormAp();
        formAp.setId(this.uuid);
        formAp.setKey(this.flexType.getFormNumber() + "__" + this.flexFieldKey);
        formAp.setName(new LocaleString(this.localeId, this.flexType.getName()));
        formAp.setGrow(0);
        formAp.setAlignItems("stretch");
        formAp.setShrink(0);
        formAp.setDirection("column");
        formAp.setWrap(false);
        FlexPanelAp flexpanelap = new FlexPanelAp();
        Style style = new Style();
        Padding padding = new Padding();
        padding.setBottom("10px");
        padding.setTop("20px");
        style.setPadding(padding);
        flexpanelap.setStyle(style);
        flexpanelap.setKey(this.flexType.getFormNumber() + "__flexpanelap");
        flexpanelap.setName(ResManager.getLocaleString((String)"Flex\u9762\u677f", (String)"RuntimeFlexMeta_0", (String)BOS_METADATA));
        flexpanelap.setGrow(1);
        flexpanelap.setAlignItems("center");
        flexpanelap.setShrink(0);
        List<ControlAp<?>> flexList = flexpanelap.getItems();
        List<ControlAp<?>> list = formAp.getItems();
        if (this.flexPropertyArrays.size() > 6) {
            padding.setLeft("30px");
            padding.setRight("30px");
            formAp.setWidth(new LocaleString(this.localeId, "580px"));
            flexpanelap.setDirection("row");
            flexpanelap.setJustifyContent("space-between");
            flexpanelap.setWrap(true);
        } else {
            formAp.setWidth(new LocaleString(this.localeId, "320px"));
            flexpanelap.setDirection("column");
            flexpanelap.setWrap(false);
        }
        list.add(flexpanelap);
        for (FlexProperty property : this.flexPropertyArrays) {
            flexList.add(this.createControlAp(property));
        }
        return formAp;
    }

    private FlexEntityType buildRuntimeEntityMeta() {
        FlexEntityType dt1 = new FlexEntityType();
        dt1.setName(this.flexType.getFormNumber() + "__" + this.flexFieldKey);
        dt1.setDisplayName(new LocaleString(this.flexType.getName()));
        dt1.setAlias(this.flexType.getFlexDataTable());
        dt1.setFlexDataFormNumber(this.flexType.getFormNumber());
        dt1.setFlexProperties(this.flexPropertyArrays);
        if (this.flexPropertyArrays.size() != this.flexProperties.size()) {
            LOG.error(String.format("RuntimeFlexMeta.buildRuntimeEntityMeta.info: flexPropertyArrays.size()=%s, flexProperties.size()=%s", this.dt.getFlexProperties().size(), this.flexProperties.size()));
        }
        LongProp pkProperty = new LongProp();
        pkProperty.setName("id");
        pkProperty.setDbType(4);
        pkProperty.setAlias("fid");
        pkProperty.setPrimaryKey(true);
        dt1.addProperty((DynamicProperty)pkProperty);
        for (FlexProperty propertyObject : this.flexProperties) {
            FlexProperty.DisplayStyle displayStyle;
            VarcharProp pRefId;
            String refPropName;
            BasedataEntityType baseEntityType;
            String valueSourceNumber;
            if (FlexEntityMetaUtils.isOutLog()) {
                StringBuilder debugStr = new StringBuilder();
                try {
                    debugStr.append("id:").append(propertyObject.getId()).append(';').append(propertyObject.getFlexField()).append(';').append(propertyObject.getOrgFunc()).append(';').append(propertyObject.getIndex()).append(';').append(propertyObject.getNumber()).append(';').append(propertyObject.getValueSource());
                    debugStr.append(System.lineSeparator());
                }
                catch (Exception e) {
                    debugStr.append("getFlexModel debug error:").append(e.getMessage());
                }
                LOG.info(String.format("RuntimeFlexMeta - buildRuntimeEntityMeta propertyObject:%s", debugStr.toString()));
            }
            DynamicProperty dp = this.createProperty(propertyObject);
            dt1.addProperty(dp);
            String valueType = propertyObject.getValueType();
            if ("1".equals(valueType)) {
                valueSourceNumber = propertyObject.getValueSource();
                baseEntityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)valueSourceNumber);
                refPropName = dp.getName() + "_id";
                if (baseEntityType.getPrimaryKey().getPropertyType() == String.class) {
                    pRefId = new VarcharProp(true);
                    pRefId.setPrimaryKey(false);
                    pRefId.setDbIgnore(true);
                    pRefId.setName(refPropName);
                    ((BasedataProp)dp).setRefIdPropName(refPropName);
                    ((BasedataProp)dp).setRefIdProp((IDataEntityProperty)pRefId);
                    dt1.addProperty((DynamicProperty)pRefId);
                } else {
                    pRefId = new LongProp(true);
                    pRefId.setPrimaryKey(false);
                    pRefId.setDbIgnore(true);
                    pRefId.setName(refPropName);
                    ((BasedataProp)dp).setRefIdPropName(refPropName);
                    ((BasedataProp)dp).setRefIdProp((IDataEntityProperty)pRefId);
                    dt1.addProperty((DynamicProperty)pRefId);
                }
                displayStyle = propertyObject.getDisplayStyle();
                ((BasedataProp)dp).setDisplayProp(displayStyle.getDisplayProperty().toString());
                continue;
            }
            if ("2".equals(valueType)) {
                valueSourceNumber = propertyObject.getAssistantType();
                baseEntityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)"bos_assistantdata_detail");
                refPropName = dp.getName() + "_id";
                if (baseEntityType.getPrimaryKey().getPropertyType() == String.class) {
                    pRefId = new VarcharProp(true);
                    pRefId.setPrimaryKey(false);
                    pRefId.setDbIgnore(true);
                    pRefId.setName(refPropName);
                    ((BasedataProp)dp).setRefIdPropName(refPropName);
                    ((BasedataProp)dp).setRefIdProp((IDataEntityProperty)pRefId);
                    dt1.addProperty((DynamicProperty)pRefId);
                } else {
                    pRefId = new LongProp(true);
                    pRefId.setPrimaryKey(false);
                    pRefId.setDbIgnore(true);
                    pRefId.setName(refPropName);
                    ((BasedataProp)dp).setRefIdPropName(refPropName);
                    ((BasedataProp)dp).setRefIdProp((IDataEntityProperty)pRefId);
                    dt1.addProperty((DynamicProperty)pRefId);
                }
                displayStyle = propertyObject.getDisplayStyle();
                ((BasedataProp)dp).setDisplayProp(displayStyle.getDisplayProperty().toString());
                continue;
            }
            if (!"3".equals(valueType)) continue;
        }
        BasedataEntityType flexEntityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)this.flexType.getFormNumber());
        String dbRouteKey = DBRoute.basedata.getRouteKey();
        if (flexEntityType != null && StringUtils.isNotEmpty((CharSequence)flexEntityType.getDBRouteKey())) {
            dbRouteKey = flexEntityType.getDBRouteKey();
        }
        dt1.setDBRouteKey(dbRouteKey);
        return dt1;
    }

    private FormConfig createFormConfig() {
        this.formConfig = new FormConfig();
        this.formConfig.setModelType("form");
        this.formConfig.setEntityTypeId(this.flexType.getNumber());
        this.formConfig.setHasBinderMap(false);
        this.formConfig.setVersion(Long.toString(System.currentTimeMillis()));
        this.formConfig.setCaption(new LocaleString(this.localeId, this.flexType.getName()));
        this.formConfig.setShowTitle(true);
        this.formConfig.setListFormId("");
        this.formConfig.setShowType(ShowType.Floating);
        ArrayList<Plugin> plugins = new ArrayList<Plugin>();
        Plugin plugin = new Plugin();
        plugin.setClassName("kd.bos.form.plugin.FlexFormPlugin");
        plugin.setEnabled(true);
        plugin.setType(0);
        plugins.add(plugin);
        this.formConfig.setPlugins(plugins);
        return this.formConfig;
    }

    private void buildRuntimeControl(List<RuntimeFormMeta> metas, Container container) {
        List list = container.getItems();
        for (Control control : list) {
            if (control instanceof Container) {
                this.buildRuntimeControl(metas, (Container)control);
                continue;
            }
            RuntimeFormMeta meta = new RuntimeFormMeta();
            meta.setId(this.uuid);
            meta.setKey(control.getKey());
            meta.setNumber(this.flexType.getNumber());
            meta.setType(RuntimeMetaType.Control.getValue());
            String controlString = ControlTypes.toJsonString((Object)control);
            this.controlJsonStringList.add(controlString);
            meta.setData(controlString);
            metas.add(meta);
        }
    }

    private List<FormRule> getFormRules() {
        return new ArrayList<FormRule>();
    }

    private ControlAp<?> createControlAp(FlexProperty propertyObject) {
        String id = Uuid8.generateShortUuid();
        LocaleString name = this.getFlexPropertyLocaleName(propertyObject);
        String valuetype = propertyObject.getValueType();
        int index = propertyObject.getIndex();
        String fieldKey = propertyObject.getFlexField();
        Field field = null;
        FieldAp controlAp = new FieldAp();
        if (valuetype.equals("1")) {
            field = new BasedataField();
            ((AbstractBasedataField)field).setDisplayProp(propertyObject.getDisplayStyle().getDisplayProperty().toString());
            ((BasedataField)field).setBaseEntityNumber(propertyObject.getValueSource());
            if (this.showFrequentIds.contains(propertyObject.getId())) {
                ((AbstractBasedataField)field).setShowFrequent(true);
            }
            controlAp.setQuickAddNew(false);
        } else if (valuetype.equals("2")) {
            field = new AssistantField();
            ((AssistantField)field).setDisplayProp(propertyObject.getDisplayStyle().getDisplayProperty().toString());
            ((AssistantField)field).setAsstTypeId(propertyObject.getAssistantType());
            controlAp.setQuickAddNew(false);
            if (this.showFrequentIds.contains(propertyObject.getId())) {
                ((BasedataField)field).setShowFrequent(true);
            }
        } else if (valuetype.equals("3")) {
            Object dataTypeObject = propertyObject.getDataTypeObject();
            if (dataTypeObject instanceof FlexProperty.FlexDecimal) {
                FlexProperty.FlexDecimal fd = (FlexProperty.FlexDecimal)dataTypeObject;
                field = new DecimalField();
                ((DecimalField)field).setPrecision(fd.getPrecision());
                ((DecimalField)field).setScale(fd.getScale());
                String dataScope = String.format("[%s,%s]", fd.getMin(), fd.getMax());
                ((DecimalField)field).setDataScope(dataScope);
                controlAp.setFireUpdEvt(true);
                HashMap<String, Object> cusProp = new HashMap<String, Object>();
                cusProp.put("_isFlexField", true);
                controlAp.setCustomProperties(cusProp);
            } else {
                field = new TextField();
                ((TextField)field).setMaxLength(propertyObject.getDatamaxlen());
                controlAp.setFireUpdEvt(true);
            }
        } else {
            throw new KDException(BosErrorCode.typeMismatch, new Object[]{ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u503c\u7c7b\u578b\uff01", (String)"RuntimeFlexMeta_1", (String)BOS_METADATA, (Object[])new Object[0])});
        }
        controlAp.setId(id);
        controlAp.setKey(this.getFlexKey(fieldKey));
        controlAp.setName(name);
        controlAp.setField(field);
        controlAp.setIndex(index);
        Style style = new Style();
        Margin margin = new Margin();
        margin.setRight("0");
        style.setMargin(margin);
        controlAp.setStyle(style);
        controlAp.setLock("");
        return controlAp;
    }

    private LocaleString getFlexPropertyLocaleName(FlexProperty fp) {
        LocaleString name = fp.getName();
        if (name == null) {
            name = new LocaleString(fp.getGLName());
        } else if (StringUtils.isBlank((CharSequence)((CharSequence)name.get((Object)Lang.get().toString()))) && StringUtils.isNotBlank((CharSequence)fp.getGLName())) {
            name = new LocaleString(fp.getGLName());
        }
        return name;
    }

    private DynamicProperty createProperty(FlexProperty flexProperty) {
        return FlexEntityMetaUtils.createProperty((String)this.flexFieldKey, (FlexProperty)flexProperty);
    }

    private FieldEdit createFieldEdit(FlexProperty propertyObject) {
        String valueType = propertyObject.getValueType();
        String fieldKey = propertyObject.getFlexField();
        String dataType = propertyObject.getDataType();
        AssistantFlexEdit fieldEdit = null;
        if ("1".equals(valueType)) {
            OrgProp prop;
            if (FlexEntityMetaUtils.isOutLog()) {
                LOG.info(String.format("RuntimeFlexMeta - createFieldEdit fieldKey:%s, orgfuncid:%d, number:%s", fieldKey, propertyObject.getOrgFunc(), propertyObject.getOrgFuncNumber()));
            }
            if (propertyObject.getOrgFunc() != 0L) {
                fieldEdit = new OrgFlexEdit();
                prop = new OrgProp();
                prop.setOrgFunc(propertyObject.getOrgFuncNumber());
                ((OrgFlexEdit)fieldEdit).setDisplayProp(fieldKey);
                ((OrgFlexEdit)fieldEdit).setBasedataValueCondition(propertyObject.getBasedataValueCondition());
                ((OrgFlexEdit)fieldEdit).setProperty((IDataEntityProperty)prop);
            } else {
                fieldEdit = new BasedataFlexEdit();
                prop = new BasedataProp();
                ((BasedataFlexEdit)fieldEdit).setDisplayProp(fieldKey);
                ((BasedataFlexEdit)fieldEdit).setBasedataValueCondition(propertyObject.getBasedataValueCondition());
                ((BasedataFlexEdit)fieldEdit).setProperty((IDataEntityProperty)prop);
            }
            BasedataEntityType sourceType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)propertyObject.getValueSource());
            ((BasedataProp)prop).setAlias(fieldKey);
            ((BasedataProp)prop).setDisplayName(this.getFlexPropertyLocaleName(propertyObject));
            String numberPropKey = sourceType.getNumberProperty();
            String nameKey = sourceType.getNameProperty();
            ((BasedataProp)prop).setNumberProp(numberPropKey);
            ((BasedataProp)prop).setName(this.getFlexKey(fieldKey));
            ((BasedataProp)prop).setBaseEntityId(sourceType.getName());
            ((BasedataProp)prop).setDisplayProp(nameKey);
            if (this.showFrequentIds.contains(propertyObject.getId())) {
                ((BasedataEdit)fieldEdit).setShowFrequent(true);
            }
        } else if ("2".equals(valueType)) {
            fieldEdit = new AssistantFlexEdit();
            fieldEdit.setDisplayProp(fieldKey);
            BasedataEntityType sourceType = (BasedataEntityType)EntityMetadataCache.getDataEntityTypeById((String)"b649c83f00000aac");
            String numberPropKey = sourceType.getNumberProperty();
            String nameKey = sourceType.getNameProperty();
            AssistantProp prop = new AssistantProp();
            prop.setAlias(fieldKey);
            prop.setDisplayName(this.getFlexPropertyLocaleName(propertyObject));
            prop.setNumberProp(numberPropKey);
            prop.setName(this.getFlexKey(fieldKey));
            prop.setBaseEntityId(sourceType.getName());
            prop.setDisplayProp(nameKey);
            prop.setAsstTypeId(propertyObject.getAssistantType());
            fieldEdit.setProperty((IDataEntityProperty)prop);
            fieldEdit.setF7MultipleSelect(false);
            if (this.showFrequentIds.contains(propertyObject.getId())) {
                ((BasedataEdit)fieldEdit).setShowFrequent(true);
            }
        } else if ("3".equals(valueType)) {
            Object dataTypeObject = propertyObject.getDataTypeObject();
            if (dataTypeObject instanceof FlexProperty.FlexDecimal) {
                FlexProperty.FlexDecimal fd = (FlexProperty.FlexDecimal)dataTypeObject;
                fieldEdit = new DecimalFlexEdit();
            } else {
                fieldEdit = new TextFlexEdit();
            }
        } else {
            throw new KDException(BosErrorCode.bOSNotImplemented, new Object[]{ResManager.loadKDString((String)"\u672a\u5b9e\u73b0", (String)"RuntimeFlexMeta_2", (String)BOS_METADATA, (Object[])new Object[0])});
        }
        fieldEdit.setKey(this.getFlexKey(fieldKey));
        fieldEdit.setFieldKey(this.getFlexKey(fieldKey));
        fieldEdit.setEntryKey(this.entryKey);
        return fieldEdit;
    }

    private String getFlexKey(String key) {
        return String.format("$$%s__%s", this.flexFieldKey, key);
    }
}

