/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.form;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.form.FormConfig;
import kd.bos.form.ShowType;
import kd.bos.metadata.Plugin;
import kd.bos.metadata.form.FormAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.IBillListAp;
import kd.bos.metadata.form.RuntimeFormMeta;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class BillFormAp
extends FormAp {
    private FormMetadata listMeta;
    private FormMetadata moblistMeta;
    private FormMetadata mobMeta;
    private boolean showWidget;
    private static final String GENLISTID = "_BillList_";

    @ComplexPropertyAttribute
    public FormMetadata getMobMeta() {
        return this.mobMeta;
    }

    public void setMobMeta(FormMetadata mobMeta) {
        this.mobMeta = mobMeta;
    }

    @ComplexPropertyAttribute
    public FormMetadata getListMeta() {
        return this.listMeta;
    }

    public void setListMeta(FormMetadata listMeta) {
        this.listMeta = listMeta;
    }

    @ComplexPropertyAttribute
    public FormMetadata getMobListMeta() {
        return this.moblistMeta;
    }

    public void setMobListMeta(FormMetadata moblistMeta) {
        this.moblistMeta = moblistMeta;
    }

    @SimplePropertyAttribute(name="ShowWidget")
    public boolean isShowWidget() {
        return this.showWidget;
    }

    public void setShowWidget(boolean showWidget) {
        this.showWidget = showWidget;
    }

    @Override
    public FormConfig createFormConfig() {
        FormConfig config = super.createFormConfig();
        config.setShowWidget(this.showWidget);
        return config;
    }

    @Override
    public FormConfig createFormConfig(boolean isQingView) {
        FormConfig config = super.createFormConfig(isQingView);
        FormMetadata listMeta2 = this.getListMeta();
        if (listMeta2 != null) {
            config.setViewShowType(ShowType.valueOf((String)listMeta2.getRootAp().getShowType()));
        }
        return config;
    }

    @Override
    public Map<String, Object> createControl() {
        Map<String, Object> ctl = super.createControl();
        ctl.put("type", "billform");
        return ctl;
    }

    @Override
    protected String getModelType() {
        return "bill";
    }

    @Override
    public Map<String, Object> createDesignerControl() {
        if (this.listMeta != null && this.formMetadata != null && this.formMetadata.getBuildContext() != null && this.formMetadata.getBuildContext().isNewPage()) {
            this.listMeta.setBuildContext(this.formMetadata.getBuildContext());
            this.listMeta.builderDesgnerControls();
        }
        return super.createDesignerControl();
    }

    @Override
    public void buildRuntimeMeta(List<RuntimeFormMeta> metas, String runtimeVersion) {
        super.buildRuntimeMeta(metas, runtimeVersion);
        this.buildList(metas, runtimeVersion);
        this.buildMobList(metas, runtimeVersion);
        this.buildMobBill(metas, runtimeVersion);
    }

    @Override
    protected void setEntityType(FormConfig config) {
        config.setEntityTypeId(this.getEntity().getKey());
    }

    @Override
    public void initializeJsPlugin() {
        super.initializeJsPlugin();
        if (this.mobMeta != null && this.mobMeta.getItems().size() > 0) {
            FormAp mobFormAp = (FormAp)this.mobMeta.getItems().get(0);
            Plugin designJsPlugin = new Plugin();
            designJsPlugin.setRowKey(mobFormAp.getJsPlugins().size());
            designJsPlugin.setEnabled(true);
            designJsPlugin.setFpk(Uuid8.generateShortUuid());
            String className = this.getId() + "_mob_" + designJsPlugin.getFpk();
            designJsPlugin.setClassName(className);
            designJsPlugin.setSourceNumber(this.getKey() + "_mob");
            designJsPlugin.setSourceName(this.getName());
            mobFormAp.getJsPlugins().add(designJsPlugin);
        }
    }

    private void buildList(List<RuntimeFormMeta> metas, String runtimeVersion) {
        FormMetadata listMeta = this.getListMeta();
        if (listMeta != null) {
            listMeta.setBuildContext(this.formMetadata.getBuildContext());
            if (listMeta != null && listMeta.getRootAp() != null) {
                listMeta.bindEntityMetadata(this.formMetadata.getEntityMetadata());
                listMeta.setBizappId(this.formMetadata.getBizappId());
                listMeta.createIndex();
                IBillListAp billListAp = (IBillListAp)((Object)listMeta.getItem(GENLISTID));
                billListAp.buildList(this.formMetadata, listMeta, metas, runtimeVersion);
            }
        }
    }

    private void buildMobList(List<RuntimeFormMeta> metas, String runtimeVersion) {
        FormMetadata listMeta = this.getMobListMeta();
        if (listMeta != null) {
            listMeta.setBuildContext(this.formMetadata.getBuildContext());
            if (listMeta != null && listMeta.getRootAp() != null) {
                listMeta.bindEntityMetadata(this.formMetadata.getEntityMetadata());
                listMeta.setBizappId(this.formMetadata.getBizappId());
                listMeta.createIndex();
                IBillListAp billListAp = (IBillListAp)((Object)listMeta.getItem(GENLISTID));
                billListAp.buildMobList(this.formMetadata, listMeta, metas, runtimeVersion);
            }
        }
    }

    private void buildMobBill(List<RuntimeFormMeta> metas, String runtimeVersion) {
        FormMetadata mobMeta = this.getMobMeta();
        if (mobMeta != null) {
            mobMeta.bindEntityMetadata(this.formMetadata.getEntityMetadata());
            mobMeta.setBizappId(this.formMetadata.getBizappId());
            mobMeta.setBuildContext(this.formMetadata.getBuildContext());
            List<RuntimeFormMeta> mobMetas = mobMeta.buildRuntimeMetadata(runtimeVersion);
            for (RuntimeFormMeta meta : mobMetas) {
                meta.setId(this.formMetadata.getId());
                String key = meta.getKey();
                String number = meta.getNumber();
                meta.setNumber(this.formMetadata.getKey() + "_mob");
                if (!key.equals(number)) continue;
                meta.setKey(meta.getNumber());
            }
            metas.addAll(mobMetas);
        }
    }
}

