/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.form;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.ISupportInitialize;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.container.Container;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.exception.ErrorInfo;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.collap.FieldId;
import kd.bos.metadata.form.control.FlatFieldAp;
import kd.bos.script.annotations.KSMethod;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ContainerAp<T extends Container>
extends ControlAp<Container>
implements ISupportInitialize {
    private static final String DEFAULT = "default";
    private List<ControlAp<?>> controls = new ArrayList();
    private String bkRepeat;
    private boolean bkFull;
    private String backgroundImg;
    private String alignContent = "default";
    private String justifyContent = "default";
    private String alignItems = "default";
    private boolean collapsible = false;
    private boolean defaultcollapse = false;
    private String titleBackColor;
    private boolean clickable = false;
    private boolean shadow = false;
    private String overflow = "auto";
    private List<FieldId> collapFields = new ArrayList<FieldId>();

    public ContainerAp() {
        this.setGrow(1);
    }

    @KSMethod
    public List<ControlAp<?>> getItems() {
        return this.controls;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="auto")
    public String getOverflow() {
        return this.overflow;
    }

    public void setOverflow(String overflow) {
        this.overflow = overflow;
    }

    @SimplePropertyAttribute
    public String getBackgroundImg() {
        return this.backgroundImg;
    }

    public void setBackgroundImg(String backgroundImg) {
        this.backgroundImg = backgroundImg;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=FieldId.class)
    public List<FieldId> getCollapFields() {
        return this.collapFields;
    }

    @SimplePropertyAttribute
    public String getBKRepeat() {
        return this.bkRepeat;
    }

    public void setBKRepeat(String bkRepeat) {
        this.bkRepeat = bkRepeat;
    }

    @SimplePropertyAttribute(name="BKFull")
    public boolean isBKFull() {
        return this.bkFull;
    }

    public void setBKFull(boolean bkFull) {
        this.bkFull = bkFull;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="default")
    public String getAlignContent() {
        return this.alignContent;
    }

    public void setAlignContent(String alignContent) {
        this.alignContent = alignContent;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="default")
    public String getJustifyContent() {
        return this.justifyContent;
    }

    public void setJustifyContent(String justifyContent) {
        this.justifyContent = justifyContent;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="default")
    public String getAlignItems() {
        return this.alignItems;
    }

    public void setAlignItems(String alignItems) {
        this.alignItems = alignItems;
    }

    @Override
    @SimplePropertyAttribute
    @DefaultValueAttribute(value="1")
    public int getGrow() {
        return super.getGrow();
    }

    @SimplePropertyAttribute(name="Collapsible")
    public boolean isCollapsible() {
        return this.collapsible;
    }

    @SimplePropertyAttribute(name="Clickable")
    public boolean isClickable() {
        return this.clickable;
    }

    public void setCollapsible(boolean collapsible) {
        this.collapsible = collapsible;
    }

    public void setClickable(boolean clickable) {
        this.clickable = clickable;
    }

    @SimplePropertyAttribute
    public String getTitleBackColor() {
        return this.titleBackColor;
    }

    public void setTitleBackColor(String titleBackColor) {
        this.titleBackColor = titleBackColor;
    }

    @Override
    public Map<String, Object> createControl() {
        Map<String, Object> ctl = super.createControl();
        if (StringUtils.isNotBlank((CharSequence)this.backgroundImg)) {
            ctl.put("bgik", this.backgroundImg);
        }
        if (StringUtils.isNotBlank((CharSequence)this.bkRepeat)) {
            ctl.put("bgr", this.bkRepeat);
        }
        if (this.isBKFull()) {
            ctl.put("bgf", true);
        }
        if (!DEFAULT.equals(this.alignContent)) {
            ctl.put("ac", this.alignContent);
        }
        if (!DEFAULT.equals(this.alignItems)) {
            ctl.put("ai", this.alignItems);
        }
        if (!DEFAULT.equals(this.justifyContent)) {
            ctl.put("jc", this.justifyContent);
        }
        if (!"auto".equals(this.overflow)) {
            ctl.put("of", this.overflow);
        }
        if (this.isCollapsible()) {
            ctl.put("collapsible", true);
            List<String> fields = this.getCollapsibleField();
            if (fields.size() > 0) {
                ctl.put("cf", fields);
            }
            if (this.isDefaultcollapse()) {
                ctl.put("defaultcollapse", true);
            }
            if (StringUtils.isNotBlank((CharSequence)this.getTitleBackColor())) {
                ctl.put("tbc", this.getTitleBackColor());
            }
        }
        if (this.isClickable()) {
            ctl.put("clickable", true);
        }
        if (this.isShadow()) {
            ctl.put("shadow", true);
        }
        this.createChildControls(ctl);
        return ctl;
    }

    protected void createChildControls(Map<String, Object> ctl) {
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>();
        for (ControlAp<?> ctlAp : this.getItems()) {
            if (ctlAp.isHidden() || !StringUtils.isNotBlank((CharSequence)ctlAp.getVisible()) || ctlAp instanceof FlatFieldAp && ((FlatFieldAp)ctlAp).getField() == null) continue;
            items.add(ctlAp.createControl());
        }
        ctl.put("items", items);
    }

    @Override
    public Map<String, Object> createDesignerControl() {
        Map<String, Object> ctl = super.createDesignerControl();
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>(10);
        for (ControlAp<?> ctlAp : this.getItems()) {
            items.add(ctlAp.createDesignerControl());
        }
        if (items.size() > 0) {
            ctl.put("Items", items);
        }
        return ctl;
    }

    @Override
    protected T createRuntimeControl() {
        return (T)new Container();
    }

    @Override
    protected void setRuntimeSimpleProperties(Container ctl) {
        super.setRuntimeSimpleProperties(ctl);
        ctl.setCollapseFields(this.getCollapsibleField());
        this.buildRuntimeChildControls(ctl);
    }

    @Override
    protected void fireBeforeCreateRuntimeControl() {
        for (ControlAp<?> ctlAp : this.getItems()) {
            ctlAp.fireBeforeCreateRuntimeControl();
        }
    }

    protected void buildRuntimeChildControls(Container ctl) {
        Container con = ctl;
        List items = con.getItems();
        for (ControlAp<?> ctlAp : this.getItems()) {
            ctlAp.fireBeforeCreateRuntimeControl();
            if (!ctlAp.isHidden()) {
                if (ctlAp instanceof FlatFieldAp && ((FlatFieldAp)ctlAp).getField() == null) continue;
                items.add(ctlAp.buildRuntimeControl());
                continue;
            }
            if (ctlAp instanceof FlatFieldAp && ((FlatFieldAp)ctlAp).getField() == null) continue;
            this.buildHiddenRuntimeChildCtl(con, ctlAp);
        }
    }

    private void buildHiddenRuntimeChildCtl(Container con, ControlAp<?> ctlAp) {
        boolean entityBuildChanged;
        boolean formBuildChanged;
        block6: {
            formBuildChanged = false;
            entityBuildChanged = false;
            if (this.formMetadata != null) {
                formBuildChanged = !this.formMetadata.isIgnoreBuildError();
                this.formMetadata.setIgnoreBuildError(true);
                EntityMetadata entityMetadata = this.formMetadata.getEntityMetadata();
                if (entityMetadata != null) {
                    entityBuildChanged = !entityMetadata.isIgnoreBuildError();
                    entityMetadata.setIgnoreBuildError(true);
                }
            }
            try {
                con.getHiddenItems().add(ctlAp.buildRuntimeControl());
            }
            catch (Exception e) {
                ErrorInfo errorInfo = new ErrorInfo();
                errorInfo.setError(e.getMessage());
                errorInfo.setLevel(1);
                errorInfo.setPropertyName("Items");
                errorInfo.setType("form");
                errorInfo.setItemId(this.getId());
                if (this.formMetadata == null) break block6;
                this.formMetadata.addError(errorInfo);
            }
        }
        if (entityBuildChanged) {
            this.formMetadata.getEntityMetadata().setIgnoreBuildError(false);
        }
        if (formBuildChanged) {
            this.formMetadata.setIgnoreBuildError(false);
        }
    }

    protected List<String> getCollapsibleField() {
        ArrayList<String> fields = new ArrayList<String>();
        for (FieldId item : this.getCollapFields()) {
            ControlAp<?> controlAp = this.formMetadata.getItem(item.getId());
            if (controlAp == null) continue;
            fields.add(controlAp.getKey());
        }
        return fields;
    }

    @SimplePropertyAttribute(name="DefaultCollapse")
    public boolean isDefaultcollapse() {
        return this.defaultcollapse;
    }

    public void setDefaultcollapse(boolean defaultcollapse) {
        this.defaultcollapse = defaultcollapse;
    }

    @SimplePropertyAttribute(name="Shadow")
    public boolean isShadow() {
        return this.shadow;
    }

    public void setShadow(boolean shadow) {
        this.shadow = shadow;
    }

    @Override
    @KSMethod
    public void endInit() {
        this.collapFields.sort(new Comparator<FieldId>(){

            @Override
            public int compare(FieldId o1, FieldId o2) {
                return o1.getSeq() - o2.getSeq();
            }
        });
    }

    @Override
    @KSMethod
    public void beginInit() {
    }
}

