/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.form;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.entity.RuntimeMetaType;
import kd.bos.form.BinderMap;
import kd.bos.form.ControlTypes;
import kd.bos.form.FormConfig;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.FormRoot;
import kd.bos.metadata.Plugin;
import kd.bos.metadata.TabLayout;
import kd.bos.metadata.dao.MetadataSerializer;
import kd.bos.metadata.domainmodel.DomainModelBinder;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.DateField;
import kd.bos.metadata.entity.commonfield.DateTimeField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.rule.BizRule;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormApTabBuilder;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.RuntimeFormMeta;
import kd.bos.metadata.form.cardentry.CardEntryFieldAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.metadata.form.control.FlatFieldAp;
import kd.bos.metadata.form.rule.FormRule;
import kd.bos.service.InteTimeZone;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class FormAp
extends ContainerAp<FormRoot> {
    private List<FormRule> rules = new ArrayList<FormRule>();
    private List<Plugin> plugins = new ArrayList<Plugin>();
    private Entity<?, ?> entity;
    private BigDecimal opacity = new BigDecimal("1");
    private String pkId;
    private boolean showTitle = true;
    private String showType = "MainNewTabPage";
    private String userGuide;
    private String listUserOption;
    private String language;
    private TabLayout tabLayout;
    private List<Plugin> jsPlugins = new ArrayList<Plugin>();
    private String listFormId = "bos_list";
    private String f7ListFormId = "bos_listf7";
    private String direction = "row";
    private boolean wrap = true;
    @Deprecated
    private String helpDocument;
    private int lockStyle = 2;
    private boolean allowDoubleClick;
    private boolean enableInheritProperty = true;
    private boolean enableExtendProperty = true;
    private String listOpenLayoutBill;

    @Deprecated
    @SimplePropertyAttribute
    public String getHelpDocument() {
        return this.helpDocument;
    }

    @Deprecated
    public void setHelpDocument(String helpDocument) {
        this.helpDocument = helpDocument;
    }

    @SimplePropertyAttribute
    public int getLockStyle() {
        return this.lockStyle;
    }

    public void setLockStyle(int lockStyle) {
        this.lockStyle = lockStyle;
    }

    @SimplePropertyAttribute
    public String getShowType() {
        return this.showType;
    }

    public void setShowType(String showType) {
        this.showType = showType;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="row")
    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="1")
    public BigDecimal getOpacity() {
        return this.opacity;
    }

    public void setOpacity(BigDecimal opacity) {
        this.opacity = opacity;
    }

    @SimplePropertyAttribute(name="Wrap")
    @DefaultValueAttribute(value="true")
    public boolean isWrap() {
        return this.wrap;
    }

    public void setWrap(boolean warp) {
        this.wrap = warp;
    }

    @SimplePropertyAttribute(name="AllowDoubleClick")
    @DefaultValueAttribute(value="false")
    public boolean isAllowDoubleClick() {
        return this.allowDoubleClick;
    }

    public void setAllowDoubleClick(boolean allowDoubleClick) {
        this.allowDoubleClick = allowDoubleClick;
    }

    @SimplePropertyAttribute
    public String getListOpenLayoutBill() {
        return this.listOpenLayoutBill;
    }

    public void setListOpenLayoutBill(String listOpenLayoutBill) {
        this.listOpenLayoutBill = listOpenLayoutBill;
    }

    @Override
    public Map<String, Object> createControl() {
        Map<String, Object> ctl = super.createControl();
        ctl.put("dr", this.direction);
        if (this.opacity != null && this.opacity.compareTo(new BigDecimal("1")) != 0) {
            ctl.put("opacity", this.opacity);
        }
        ctl.put("wr", this.wrap);
        if (StringUtils.isNotBlank((CharSequence)this.getHelpDocument())) {
            ctl.put("hfi", this.getHelpDocument());
        }
        ctl.put("fls", this.getLockStyle());
        return ctl;
    }

    @Override
    protected FormRoot createRuntimeControl() {
        return new FormRoot();
    }

    @Override
    protected void setRuntimeSimpleProperties(Container ctl) {
        super.setRuntimeSimpleProperties(ctl);
        FormRoot formRoot = (FormRoot)ctl;
        formRoot.setRuleCount(this.getRules().size() + this.getEntity().getRules().size());
        ArrayList<kd.bos.entity.plugin.Plugin> runtimeJsPlugins = new ArrayList<kd.bos.entity.plugin.Plugin>(this.getJsPlugins().size());
        for (Plugin jsPlugin : this.getJsPlugins()) {
            kd.bos.entity.plugin.Plugin runtimeJsPlugin = new kd.bos.entity.plugin.Plugin();
            runtimeJsPlugin.setFpk(jsPlugin.getFpk());
            runtimeJsPlugin.setClassName(jsPlugin.getClassName());
            runtimeJsPlugin.setEnabled(jsPlugin.isEnabled());
            runtimeJsPlugin.setInherit(jsPlugin.isInherit());
            runtimeJsPlugin.setRowKey(jsPlugin.getRowKey());
            runtimeJsPlugin.setSourceNumber(jsPlugin.getSourceNumber());
            runtimeJsPlugins.add(runtimeJsPlugin);
        }
        formRoot.setJsPlugins(runtimeJsPlugins);
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=FormRule.class)
    public List<FormRule> getRules() {
        return this.rules;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=Plugin.class)
    public List<Plugin> getPlugins() {
        return this.plugins;
    }

    @SimplePropertyAttribute(name="ShowTitle")
    @DefaultValueAttribute(value="true")
    public boolean isShowTitle() {
        return this.showTitle;
    }

    public void setShowTitle(boolean showLabel) {
        this.showTitle = showLabel;
    }

    public void setEntity(Entity<?, ?> entity) {
        this.entity = entity;
    }

    public Entity<?, ?> getEntity() {
        return this.entity;
    }

    public FormConfig createFormConfig() {
        return this.createFormConfig(false);
    }

    public FormConfig createFormConfig(boolean isQingView) {
        FormConfig config = new FormConfig();
        config.setHeight(this.getHeight());
        config.setWidth(this.getWidth());
        config.setCaption(this.getName());
        config.setShowTitle(this.isShowTitle());
        config.setListUserOption(this.getListUserOption());
        config.setListFormId(this.getListFormId());
        config.setF7ListFormId(this.getF7ListFormId());
        config.setShowType(ShowType.valueOf((String)this.showType));
        config.setQingView(isQingView);
        String appId = this.formMetadata.getBizappNumber();
        config.setBizAppNumber(this.formMetadata.getOriginalAppNumber());
        config.setAppId(appId == null ? null : appId.toLowerCase());
        config.setUserGuide(this.getUserGuide());
        config.setAllowDoubleClick(this.isAllowDoubleClick());
        config.setListOpenLayoutBill(this.getListOpenLayoutBill());
        ArrayList<kd.bos.entity.plugin.Plugin> plugins = new ArrayList<kd.bos.entity.plugin.Plugin>();
        for (Plugin p : this.plugins) {
            if (!p.isEnabled()) continue;
            kd.bos.entity.plugin.Plugin pl = new kd.bos.entity.plugin.Plugin();
            pl.setClassName(p.getClassName());
            pl.setType(p.getType());
            pl.setScriptNumber(p.getScriptNumber());
            pl.setRowKey(p.getRowKey());
            pl.setEvents(p.getEvents());
            plugins.add(pl);
        }
        Collections.sort(plugins, new Comparator<kd.bos.entity.plugin.Plugin>(){

            @Override
            public int compare(kd.bos.entity.plugin.Plugin o1, kd.bos.entity.plugin.Plugin o2) {
                Integer rowkey1 = o1.getRowKey();
                Integer rowkey2 = o2.getRowKey();
                return rowkey1.compareTo(rowkey2);
            }
        });
        config.setPlugins(plugins);
        config.setModelType(this.getModelType());
        config.setFieldHashCode(this.calcFieldHashCode());
        return config;
    }

    private String calcFieldHashCode() {
        HashSet<String> fieldKeySet = new HashSet<String>(16);
        int count = 0;
        EntityMetadata entityMetadata = this.formMetadata.getEntityMetadata();
        for (EntityItem<?> item : entityMetadata.getItems()) {
            fieldKeySet.add(item.getKey());
            ++count;
        }
        StringBuilder stringBuilder = new StringBuilder(16);
        for (String s : fieldKeySet) {
            stringBuilder.append(s);
        }
        return String.valueOf(stringBuilder.toString().hashCode()) + "_" + String.valueOf(count);
    }

    protected String getModelType() {
        return "form";
    }

    @SimplePropertyAttribute(isPrimaryKey=true)
    public String getPkId() {
        if (StringUtils.isBlank((CharSequence)this.pkId)) {
            this.pkId = Uuid16.create().toString();
        }
        return this.pkId;
    }

    public void setPkId(String pkId) {
        this.pkId = pkId;
    }

    @Override
    @SimplePropertyAttribute
    public String getId() {
        return super.getId();
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="bos_list")
    public String getListFormId() {
        return this.listFormId;
    }

    public void setListFormId(String listFormId) {
        this.listFormId = listFormId;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="bos_listf7")
    public String getF7ListFormId() {
        return this.f7ListFormId;
    }

    public void setF7ListFormId(String f7ListFormId) {
        this.f7ListFormId = f7ListFormId;
    }

    public void buildRuntimeMeta(List<RuntimeFormMeta> metas, String runtimeVersion) {
        this.buildFormConfig(metas, runtimeVersion);
    }

    private void buildFormConfig(List<RuntimeFormMeta> metas, String runtimeVersion) {
        FormRoot container = (FormRoot)this.buildRuntimeControl();
        FormConfig config = this.createFormConfig(false);
        config.setVersion(runtimeVersion);
        this.setEntityType(config);
        config.setHasBinderMap(this.formMetadata.hasBinderMap());
        config.setRuleCount(this.formMetadata.buildFormRules(metas));
        config.setHDFieldCount(this.buildHeadDecimalFields(metas) + this.buildHeadDateTimeFields(metas));
        this.buildTabLayoutControls(metas, config);
        config.setCustomForm(this.isCustomForm());
        RuntimeFormMeta meta = this.formMetadata.createRuntimeFormMeta();
        meta.setKey(this.getKey());
        meta.setType(RuntimeMetaType.Config.getValue());
        meta.setData(ControlTypes.toJsonString((Object)config));
        metas.add(meta);
        RuntimeFormMeta verMeta = this.formMetadata.createRuntimeFormMeta();
        verMeta.setKey(this.getKey());
        verMeta.setType(RuntimeMetaType.Version.getValue());
        verMeta.setData(config.getVersion());
        metas.add(verMeta);
        this.buildRuntimeControls(metas, (Container)container);
    }

    private boolean isCustomForm() {
        String bizAppId;
        String formIsv = this.formMetadata.getIsv();
        if (StringUtils.isBlank((CharSequence)formIsv) && StringUtils.isNotBlank((CharSequence)(bizAppId = this.formMetadata.getBizappId()))) {
            formIsv = this.formMetadata.getBizIsv();
        }
        return !StringUtils.isNotBlank((CharSequence)formIsv) || !formIsv.equals("kingdee");
    }

    protected void setEntityType(FormConfig config) {
        config.setEntityTypeId(this.getEntity().getKey());
    }

    private void buildRuntimeControls(List<RuntimeFormMeta> metas, Container container) {
        RuntimeFormMeta meta = this.formMetadata.createRuntimeFormMeta();
        meta.setKey(this.getKey());
        meta.setType(RuntimeMetaType.Form.getValue());
        meta.setData(ControlTypes.toJsonString((Object)container));
        metas.add(meta);
        if (this.formMetadata.hasBinderMap()) {
            meta = this.formMetadata.createRuntimeFormMeta();
            meta.setKey("_bindermap_");
            meta.setType(RuntimeMetaType.Control.getValue());
            BinderMap map = new BinderMap();
            map.setMap(this.formMetadata.binderMap);
            meta.setData(ControlTypes.toJsonString((Object)map));
            metas.add(meta);
        }
    }

    private int buildHeadDecimalFields(List<RuntimeFormMeta> metas) {
        ArrayList<String> decimalFields = new ArrayList<String>();
        for (ControlAp<?> cAp : this.formMetadata.getItems()) {
            Field<?> fld;
            if (!(cAp instanceof FieldAp) || cAp instanceof EntryFieldAp || cAp instanceof CardEntryFieldAp || cAp instanceof FlatFieldAp || !((fld = ((FieldAp)cAp).getField()) instanceof DecimalField)) continue;
            decimalFields.add(fld.getKey());
        }
        if (decimalFields.size() > 0) {
            RuntimeFormMeta meta = this.formMetadata.createRuntimeFormMeta();
            meta.setKey(this.getKey());
            meta.setType(RuntimeMetaType.DecimalFields.getValue());
            meta.setData(SerializationUtils.toJsonString(decimalFields));
            metas.add(meta);
            return decimalFields.size();
        }
        return 0;
    }

    private int buildHeadDateTimeFields(List<RuntimeFormMeta> metas) {
        ArrayList<String> datetimeFields = new ArrayList<String>();
        for (ControlAp<?> cAp : this.formMetadata.getItems()) {
            Field<?> fld;
            if (!(cAp instanceof FieldAp) || cAp instanceof EntryFieldAp || cAp instanceof CardEntryFieldAp || !((fld = ((FieldAp)cAp).getField()) instanceof DateTimeField) || fld instanceof DateField || InteTimeZone.TransType.get((int)((DateTimeField)fld).getTimeZoneTransType()) != InteTimeZone.TransType.OrgTimeZone) continue;
            datetimeFields.add(fld.getKey());
        }
        if (datetimeFields.size() > 0) {
            RuntimeFormMeta meta = this.formMetadata.createRuntimeFormMeta();
            meta.setKey(this.getKey());
            meta.setType(RuntimeMetaType.DateTimeFields.getValue());
            meta.setData(SerializationUtils.toJsonString(datetimeFields));
            metas.add(meta);
            return datetimeFields.size();
        }
        return 0;
    }

    private void buildTabLayoutControls(List<RuntimeFormMeta> metas, FormConfig config) {
        String modelType = this.formMetadata.getModelType();
        if (!"BillFormModel".equals(modelType) && !"BaseFormModel".equals(modelType)) {
            return;
        }
        TabLayout tabLayout = this.getTabLayout();
        if (tabLayout == null) {
            return;
        }
        if (!tabLayout.isEnabled()) {
            return;
        }
        DomainModelBinder binder = new DomainModelBinder(DomainModelType.getDomainModelType(this.formMetadata.getModelType(), false));
        binder.setWriteInheritFlag(true);
        DcJsonSerializer ser = new DcJsonSerializer((DcBinder)binder);
        ser.setIsLocaleValueFull(true);
        Map map = ser.serializeToMap((Object)this.formMetadata, null);
        FormMetadata formMetadataNew = (FormMetadata)ser.deserializeFromMap(map, null);
        formMetadataNew.bindEntityMetadata(this.formMetadata.getEntityMetadata());
        formMetadataNew.createIndex(true);
        FormAp formApNew = formMetadataNew.getRootAp();
        if (!FormApTabBuilder.buildNewFormAp(formApNew)) {
            return;
        }
        config.setTabLayout(true);
        Map<String, Object> ctl = formApNew.createControl();
        HashMap<String, Object> clientRuleActions = new HashMap<String, Object>();
        for (ControlAp<?> ap : this.formMetadata.getItems()) {
            FormRule rl;
            ContainerAp ent;
            if (ap instanceof FormAp) {
                ent = (FormAp)ap;
                for (BizRule bizRule : ((FormAp)ent).getRules()) {
                    rl = (FormRule)bizRule;
                    rl.buildClientActions(this.formMetadata, clientRuleActions);
                }
                continue;
            }
            if (!(ap instanceof EntryAp)) continue;
            ent = (EntryAp)ap;
            for (BizRule bizRule : ((EntryAp)ent).getRules()) {
                rl = (FormRule)bizRule;
                rl.buildClientActions(this.formMetadata, clientRuleActions);
            }
        }
        if (clientRuleActions.size() > 0) {
            ctl.put("acts", clientRuleActions);
        }
        RuntimeFormMeta meta = this.formMetadata.createRuntimeFormMeta();
        meta.setKey(RuntimeMetaType.TabLayout.name().toLowerCase());
        meta.setType(RuntimeMetaType.TabLayout.getValue());
        meta.setData(SerializationUtils.toJsonString(ctl));
        metas.add(meta);
    }

    public void buildDesignMeta(Map<String, Object> clientMeta, MetadataSerializer ser) {
        EntityMetadata entityMetadata = this.formMetadata.getEntityMetadata();
        clientMeta.put("entitymeta", ser.serializeToMap(entityMetadata));
        if (!StringUtils.equals((CharSequence)entityMetadata.getId(), (CharSequence)this.formMetadata.getId())) {
            clientMeta.put("entityreadonly", true);
        }
        clientMeta.put("entitytree", entityMetadata.buildDesgnerTree());
    }

    @Override
    public int getIndex() {
        return -1;
    }

    @SimplePropertyAttribute
    public String getListUserOption() {
        return this.listUserOption;
    }

    public void setListUserOption(String listUserOption) {
        this.listUserOption = listUserOption;
    }

    @SimplePropertyAttribute
    public String getUserGuide() {
        return this.userGuide;
    }

    public void setUserGuide(String userGuide) {
        this.userGuide = userGuide;
    }

    @SimplePropertyAttribute
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    @SimplePropertyAttribute(name="EnableInheritProperty")
    @DefaultValueAttribute(value="true")
    public boolean isEnableInheritProperty() {
        return this.enableInheritProperty;
    }

    public void setEnableInheritProperty(boolean enableInheritProperty) {
        this.enableInheritProperty = enableInheritProperty;
    }

    @SimplePropertyAttribute(name="EnableExtendProperty")
    @DefaultValueAttribute(value="true")
    public boolean isEnableExtendProperty() {
        return this.enableExtendProperty;
    }

    public void setEnableExtendProperty(boolean enableExtendProperty) {
        this.enableExtendProperty = enableExtendProperty;
    }

    @ComplexPropertyAttribute
    public TabLayout getTabLayout() {
        return this.tabLayout;
    }

    public void setTabLayout(TabLayout tabLayout) {
        this.tabLayout = tabLayout;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=Plugin.class)
    public List<Plugin> getJsPlugins() {
        return this.jsPlugins;
    }

    public void setJsPlugins(List<Plugin> jsPlugins) {
        this.jsPlugins = jsPlugins;
    }

    public void initializeJsPlugin() {
        Plugin designJsPlugin = new Plugin();
        designJsPlugin.setRowKey(this.getJsPlugins().size());
        designJsPlugin.setEnabled(true);
        designJsPlugin.setFpk(Uuid8.generateShortUuid());
        String className = this.getId() + "_" + designJsPlugin.getFpk();
        if (this.getModelType().startsWith("mob")) {
            className = this.getId() + "_mob_" + designJsPlugin.getFpk();
        }
        designJsPlugin.setClassName(className);
        designJsPlugin.setSourceNumber(this.getKey());
        designJsPlugin.setSourceName(this.getName());
        this.getJsPlugins().add(designJsPlugin);
    }
}

