/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.form;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.Tips;
import kd.bos.metadata.TabLayout;
import kd.bos.metadata.TabLayoutItem;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormAp;
import kd.bos.metadata.form.container.AdvConAp;
import kd.bos.metadata.form.container.FieldsetPanelAp;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.container.SplitContainerAp;
import kd.bos.metadata.form.container.SplitPanelAp;
import kd.bos.metadata.form.container.TabAp;
import kd.bos.metadata.form.container.TabPageAp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormApTabBuilder {
    private static final String TABPAGE_PREFIX = "TABLAYOUT_TABPAGE_";
    private static final String TABLAYOUT_SPLITCONTAINER = "TABLAYOUT_SPLITCONTAINER";
    private static final String TABLAYOUT_SPLITPANEL1 = "TABLAYOUT_SPLITPANEL1";
    private static final String TABLAYOUT_SPLITPANEL2 = "TABLAYOUT_SPLITPANEL2";
    private static final String TABLAYOUT_TAB1 = "TABLAYOUT_TAB1";
    private static final String TABLAYOUT_TAB2 = "TABLAYOUT_TAB2";
    private static final String IS_REPLACED = "isReplaced";
    private static Logger logger = LoggerFactory.getLogger(FormApTabBuilder.class);

    private ContainerAp<?> createContainer(Map<Integer, List<ControlAp<?>>> tabPageApsMap, TabLayout tabLayout) {
        Set<Map.Entry<Integer, List<ControlAp<?>>>> entries = tabPageApsMap.entrySet();
        if (entries.size() == 1) {
            TabAp tabap1 = null;
            for (Map.Entry<Integer, List<ControlAp<?>>> entry : entries) {
                tabap1 = this.createTabAp(TABLAYOUT_TAB1);
                tabap1.getItems().addAll((Collection)entry.getValue());
            }
            return tabap1;
        }
        if (entries.size() == 2) {
            SplitContainerAp splitContainerAp = this.createSplitContainerAp(TABLAYOUT_SPLITCONTAINER, tabLayout.getSplitPos());
            SplitPanelAp splitPanelAp1 = new SplitPanelAp();
            splitPanelAp1.setKey(TABLAYOUT_SPLITPANEL1);
            SplitPanelAp splitPanelAp2 = new SplitPanelAp();
            splitPanelAp2.setKey(TABLAYOUT_SPLITPANEL2);
            splitContainerAp.getItems().add(splitPanelAp1);
            splitContainerAp.getItems().add(splitPanelAp2);
            for (Map.Entry<Integer, List<ControlAp<?>>> entry : entries) {
                if (entry.getKey() == 0) {
                    TabAp tabap1 = this.createTabAp(TABLAYOUT_TAB1);
                    tabap1.getItems().addAll((Collection)entry.getValue());
                    splitPanelAp1.getItems().add(tabap1);
                }
                if (entry.getKey() != 1) continue;
                TabAp tabap2 = this.createTabAp(TABLAYOUT_TAB2);
                tabap2.getItems().addAll((Collection)entry.getValue());
                splitPanelAp2.getItems().add(tabap2);
            }
            return splitContainerAp;
        }
        return null;
    }

    private TabAp createTabAp(String key) {
        TabAp tabap = new TabAp();
        tabap.setKey(key);
        tabap.setTabStyle(3);
        tabap.setStorageMode(true);
        return tabap;
    }

    private SplitContainerAp createSplitContainerAp(String key, String splitPosition) {
        SplitContainerAp splitContainerAp = new SplitContainerAp();
        splitContainerAp.setKey(TABLAYOUT_SPLITCONTAINER);
        splitContainerAp.setSplitStyle(0);
        splitContainerAp.setSaveSplitPosition(true);
        splitContainerAp.setStorageMode(true);
        splitContainerAp.setSplitPosition(splitPosition);
        return splitContainerAp;
    }

    private TabPageAp createTabPage(ControlAp<?> panelAp) {
        TabPageAp tabPageAp = new TabPageAp();
        tabPageAp.setKey(TABPAGE_PREFIX + panelAp.getKey());
        tabPageAp.setName(panelAp.getName());
        tabPageAp.setCanFull(true);
        if (panelAp instanceof AdvConAp && ((AdvConAp)panelAp).getCtlTips() != null) {
            tabPageAp.setCtlTips(((AdvConAp)panelAp).getCtlTips());
        }
        if (panelAp instanceof FieldsetPanelAp && ((FieldsetPanelAp)panelAp).getCtlTips() != null) {
            tabPageAp.setCtlTips(((FieldsetPanelAp)panelAp).getCtlTips());
        }
        if (panelAp instanceof FlexPanelAp && ((FlexPanelAp)panelAp).getCtlTips() != null) {
            tabPageAp.setCtlTips(((FlexPanelAp)panelAp).getCtlTips());
        }
        tabPageAp.getItems().add(panelAp);
        if (panelAp instanceof ContainerAp) {
            ((ContainerAp)panelAp).setCollapsible(false);
        }
        if ("kd.bos.metadata.form.control.AttachmentPanelAp".equals(panelAp.getClass().getName())) {
            try {
                Field collapsibleField = panelAp.getClass().getDeclaredField("collapsible");
                collapsibleField.setAccessible(true);
                collapsibleField.set(panelAp, false);
                Field ctlTipsField = panelAp.getClass().getDeclaredField("ctlTips");
                ctlTipsField.setAccessible(true);
                tabPageAp.setCtlTips((Tips)ctlTipsField.get(panelAp));
            }
            catch (Throwable e) {
                logger.error("AttachmentPanelAp set property fail", e);
            }
        }
        return tabPageAp;
    }

    public static boolean buildNewFormAp(FormAp formAp) {
        FormApTabBuilder formApTabBuilder = new FormApTabBuilder();
        TabLayout tabLayout = formAp.getTabLayout();
        List<TabLayoutItem> tabLayoutItems = tabLayout.getTabLayoutItems();
        tabLayoutItems.sort((o1, o2) -> {
            Integer order1 = o1.getOrder();
            Integer order2 = o2.getOrder();
            return order1.compareTo(order2);
        });
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(IS_REPLACED, false);
        formApTabBuilder.modFormItems(formAp.getItems(), tabLayout, result);
        return (Boolean)result.get(IS_REPLACED);
    }

    private void modFormItems(List<ControlAp<?>> items, TabLayout tabLayout, Map<String, Object> result) {
        ContainerAp<?> container;
        ArrayList<String> tabKeys = new ArrayList<String>();
        LinkedHashMap tabPageApsMap = new LinkedHashMap();
        List<TabLayoutItem> tabLayoutItems = tabLayout.getTabLayoutItems();
        for (TabLayoutItem tabLayoutItem : tabLayoutItems) {
            int group = tabLayoutItem.getGroup();
            String panelKey = tabLayoutItem.getPanelKey();
            for (ControlAp<?> panel : items) {
                if (!StringUtils.equals((CharSequence)panelKey, (CharSequence)panel.getKey()) || group == -1) continue;
                tabKeys.add(panelKey);
                ArrayList<TabPageAp> tabPageAps = (ArrayList<TabPageAp>)tabPageApsMap.get(group);
                if (tabPageAps == null) {
                    tabPageAps = new ArrayList<TabPageAp>(10);
                }
                TabPageAp tabPage = this.createTabPage(panel);
                tabPageAps.add(tabPage);
                tabPageApsMap.put(group, tabPageAps);
            }
        }
        if (!tabKeys.isEmpty() && !tabPageApsMap.isEmpty() && (container = this.createContainer(tabPageApsMap, tabLayout)) != null) {
            int n;
            boolean bl = false;
            for (int i = 0; i < items.size(); ++i) {
                if (!tabKeys.contains(items.get(i).getKey())) continue;
                n = i;
                break;
            }
            items.add(n, container);
            items.removeIf(controlAp -> tabKeys.contains(controlAp.getKey()));
            result.put(IS_REPLACED, true);
        }
        for (ControlAp controlAp2 : items) {
            if (!(controlAp2 instanceof ContainerAp) || ((Boolean)result.get(IS_REPLACED)).booleanValue()) continue;
            this.modFormItems(((ContainerAp)controlAp2).getItems(), tabLayout, result);
        }
    }
}

