/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.form;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.BOSRuntime;
import kd.bos.entity.RuntimeMetaType;
import kd.bos.entity.rule.AbstractRule;
import kd.bos.entity.rule.BR;
import kd.bos.entity.rule.EntityBR;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.api.IInteService;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.DesignMeta;
import kd.bos.metadata.DesignMetaL;
import kd.bos.metadata.IEntityBinder;
import kd.bos.metadata.Plugin;
import kd.bos.metadata.RuntimeMetaCollection;
import kd.bos.metadata.dao.AppRebuilder;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.dao.MetadataSerializer;
import kd.bos.metadata.domainmodel.DomainModelBinder;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.metadata.entity.DesignEntityMeta;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.SubEntryEntity;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.rule.BizRule;
import kd.bos.metadata.exception.ErrorInfo;
import kd.bos.metadata.extensible.ExtElement;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.DesignFormMeta;
import kd.bos.metadata.form.DesignFormMetaL;
import kd.bos.metadata.form.FormAp;
import kd.bos.metadata.form.ParameterFormAp;
import kd.bos.metadata.form.RuntimeFormMeta;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.metadata.form.control.FlatFieldAp;
import kd.bos.metadata.form.rule.FormRule;
import kd.bos.metadata.kflow.enums.RuleType;
import kd.bos.metadata.lang.LangItemBuilder;
import kd.bos.metadata.lang.LangWriter;
import kd.bos.script.annotations.KSMethod;
import kd.bos.service.ServiceFactory;
import kd.bos.service.TimeService;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class FormMetadata
extends AbstractMetadata
implements IEntityBinder {
    private List<ControlAp<?>> items = new ArrayList();
    private Map<String, ControlAp<?>> mapItems;
    private Map<String, ControlAp<?>> mapKeyItems;
    private FormAp rootAp;
    private String entityId;
    private LocaleString name;
    private boolean _isInitialize;
    private EntityMetadata entityMetadata;
    private boolean enabled = true;
    private String srcBizObjId;
    private transient boolean preparedRebuildFlag;
    private static Set<String> bampMoveAppList = new HashSet<String>(7);
    private List<ExtElement> extElements = new ArrayList<ExtElement>(10);
    Map<String, List<String>> binderMap;
    private AppInfo appInfo;

    @Override
    @KSMethod
    @SimplePropertyAttribute(displayName="sub system id")
    @DefaultValueAttribute(value="0")
    public Integer getSubSysId() {
        return this.subSysId;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=ExtElement.class, displayName="extension element")
    public List<ExtElement> getExtElements() {
        return this.extElements;
    }

    public void setExtElements(List<ExtElement> extElements) {
        this.extElements = extElements;
    }

    public FormAp getRootAp() {
        if (this.rootAp == null && this.items.size() > 0 && this.items.get(0) instanceof FormAp) {
            this.rootAp = (FormAp)this.items.get(0);
        }
        return this.rootAp;
    }

    public void setRootAp(FormAp rootAp) {
        this.rootAp = rootAp;
    }

    @Override
    public void setId(String id) {
        super.setId(id);
        if (!this._isInitialize) {
            this.createIndex();
            if (this.rootAp != null && !id.equals(this.rootAp.getId())) {
                this.rootAp.setId(id);
                this.createIndex(true);
            }
            this.setSrcBizObjId("");
        }
    }

    @SimplePropertyAttribute(displayName="key")
    public String getKey() {
        this.createIndex();
        if (this.rootAp == null) {
            return null;
        }
        return this.rootAp.getKey();
    }

    public void setKey(String key) {
        if (!this._isInitialize) {
            this.createIndex();
            if (this.rootAp != null) {
                this.rootAp.setKey(key);
            }
        }
    }

    @SimplePropertyAttribute(displayName="name")
    public LocaleString getName() {
        if (this.name != null) {
            return this.name;
        }
        if (this.items.size() > 0) {
            return this.items.get(0).getName();
        }
        return null;
    }

    public void setName(LocaleString name) {
        this.name = name;
        if (!this._isInitialize) {
            this.createIndex();
            if (this.rootAp != null) {
                this.rootAp.setName(name);
            }
        }
    }

    @Override
    @SimplePropertyAttribute(displayName="entity ID")
    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String value) {
        this.entityId = value;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=ControlAp.class, displayName="element")
    public List<ControlAp<?>> getItems() {
        return this.items;
    }

    public Map<String, List<String>> getBinderMap() {
        return this.binderMap;
    }

    public EntityMetadata getEntityMetadata() {
        return this.entityMetadata;
    }

    @SimplePropertyAttribute
    public String getSrcBizObjId() {
        return this.srcBizObjId;
    }

    public void setSrcBizObjId(String srcBizObjId) {
        this.srcBizObjId = srcBizObjId;
    }

    public void bindEntityMetadata(EntityMetadata metaData) {
        this.createIndex();
        this.entityMetadata = metaData;
        if (this.rootAp instanceof ParameterFormAp) {
            ((ParameterFormAp)this.rootAp).setParameterType(this.getModelType().split("_")[1]);
        }
        this.rootAp.setEntity(metaData.getRootEntity());
        this.binderMap = new HashMap<String, List<String>>();
        HashMap<String, ArrayList<String>> subEntryMap = new HashMap<String, ArrayList<String>>();
        for (ControlAp<?> controlAp : this.items) {
            String parentEntityId;
            EntryEntity entity;
            EntryAp entryAp;
            EntryEntity entry;
            if (controlAp instanceof FieldAp) {
                FieldAp fldAp = (FieldAp)controlAp;
                Field<?> fld = metaData.getFieldById(fldAp.getFieldId());
                if (fld == null) continue;
                fldAp.setField(fld);
                if (controlAp instanceof FlatFieldAp) continue;
                fld.addBinderMap(this.binderMap, fldAp.getKey());
                String controlFieldKey = fldAp.getControlFieldKey();
                if (!StringUtils.isNotBlank((CharSequence)controlFieldKey)) continue;
                this.addBinderMap(this.binderMap, controlFieldKey + ".child", fldAp.getKey());
                continue;
            }
            if (!(controlAp instanceof EntryAp) || (entry = metaData.getEntryById((entryAp = (EntryAp)controlAp).getEntryId())) == null) continue;
            entryAp.setEntry(entry);
            if (!StringUtils.equalsIgnoreCase((CharSequence)entry.getKey(), (CharSequence)entryAp.getKey())) {
                this.addBinderMap(this.binderMap, entry.getKey(), entryAp.getKey());
            }
            if (!(entry instanceof SubEntryEntity) || (entity = this.entityMetadata.getEntryById(parentEntityId = ((SubEntryEntity)entry).getParentId())) == null) continue;
            ArrayList<String> strList = (ArrayList<String>)subEntryMap.get(entity.getKey());
            if (strList == null) {
                strList = new ArrayList<String>();
                subEntryMap.put(entity.getKey(), strList);
            }
            strList.add(entryAp.getKey());
        }
        for (Map.Entry entry : subEntryMap.entrySet()) {
            Object ap;
            List<String> strList = this.binderMap.get(entry.getKey());
            if (strList == null) {
                ap = (EntryAp)this.mapKeyItems.get(entry.getKey());
                if (ap == null) continue;
                ((EntryAp)ap).setSubEntryGrids((List)entry.getValue());
                continue;
            }
            for (String entryApKey : strList) {
                EntryAp ap2 = (EntryAp)this.mapKeyItems.get(entryApKey);
                ap2.setSubEntryGrids((List)entry.getValue());
            }
            ap = (EntryAp)this.mapKeyItems.get(entry.getKey());
            if (ap == null) continue;
            ((EntryAp)ap).setSubEntryGrids((List)entry.getValue());
        }
    }

    private void addBinderMap(Map<String, List<String>> binderMap, String key, String ctlKey) {
        List<String> ctls = binderMap.get(key);
        if (ctls == null) {
            ctls = new ArrayList<String>();
            binderMap.put(key.toLowerCase(), ctls);
        }
        ctls.add(ctlKey);
    }

    public Map<String, Object> builderDesgnerControls() {
        this.createIndex();
        return this.rootAp.createDesignerControl();
    }

    public List<RuntimeFormMeta> buildRuntimeMetadata(String runtimeVersion) {
        this.createIndex();
        RuntimeMetaCollection<RuntimeFormMeta> metas = new RuntimeMetaCollection<RuntimeFormMeta>();
        this.prepareRebuild();
        this.rootAp.buildRuntimeMeta(metas, runtimeVersion);
        this.builderControls(metas);
        this.preparedRebuildFlag = false;
        return metas;
    }

    public void prepareRebuild() {
        if (this.preparedRebuildFlag) {
            return;
        }
        if (this.entityMetadata != null) {
            this.entityMetadata.prepareRebuild();
        }
        this.preparedRebuildFlag = true;
    }

    public RuntimeFormMeta createRuntimeFormMeta() {
        RuntimeFormMeta meta = new RuntimeFormMeta();
        meta.setId(this.getId());
        meta.setNumber(this.getKey());
        return meta;
    }

    boolean hasBinderMap() {
        return this.binderMap != null && this.binderMap.size() > 0;
    }

    int buildFormRules(List<RuntimeFormMeta> metas) {
        ArrayList<EntityBR> entityBRs = new ArrayList<EntityBR>();
        int ruleCount = 0;
        for (ControlAp<?> ap : this.items) {
            EntityBR entityBR;
            List<BR> brs;
            ContainerAp ent;
            if (ap instanceof FormAp) {
                ent = (FormAp)ap;
                ArrayList<BizRule> rules = new ArrayList<BizRule>();
                String source = ((FormAp)ent).getEntity().getKey();
                rules.addAll(((FormAp)ent).getEntity().getRules());
                rules.addAll(((FormAp)ent).getRules());
                brs = this.buildFormRules(source, rules);
                if (brs.size() > 0) {
                    entityBR = new EntityBR();
                    entityBR.setKey(source);
                    entityBR.setRules(brs);
                    entityBRs.add(entityBR);
                }
                ruleCount += brs.size();
                continue;
            }
            if (!(ap instanceof EntryAp) || ((EntryAp)(ent = (EntryAp)ap)).getEntry() == null) continue;
            String source = ((EntryAp)ent).getEntry().getKey();
            ArrayList<BizRule> rules = new ArrayList<BizRule>();
            rules.addAll(((EntryAp)ent).getEntry().getRules());
            rules.addAll(((EntryAp)ent).getRules());
            brs = this.buildFormRules(source, rules);
            if (brs.size() > 0) {
                entityBR = new EntityBR();
                entityBR.setKey(source);
                entityBR.setRules(brs);
                entityBRs.add(entityBR);
            }
            ruleCount += brs.size();
        }
        if (entityBRs.size() > 0) {
            RuntimeFormMeta meta = this.createRuntimeFormMeta();
            meta.setKey("_formrules");
            meta.setType(RuntimeMetaType.Rule.getValue());
            meta.setData(SerializationUtils.toJsonString(entityBRs));
            metas.add(meta);
        }
        return ruleCount;
    }

    private List<BR> buildFormRules(String source, List<? extends BizRule> rules) {
        ArrayList<BR> eRules = new ArrayList<BR>(10);
        for (BizRule bizRule : rules) {
            if (bizRule instanceof FormRule) {
                BR runtimeRule;
                String ruleType = ((FormRule)bizRule).getRuleType();
                if (RuleType.KFlowRule.name().equals(ruleType)) {
                    runtimeRule = ((FormRule)bizRule).buildRuntimeRule(source);
                    eRules.add(runtimeRule);
                    for (ErrorInfo errorInfo : bizRule.getErrorInfos()) {
                        this.addError(errorInfo);
                    }
                    continue;
                }
                runtimeRule = bizRule.buildEntityRule(source);
                eRules.add(runtimeRule);
                for (ErrorInfo errorInfo : bizRule.getErrorInfos()) {
                    this.addError(errorInfo);
                }
                continue;
            }
            BR runtimeRule = bizRule.buildEntityRule(source);
            eRules.add(runtimeRule);
            for (ErrorInfo errorInfo : bizRule.getErrorInfos()) {
                this.addError(errorInfo);
            }
        }
        Collections.sort(eRules, new Comparator<AbstractRule>(){

            @Override
            public int compare(AbstractRule o1, AbstractRule o2) {
                return Integer.compare(o1.getSeq(), o2.getSeq());
            }
        });
        return eRules;
    }

    private void builderControls(List<RuntimeFormMeta> metas) {
        this.createIndex();
        HashMap<String, Object> clientRuleActions = new HashMap<String, Object>();
        for (ControlAp<?> ap : this.items) {
            FormRule rl;
            ContainerAp ent;
            if (ap instanceof FormAp) {
                ent = (FormAp)ap;
                for (BizRule bizRule : ((FormAp)ent).getRules()) {
                    rl = (FormRule)bizRule;
                    rl.buildClientActions(this, clientRuleActions);
                }
                continue;
            }
            if (!(ap instanceof EntryAp)) continue;
            ent = (EntryAp)ap;
            for (BizRule bizRule : ((EntryAp)ent).getRules()) {
                rl = (FormRule)bizRule;
                rl.buildClientActions(this, clientRuleActions);
            }
        }
        Map<String, Object> ctl = this.rootAp.createControl();
        if (clientRuleActions.size() > 0) {
            ctl.put("acts", clientRuleActions);
        }
        RuntimeFormMeta meta = this.createRuntimeFormMeta();
        meta.setKey(this.getKey());
        meta.setType(RuntimeMetaType.Client.getValue());
        meta.setData(SerializationUtils.toJsonString(ctl));
        metas.add(meta);
    }

    public ControlAp<?> getItem(String id) {
        return this.mapItems.get(id);
    }

    public void createIndex(boolean forceRefesh) {
        if ((this.mapItems == null || this.rootAp == null || forceRefesh) && this.items.size() > 0) {
            this.mapItems = new HashMap(16);
            this.mapKeyItems = new HashMap(16);
            if (this.items.get(0) instanceof FormAp) {
                this.rootAp = (FormAp)this.items.get(0);
            }
            for (ControlAp<?> ap : this.items) {
                ap.setFormMetadata(this);
                this.mapItems.put(ap.getId(), ap);
                this.mapKeyItems.put(ap.getKey(), ap);
                if (!(ap instanceof ContainerAp)) continue;
                ((ContainerAp)ap).getItems().clear();
            }
            if (this.rootAp == null) {
                return;
            }
            ControlAp<?> errAp = null;
            for (ControlAp<?> ap : this.items) {
                ContainerAp cap = (ContainerAp)this.mapItems.get(ap.getParentId());
                if (cap == null) {
                    cap = this.rootAp;
                }
                if (cap == ap) continue;
                if (cap instanceof FormAp && ap instanceof FormAp) {
                    if (ap == this.rootAp) continue;
                    errAp = ap;
                    continue;
                }
                cap.getItems().add(ap);
                if (cap != this.rootAp) continue;
                ap.setParentId(cap.getId());
            }
            if (errAp != null) {
                this.items.remove(errAp);
            }
        }
    }

    public void createIndex() {
        this.createIndex(false);
    }

    @Override
    public void beginInit() {
        this._isInitialize = true;
    }

    @Override
    public void endInit() {
        this.sortItems();
        this.setPluginMetadataId();
        this._isInitialize = false;
    }

    private void setPluginMetadataId() {
        FormAp formAp = this.getRootAp();
        if (formAp == null) {
            return;
        }
        for (Plugin plugin : formAp.getPlugins()) {
            if (plugin.getMetadataId() != null) continue;
            plugin.setMetadataId(this.getId());
        }
    }

    private void sortItems() {
        Collections.sort(this.items, new Comparator<ControlAp<?>>(){

            @Override
            public int compare(ControlAp<?> o1, ControlAp<?> o2) {
                int compareValue = 0;
                compareValue = o1.getParentId() == null && o2.getParentId() == null ? 0 : (o1.getParentId() == null && o2.getParentId() != null ? -1 : (o1.getParentId() != null && o2.getParentId() == null ? 1 : o1.getParentId().compareTo(o2.getParentId())));
                if (compareValue != 0) {
                    return compareValue;
                }
                return Integer.compare(o1.getIndex(), o2.getIndex());
            }
        });
    }

    @Override
    public boolean isInitialized() {
        return this._isInitialize;
    }

    public void resetItemId(Map<String, String> idMap) {
        for (ControlAp<?> ap : this.items) {
            FormRule rl;
            ContainerAp ent;
            ap.resetItemId(idMap);
            if (ap instanceof FormAp) {
                ent = (FormAp)ap;
                for (BizRule bizRule : ((FormAp)ent).getRules()) {
                    rl = (FormRule)bizRule;
                    rl.resetItemId(idMap);
                }
                continue;
            }
            if (!(ap instanceof EntryAp)) continue;
            ent = (EntryAp)ap;
            for (BizRule bizRule : ((EntryAp)ent).getRules()) {
                rl = (FormRule)bizRule;
                rl.resetItemId(idMap);
            }
        }
    }

    public void resetEntityItemId(Map<String, String> idMap) {
        for (ControlAp<?> ap : this.items) {
            ap.resetEntityItemId(idMap);
        }
    }

    @Override
    public IDataEntityType getDesingerMetaType() {
        return OrmUtils.getDataEntityType(DesignFormMeta.class);
    }

    @Override
    public IDataEntityType getDesingerMetaLType() {
        return OrmUtils.getDataEntityType(DesignFormMetaL.class);
    }

    @Override
    protected void setDesignMeta(DesignMeta designMeta) {
        super.setDesignMeta(designMeta);
        designMeta.setNumber(this.getKey());
        ((DesignFormMeta)designMeta).setEntityId(this.getEntityId());
        ((DesignFormMeta)designMeta).setModifierId(RequestContext.get().getUserId());
        ((DesignFormMeta)designMeta).setEnabled(this.enabled);
        ((DesignFormMeta)designMeta).setIsvSign(this.getIsvSign());
        TimeService timeService = new TimeService();
        ((DesignFormMeta)designMeta).setModifyDate(timeService.getCurrentSystemTime());
        if (this.getEntityMetadata() != null && this.getEntityMetadata().getRootEntity() != null) {
            boolean islayout;
            boolean bl = islayout = !this.getId().equals(this.getEntityId());
            if (!islayout) {
                designMeta.setTemplate(this.getEntityMetadata().getRootEntity().isTemplate());
            }
        }
    }

    @Override
    protected void setDesignMetaL(String localeId, DesignMetaL designMetaL) {
        super.setDesignMetaL(localeId, designMetaL);
        designMetaL.setNumber(this.getKey());
        designMetaL.setName((String)this.getName().getItem(localeId));
    }

    @Override
    public Map<String, Object> buildDesignMeta(String lang) {
        Map<String, Object> clientMeta = super.buildDesignMeta(lang);
        clientMeta.put("id", this.getId());
        if (this.entityMetadata == null) {
            MetadataReader reader = new MetadataReader(false);
            boolean islayout = !this.getId().equals(this.entityId);
            EntityMetadata entityMetadata = (EntityMetadata)reader.readMeta(this.entityId, OrmUtils.getDataEntityType(DesignEntityMeta.class), islayout);
            this.bindEntityMetadata(entityMetadata);
        }
        if ("2".equals(this.getDevType())) {
            clientMeta.put("devType", "2");
        }
        clientMeta.put("ui", this.builderDesgnerControls());
        MetadataSerializer ser = new MetadataSerializer(this.getModelType());
        DomainModelBinder binder = (DomainModelBinder)ser.getBinder();
        binder.setLCId(lang);
        binder.setWriteInheritFlag(true);
        this.getRootAp().setLanguage(lang);
        clientMeta.put("language", this.getRootAp().getLanguage());
        clientMeta.put("formmeta", ser.serializeToMap(this));
        this.getRootAp().buildDesignMeta(clientMeta, ser);
        clientMeta.put("caption", this.getName().get((Object)lang));
        clientMeta.put("fullLocaleCaption", this.getName());
        clientMeta.put("localeItems", this.getLocaleItems());
        clientMeta.put("clientLocaleItems", this.getDesignLocaleProps());
        clientMeta.put("enabled", this.isEnabled());
        clientMeta.put("mergeVersion", this.getMergeVersion());
        this.fixMobListEntityID(clientMeta);
        return clientMeta;
    }

    private Map<String, Map<String, ILocaleString>> getDesignLocaleProps() {
        HashMap<String, Map<String, ILocaleString>> result = new HashMap<String, Map<String, ILocaleString>>(this.getItems().size());
        Function<LocaleString, Boolean> emptyFunc = v -> v == null || v.isEmpty();
        for (ControlAp<?> ap : this.getItems()) {
            HashMap<String, LocaleString> itemData = new HashMap<String, LocaleString>(2);
            LocaleString heigh = ap.getHeight();
            LocaleString width = ap.getWidth();
            if (!emptyFunc.apply(heigh).booleanValue()) {
                itemData.put("Height", heigh);
            }
            if (!emptyFunc.apply(width).booleanValue()) {
                itemData.put("Width", width);
            }
            if (itemData.isEmpty()) continue;
            result.put(ap.getId(), itemData);
        }
        return result;
    }

    private void fixMobListEntityID(Map<String, Object> clientMeta) {
        List list = Optional.ofNullable(clientMeta).map(m -> (Map)m.get("formmeta")).map(m -> (List)m.get("Items")).map(m -> (Map)m.get(0)).map(m -> (Map)m.get("MobListMeta")).map(m -> (List)m.get("Items")).orElse(null);
        if (list == null) {
            return;
        }
        Map map = list.stream().filter(s -> "_BillList_".equals(s.get("Id"))).findFirst().orElse(null);
        if (map == null || !map.containsKey("EntityId")) {
            return;
        }
        map.put("EntityId", this.getEntityId());
    }

    public Object getLocaleItems() {
        DomainModelType domainModel = DomainModelType.getDomainModelType(this.getModelType(), false);
        LangItemBuilder builder = new LangItemBuilder(new DomainModelBinder(domainModel));
        HashMap ret = new HashMap();
        builder.builderResouces(this, null);
        ret.put("form", builder.getLocaleItemValues());
        if (this.getId().equals(this.getEntityId())) {
            builder.builderResouces(this.entityMetadata, null);
            ret.put("entity", builder.getLocaleItemValues());
        }
        return ret;
    }

    @Override
    public void convertFromDesignMeta(DesignMeta designMeta) {
        super.convertFromDesignMeta(designMeta);
        this.setEntityId(((DesignFormMeta)designMeta).getEntityId());
        this.setKey(designMeta.getNumber());
        this.setIsvSign(((DesignFormMeta)designMeta).getIsvSign());
        if (this.getRootAp() instanceof FormAp) {
            this.getRootAp().setEnableExtendProperty(((DesignFormMeta)designMeta).isExtended());
            this.getRootAp().setEnableInheritProperty(((DesignFormMeta)designMeta).isInherit());
        }
    }

    @Override
    public DesignMeta convertToDesignMeta(String xml) {
        DesignMeta designMeta = super.convertToDesignMeta(xml);
        if (this.getRootAp() instanceof FormAp) {
            boolean enableExtend = this.getRootAp().isEnableExtendProperty();
            boolean enableInherit = this.getRootAp().isEnableInheritProperty();
            ((DesignFormMeta)designMeta).setExtended(enableExtend);
            ((DesignFormMeta)designMeta).setInherit(enableInherit);
        }
        return designMeta;
    }

    public String getBizappNumber() {
        if (this.appInfo == null) {
            this.appInfo = MetadataDao.getMasterAppInfo(this.getBizappId());
        }
        if (this.appInfo == null && this.getBuildContext() != null && this.getBuildContext().isGray()) {
            AppRebuilder mr = new AppRebuilder(this.getBuildContext().getRebuildAppGroup());
            this.appInfo = mr.getMasterAppInfo(this.getBizappId());
        }
        if (this.appInfo == null) {
            return null;
        }
        if ("basedata".equals(this.appInfo.getNumber())) {
            return this.appInfo.getNumber();
        }
        if (BOSRuntime.isBOSCloud((String)this.appInfo.getCloudId()) || this.isBAMPMoveApp(this.appInfo.getNumber())) {
            return "bos";
        }
        return this.appInfo.getNumber();
    }

    private boolean isBAMPMoveApp(String bizappId) {
        return bampMoveAppList.contains(bizappId);
    }

    public String getOriginalAppNumber() {
        if (this.appInfo == null) {
            this.appInfo = MetadataDao.getMasterAppInfo(this.getBizappId());
        }
        if (this.appInfo == null && this.getBuildContext() != null && this.getBuildContext().isGray()) {
            AppRebuilder mr = new AppRebuilder(this.getBuildContext().getRebuildAppGroup());
            this.appInfo = mr.getMasterAppInfo(this.getBizappId());
        }
        if (this.appInfo == null) {
            return null;
        }
        return this.appInfo.getNumber();
    }

    public String getBizIsv() {
        if (this.appInfo == null) {
            this.appInfo = MetadataDao.getMasterAppInfo(this.getBizappId());
        }
        if (this.appInfo == null) {
            return null;
        }
        return this.appInfo.getIsv();
    }

    @Override
    protected void fillTermRes() {
    }

    @Override
    public void fillTermRes(Map<String, Map<String, Object>> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        MetadataSerializer serializer = new MetadataSerializer(this.getModelType());
        ArrayList<Map<String, Map<String, Object>>> list = new ArrayList<Map<String, Map<String, Object>>>(map.size());
        for (Map.Entry<String, Map<String, Object>> item : map.entrySet()) {
            HashMap<String, Map<String, Object>> data = new HashMap<String, Map<String, Object>>(1);
            data.put(item.getKey(), item.getValue());
            list.add(data);
        }
        LangWriter writer = new LangWriter(serializer.getBinder(), this, list);
        IInteService inteService = (IInteService)ServiceFactory.getService(IInteService.class);
        List languages = inteService.getRebuildMetaLang();
        ArrayList<String> supportLanguages = new ArrayList<String>(languages.size());
        if (null != languages && !languages.isEmpty()) {
            for (EnabledLang lang : languages) {
                if (!StringUtils.isNotBlank((CharSequence)lang.getNumber())) continue;
                supportLanguages.add(lang.getNumber());
            }
        }
        writer.setLocaleValue(supportLanguages, true);
    }

    static {
        bampMoveAppList.add("base");
        bampMoveAppList.add("cts");
        bampMoveAppList.add("secm");
        bampMoveAppList.add("customize");
        bampMoveAppList.add("open");
        bampMoveAppList.add("sbd");
        bampMoveAppList.add("mpdm");
        bampMoveAppList.add("gmc");
    }
}

