/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.form;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.exception.KDBizException;
import kd.bos.fs.util.StringUtils;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.DesignMeta;
import kd.bos.metadata.DesignMetaL;
import kd.bos.metadata.IEntityBinder;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.dao.MetadataSerializer;
import kd.bos.metadata.dao.MsMetadataDaoFacade;
import kd.bos.metadata.dao.PrintDataSourceReader;
import kd.bos.metadata.domainmodel.DomainModelBinder;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.metadata.entity.DesignEntityMeta;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.DesignFormMeta;
import kd.bos.metadata.form.DesignFormMetaL;
import kd.bos.metadata.form.PrintFormAp;
import kd.bos.metadata.form.RuntimeFormMeta;
import kd.bos.metadata.lang.LangItemBuilder;
import kd.bos.metadata.print.control.Amount;
import kd.bos.metadata.print.control.BaseContainer;
import kd.bos.metadata.print.control.BaseControl;
import kd.bos.metadata.print.control.DataCell;
import kd.bos.metadata.print.control.DataColumn;
import kd.bos.metadata.print.control.DataGrid;
import kd.bos.metadata.print.control.DataRow;
import kd.bos.metadata.print.control.Footer;
import kd.bos.metadata.print.control.Header;
import kd.bos.metadata.print.control.LayoutCell;
import kd.bos.metadata.print.control.LayoutColumn;
import kd.bos.metadata.print.control.LayoutRow;
import kd.bos.metadata.print.control.Text;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class PrintMetadata
extends AbstractMetadata
implements IEntityBinder {
    private List<BaseControl<?>> items = new ArrayList();
    private Map<String, BaseControl<?>> mapItems;
    private MsMetadataDaoFacade facade = new MsMetadataDaoFacade();
    private PrintFormAp rootAp;
    private String Id;
    private String entityId;
    private LocaleString name;
    private boolean isInitialize;
    private Map<String, DynamicObjectType> dynamicObjectTypes;
    private Map<String, Class<?>> allType = null;

    public PrintFormAp getRootAp() {
        return this.rootAp;
    }

    public void setRootAp(PrintFormAp rootAp) {
        this.rootAp = rootAp;
    }

    @Override
    @SimplePropertyAttribute
    public String getId() {
        return this.Id;
    }

    @Override
    public void setId(String id) {
        this.Id = id;
        if (!this.isInitialize) {
            this.createIndex();
            if (this.rootAp != null) {
                this.rootAp.setId(id);
            }
        }
    }

    @SimplePropertyAttribute
    public String getKey() {
        this.createIndex();
        if (this.rootAp == null) {
            return null;
        }
        return this.rootAp.getKey();
    }

    public void setKey(String key) {
        if (!this.isInitialize) {
            this.createIndex();
            if (this.rootAp != null) {
                this.rootAp.setKey(key);
            }
        }
    }

    @SimplePropertyAttribute
    public LocaleString getName() {
        return this.name;
    }

    public void setName(LocaleString name) {
        this.name = name;
        if (!this.isInitialize) {
            this.createIndex();
            if (this.rootAp != null) {
                this.rootAp.setName(name);
            }
        }
    }

    @Override
    @SimplePropertyAttribute
    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String value) {
        this.entityId = value;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=BaseControl.class)
    public List<BaseControl<?>> getItems() {
        return this.items;
    }

    public List<BaseControl<?>> getRootItems() {
        ArrayList controls = new ArrayList();
        for (BaseControl<?> control : this.items) {
            if (!control.getParentId().equals(this.getId())) continue;
            controls.add(control);
        }
        return controls;
    }

    public List<BaseControl<?>> getLeafItems() {
        ArrayList controls = new ArrayList();
        for (BaseControl<?> control : this.items) {
            if (control.getParentId().equals(this.getId())) continue;
            controls.add(control);
        }
        return controls;
    }

    public List<BaseControl<?>> getHeaderOrFooterItems() {
        ArrayList controls = new ArrayList();
        for (BaseControl<?> control : this.items) {
            if (!(control instanceof Header) && !(control instanceof Footer)) continue;
            controls.add(control);
        }
        return controls;
    }

    public List<BaseControl<?>> getDataGridItems() {
        ArrayList grids = new ArrayList();
        for (BaseControl<?> control : this.items) {
            if (!(control instanceof DataGrid)) continue;
            grids.add(control);
        }
        return grids;
    }

    public Map<String, Object> builderDesignerControls() {
        this.createIndex();
        return this.rootAp.createDesignerControl();
    }

    public Map<String, DynamicObjectType> getDynamicObjectTypes() {
        if (this.dynamicObjectTypes == null) {
            this.dynamicObjectTypes = this.buildDynamicObjectTypes();
        }
        return this.dynamicObjectTypes;
    }

    private Map<String, DynamicObjectType> buildDynamicObjectTypes() {
        HashMap<String, DynamicObjectType> dTypes = new HashMap<String, DynamicObjectType>();
        String customDataSource = this.rootAp.getCustomDataSource();
        if (customDataSource != null) {
            Map cusDataSource = (Map)SerializationUtils.fromJsonString((String)customDataSource, Map.class);
            ArrayList dsentrys = (ArrayList)cusDataSource.get("dsentry");
            for (Object dsentry : dsentrys) {
                String dsnumber = (String)((Map)dsentry).get("dsnumber");
                String dsdatas = (String)((Map)dsentry).get("dsdata");
                Map dsdata = (Map)SerializationUtils.fromJsonString((String)dsdatas, Map.class);
                ArrayList queryfieldentrys = (ArrayList)dsdata.get("queryfieldentry");
                DynamicObjectType dt = new DynamicObjectType(dsnumber);
                if (queryfieldentrys != null) {
                    String fieldname = "";
                    String fieldType = "";
                    for (Object queryfieldentry : queryfieldentrys) {
                        fieldname = (String)((Map)queryfieldentry).get("fieldname");
                        if (StringUtils.isEmpty((String)fieldname)) continue;
                        fieldType = (String)((Map)queryfieldentry).get("datatype");
                        if (StringUtils.isEmpty((String)fieldType)) {
                            fieldType = "String";
                        }
                        try {
                            dt.registerProperty(fieldname, this.getClassType(fieldType.toLowerCase()), null, false);
                        }
                        catch (ClassNotFoundException e) {
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u81ea\u5b9a\u4e49\u6570\u636e\u6e90\u4e2d\u81ea\u5b9a\u4e49\u5b57\u6bb5%1$s\u7684\u6570\u636e\u7c7b\u578b%2$s", (String)"PrintMetadata_2", (String)"bos-metadata", (Object[])new Object[0]), fieldname, fieldType));
                        }
                    }
                }
                dTypes.put(dsnumber, dt);
            }
        }
        return dTypes;
    }

    private Class<?> getClassType(String dataType) throws ClassNotFoundException {
        if (this.allType == null) {
            this.allType = new HashMap();
            this.allType.put("id", Class.forName("java.lang.String"));
            this.allType.put("string", Class.forName("java.lang.String"));
            this.allType.put("text", Class.forName("java.lang.String"));
            this.allType.put("integer", Class.forName("java.lang.Integer"));
            this.allType.put("date", Class.forName("java.util.Date"));
            this.allType.put("boolean", Class.forName("java.lang.Boolean"));
            this.allType.put("decimal", Class.forName("java.math.BigDecimal"));
        }
        Class<?> type = null;
        type = this.allType.containsKey(dataType) ? this.allType.get(dataType) : Class.forName("java.lang.String");
        return type;
    }

    RuntimeFormMeta createRuntimeFormMeta() {
        RuntimeFormMeta meta = new RuntimeFormMeta();
        meta.setId(this.getId());
        meta.setNumber(this.getKey());
        return meta;
    }

    public BaseControl<?> getItem(String id) {
        return this.mapItems.get(id);
    }

    public void createIndex(boolean forceRefesh) {
        if ((this.rootAp == null || forceRefesh) && this.items.size() > 0) {
            BaseContainer cap;
            this.mapItems = new HashMap(16);
            for (BaseControl<?> ap : this.items) {
                this.mapItems.put(ap.getId(), ap);
                if (ap instanceof BaseContainer) {
                    ((BaseContainer)ap).get().clear();
                }
                if (!(ap instanceof PrintFormAp)) continue;
                this.rootAp = (PrintFormAp)ap;
            }
            for (BaseControl<?> ap : this.items) {
                if (ap instanceof DataRow) {
                    cap = (BaseContainer)this.mapItems.get(ap.getParentId());
                    ap.setDataSource(cap.getDataSource());
                }
                if (!(ap instanceof Amount)) continue;
                if (this.rootAp.getInteFormat() != null) {
                    Map inteFormat = (Map)SerializationUtils.fromJsonString((String)this.rootAp.getInteFormat(), Map.class);
                    Long inteFormatId = 0L;
                    if (!ObjectUtils.isEmpty(inteFormat.get("id"))) {
                        inteFormatId = Long.valueOf((String)inteFormat.get("id"));
                    }
                    ((Amount)ap).setInteFormatId(inteFormatId);
                    continue;
                }
                ((Amount)ap).setInteFormatId(0L);
            }
            for (BaseControl<?> ap : this.items) {
                cap = (BaseContainer)this.mapItems.get(ap.getParentId());
                if (cap == null) {
                    cap = this.rootAp;
                }
                if (cap == ap || cap.get() == null) continue;
                if ((ap instanceof LayoutRow || ap instanceof LayoutColumn || ap instanceof DataRow || ap instanceof DataColumn) && StringUtils.isEmpty((String)ap.getForeColor())) {
                    ap.setForeColor(cap.getForeColor());
                }
                if (ap instanceof LayoutCell) {
                    if (StringUtils.isEmpty((String)ap.getBackColor())) {
                        ap.setBackColor(cap.getBackColor());
                        if (StringUtils.isEmpty((String)ap.getForeColor())) {
                            ap.setForeColor(cap.getForeColor());
                        }
                    }
                    if (StringUtils.isEmpty((String)ap.getForeColor())) {
                        ap.setForeColor(cap.getForeColor());
                    }
                }
                if (ap instanceof DataCell) {
                    ap.setDataSource(cap.getDataSource());
                }
                cap.get().add(ap);
                if (cap != this.rootAp) continue;
                ap.setParentId(cap.getId());
            }
        }
    }

    public void createIndex() {
        this.createIndex(false);
    }

    @Override
    public void beginInit() {
        this.isInitialize = true;
    }

    @Override
    public void endInit() {
        this.sortItems();
        this.isInitialize = false;
    }

    private void sortItems() {
        Collections.sort(this.items, new Comparator<BaseControl<?>>(){

            @Override
            public int compare(BaseControl<?> o1, BaseControl<?> o2) {
                int compareValue = 0;
                compareValue = o1.getParentId() == null && o2.getParentId() == null ? 0 : (o1.getParentId() == null && o2.getParentId() != null ? -1 : (o1.getParentId() != null && o2.getParentId() == null ? 1 : o1.getParentId().compareTo(o2.getParentId())));
                if (compareValue != 0) {
                    return compareValue;
                }
                return Integer.compare(o1.getIndex(), o2.getIndex());
            }
        });
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialize;
    }

    @Override
    public IDataEntityType getDesingerMetaType() {
        return OrmUtils.getDataEntityType(DesignFormMeta.class);
    }

    @Override
    public IDataEntityType getDesingerMetaLType() {
        return OrmUtils.getDataEntityType(DesignFormMetaL.class);
    }

    @Override
    protected void setDesignMeta(DesignMeta designMeta) {
        super.setDesignMeta(designMeta);
        designMeta.setNumber(this.getKey());
        ((DesignFormMeta)designMeta).setEntityId(this.getEntityId());
        ((DesignFormMeta)designMeta).setModifierId(RequestContext.get().getUserId());
        ((DesignFormMeta)designMeta).setModifyDate(this.convertTime(new Date(), TimeZone.getDefault(), TimeZone.getTimeZone("Asia/Shanghai")));
    }

    private Date convertTime(Date time, TimeZone from, TimeZone to) {
        if (from.equals(to)) {
            return time;
        }
        int offset = to.getRawOffset();
        int dstoffset = to.getDSTSavings();
        return new Date(time.getTime() - (long)from.getRawOffset() + (long)offset + (long)dstoffset);
    }

    @Override
    protected void setDesignMetaL(String localeId, DesignMetaL designMetaL) {
        super.setDesignMetaL(localeId, designMetaL);
        designMetaL.setNumber(this.getKey());
        designMetaL.setName((String)this.getName().getItem(localeId));
    }

    @Override
    public Map<String, Object> buildDesignMeta(String lang) {
        Map<String, Object> clientMeta = super.buildDesignMeta(lang);
        clientMeta.put("ui", this.builderDesignerControls());
        MetadataSerializer ser = new MetadataSerializer(this.getModelType());
        DomainModelBinder binder = (DomainModelBinder)ser.getBinder();
        binder.setLCId(lang);
        binder.setWriteInheritFlag(true);
        this.getRootAp().setLanguage(lang);
        clientMeta.put("language", this.getRootAp().getLanguage());
        clientMeta.put("formmeta", ser.serializeToMap(this));
        clientMeta.put("entityreadonly", true);
        MetadataReader reader = new MetadataReader(false);
        EntityMetadata entityMetadata = (EntityMetadata)reader.readMeta(this.entityId, OrmUtils.getDataEntityType(DesignEntityMeta.class), true);
        Map<String, Object> entityTree = null;
        PrintDataSourceReader entityDataSourceReader = new PrintDataSourceReader();
        entityTree = "QueryListModel".equals(entityMetadata.getModelType()) ? entityDataSourceReader.buildQueryEntityDataSourceTree(entityMetadata) : ("DynamicFormModel".equals(entityMetadata.getModelType()) ? entityDataSourceReader.buildDataSourceTree(entityMetadata, false) : entityDataSourceReader.buildDataSourceTree(entityMetadata));
        PrintDataSourceReader wfDataSourceReader = new PrintDataSourceReader();
        this.facade.beforeBuildDesignMeta(this, clientMeta, entityMetadata);
        if (null != entityTree) {
            clientMeta.put("entitytree", entityTree);
        }
        clientMeta.put("formulatree", wfDataSourceReader.buildFormulaTree());
        Map<String, Object> attachPanelTree = entityDataSourceReader.buildAttachPanelTree(this.entityId);
        if (attachPanelTree != null) {
            clientMeta.put("attachPanelTree", attachPanelTree);
        }
        clientMeta.put("id", this.getId());
        clientMeta.put("isprint", true);
        clientMeta.put("caption", this.getName().get((Object)lang));
        clientMeta.put("localeItems", this.getLocaleItems());
        clientMeta.put("isPC", true);
        clientMeta.put("isdeveloper", true);
        clientMeta.put("borderPx", 9);
        return clientMeta;
    }

    public Map<String, Set<String>> getBindFields() {
        HashMap<String, Set<String>> hs = new HashMap<String, Set<String>>();
        for (BaseControl<?> control : this.getItems()) {
            String field;
            String ds;
            String type;
            if (control instanceof Text) {
                Text t = (Text)control;
                type = t.getBindType();
                ds = t.getDataSource();
                field = t.getBindField();
                if ("field".equals(type) && StringUtils.isNotEmpty((String)field) && StringUtils.isNotEmpty((String)ds)) {
                    if (hs.containsKey(ds)) {
                        ((Set)hs.get(ds)).add(field);
                    } else {
                        HashSet<String> bindFields = new HashSet<String>();
                        bindFields.add(field);
                        hs.put(ds, bindFields);
                    }
                }
            }
            if (!(control instanceof DataCell)) continue;
            DataCell dc = (DataCell)control;
            type = dc.getCellType();
            ds = dc.getDataSource();
            field = dc.getBindField();
            if (!"field".equals(type) && !"stat".equals(type) || !StringUtils.isNotEmpty((String)field) || !StringUtils.isNotEmpty((String)ds)) continue;
            String fullName = String.format("%s.%s", dc.getDataSource(), dc.getBindField());
            if (hs.containsKey(ds)) {
                ((Set)hs.get(ds)).add(fullName);
                continue;
            }
            HashSet<String> bindFields = new HashSet<String>();
            bindFields.add(fullName);
            hs.put(ds, bindFields);
        }
        return hs;
    }

    public Object getLocaleItems() {
        DomainModelType domainModel = DomainModelType.getDomainModelType(this.getModelType(), false);
        LangItemBuilder builder = new LangItemBuilder(new DomainModelBinder(domainModel));
        HashMap ret = new HashMap();
        builder.builderResouces(this, null);
        ret.put("form", builder.getLocaleItemValues());
        return ret;
    }
}

