/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.form.cardentry;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.FieldEdit;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.cardentry.CardEntryRowAp;
import kd.bos.metadata.form.cardentry.CardEntryViewAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class CardEntryAp
extends EntryAp {
    private boolean showHeaderLine = false;
    private boolean totalLineNumber = false;

    @Override
    public EntryGrid createRuntimeControl() {
        return new CardEntry();
    }

    @SimplePropertyAttribute(name="ShowHeaderLine")
    @DefaultValueAttribute(value="false")
    public boolean isShowHeaderLine() {
        return this.showHeaderLine;
    }

    public void setShowHeaderLine(boolean showHeaderLine) {
        this.showHeaderLine = showHeaderLine;
    }

    @SimplePropertyAttribute(name="TotalLineNumber")
    @DefaultValueAttribute(value="false")
    public boolean isTotalLineNumber() {
        return this.totalLineNumber;
    }

    public void setTotalLineNumber(boolean totalLineNumber) {
        this.totalLineNumber = totalLineNumber;
    }

    @Override
    public Map<String, Object> createControl() {
        Map<String, Object> ctl = super.createControl();
        ctl.put("type", "advgrid");
        if (this.isShowHeaderLine()) {
            ctl.put("showHeaderLine", this.isShowHeaderLine());
        }
        if (this.isTotalLineNumber()) {
            ctl.put("totalLineNumber", this.isTotalLineNumber());
        }
        return ctl;
    }

    @Override
    protected void createChildControls(Map<String, Object> ctl) {
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>(10);
        for (ControlAp<?> ctlAp : this.getItems()) {
            items.add(ctlAp.createControl());
        }
        if (items.size() > 0) {
            ctl.put("items", items);
        }
    }

    @Override
    protected void buildRuntimeChildControls(Container ctl) {
        super.buildRuntimeChildControls(ctl);
        List items = ctl.getItems();
        this.addBKImgField(items);
    }

    private void addBKImgField(List<Control> items) {
        Field<?> imgField = this.getBKImgField();
        if (imgField != null) {
            HashSet<String> fields = new HashSet<String>();
            for (Control c : items) {
                if (!(c instanceof FieldEdit)) continue;
                fields.add(((FieldEdit)c).getFieldKey());
            }
            if (!fields.contains(imgField.getKey())) {
                FieldEdit edit = imgField.buildServerEditor();
                edit.setKey(imgField.getKey());
                items.add((Control)edit);
            }
        }
    }

    private Field<?> getBKImgField() {
        for (ControlAp<?> controlAp : this.getItems()) {
            if (!(controlAp instanceof CardEntryViewAp)) continue;
            for (ControlAp<?> childAp : ((CardEntryViewAp)controlAp).getItems()) {
                if (!(childAp instanceof CardEntryRowAp)) continue;
                String fieldId = ((CardEntryRowAp)childAp).getBKImgFieldId();
                if (this.formMetadata == null) continue;
                return this.formMetadata.getEntityMetadata().getFieldById(fieldId);
            }
        }
        return null;
    }
}

