/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.form.cardentry;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.control.EntryGrid;
import kd.bos.metadata.entity.commonfield.LongPressItem;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.FormAp;
import kd.bos.metadata.form.MobileBillFormAp;
import kd.bos.metadata.form.MobileFormAp;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class CardEntryViewAp
extends ContainerAp<Container> {
    private int layoutStyle = 1;
    private boolean pointer;
    private boolean paginationHide = true;
    private String direction = "row";
    private boolean wrap = true;
    private boolean scrollLoad = false;
    private boolean pullRefresh = false;
    private boolean showNoDataTip = true;
    private boolean mobShowNoDataTip = false;
    private String toolbarLocation = "-1";
    private List<LongPressItem> longPressItems = new ArrayList<LongPressItem>();
    private String pageType = "";

    @CollectionPropertyAttribute(collectionItemPropertyType=LongPressItem.class, name="LongPressOperation")
    public List<LongPressItem> getLongPressItems() {
        return this.longPressItems;
    }

    public void setLongPressItems(List<LongPressItem> longPressItems) {
        this.longPressItems = longPressItems;
    }

    @SimplePropertyAttribute(name="ScrollLoad")
    @DefaultValueAttribute(value="false")
    public boolean isScrollLoad() {
        return this.scrollLoad;
    }

    public void setScrollLoad(boolean scrollLoad) {
        this.scrollLoad = scrollLoad;
    }

    @SimplePropertyAttribute(name="PullRefresh")
    @DefaultValueAttribute(value="false")
    public boolean isPullRefresh() {
        return this.pullRefresh;
    }

    public void setPullRefresh(boolean pullRefresh) {
        this.pullRefresh = pullRefresh;
    }

    @SimplePropertyAttribute(name="PaginationHide")
    @DefaultValueAttribute(value="true")
    public boolean isPaginationHide() {
        return this.paginationHide;
    }

    public void setPaginationHide(boolean paginationHide) {
        this.paginationHide = paginationHide;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="row")
    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    @SimplePropertyAttribute(name="Wrap")
    @DefaultValueAttribute(value="true")
    public boolean isWrap() {
        return this.wrap;
    }

    public void setWrap(boolean warp) {
        this.wrap = warp;
    }

    @SimplePropertyAttribute(name="Pointer")
    public boolean isPointer() {
        return this.pointer;
    }

    public void setPointer(boolean pointer) {
        this.pointer = pointer;
    }

    @SimplePropertyAttribute(name="ShowNoDataTip")
    @DefaultValueAttribute(value="true")
    public boolean isShowNoDataTip() {
        return this.showNoDataTip;
    }

    public void setShowNoDataTip(boolean showNoDataTip) {
        this.showNoDataTip = showNoDataTip;
    }

    @SimplePropertyAttribute(name="MobShowNoDataTip")
    @DefaultValueAttribute(value="false")
    public boolean isMobShowNoDataTip() {
        return this.mobShowNoDataTip;
    }

    public void setMobShowNoDataTip(boolean mobShowNoDataTip) {
        this.mobShowNoDataTip = mobShowNoDataTip;
    }

    @Override
    public EntryGrid createRuntimeControl() {
        return new CardEntry();
    }

    @SimplePropertyAttribute
    public int getLayoutStyle() {
        return this.layoutStyle;
    }

    public void setLayoutStyle(int cols) {
        this.layoutStyle = cols;
    }

    @SimplePropertyAttribute(name="ToolbarLocation")
    @DefaultValueAttribute(value="-1")
    public String getToolbarLocation() {
        return this.toolbarLocation;
    }

    public void setToolbarLocation(String toolbarLocation) {
        this.toolbarLocation = toolbarLocation;
    }

    public void setPageType(String type) {
        this.pageType = type;
    }

    @SimplePropertyAttribute(name="PageType")
    public String getPageType() {
        return this.pageType;
    }

    @Override
    public Map<String, Object> createControl() {
        Map<String, Object> ctl = super.createControl();
        ctl.put("type", "cardview");
        ctl.put("rk", "rk");
        ctl.put("phide", this.paginationHide);
        ctl.put("ls", this.layoutStyle);
        ctl.put("pt", this.getPageType());
        List<LongPressItem> items = this.getLongPressItems();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(items.size());
        for (LongPressItem item : items) {
            Map<String, Object> control = item.createControl();
            list.add(control);
        }
        ctl.put("longPressInvokeAction", list);
        ctl.put("dr", this.direction);
        ctl.put("wr", this.wrap);
        if (this.pointer) {
            ctl.put("point", this.pointer);
        }
        if (this.scrollLoad) {
            ctl.put("scrollload", this.scrollLoad);
        }
        if (this.pullRefresh) {
            ctl.put("pr", this.pullRefresh);
        }
        if (this.formMetadata != null) {
            boolean isMobForm;
            FormAp rootAp = this.formMetadata.getRootAp();
            boolean bl = isMobForm = rootAp instanceof MobileBillFormAp || rootAp instanceof MobileFormAp;
            if (isMobForm) {
                ctl.put("shownodatatip", this.mobShowNoDataTip);
            } else if (!this.showNoDataTip) {
                ctl.put("shownodatatip", this.showNoDataTip);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.toolbarLocation) && !"-1".equals(this.toolbarLocation)) {
            ctl.put("tl", this.toolbarLocation);
        }
        return ctl;
    }

    @Override
    protected void setRuntimeSimpleProperties(Container ctl) {
        super.setRuntimeSimpleProperties(ctl);
        CardEntry cardEntry = (CardEntry)ctl;
        cardEntry.setPageType(this.getPageType());
    }
}

