/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.form.container;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.Tips;
import kd.bos.form.container.TabPage;
import kd.bos.metadata.entity.commonfield.DropdownItem;
import kd.bos.metadata.entity.operation.Operation;
import kd.bos.metadata.form.ContainerAp;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class TabPageAp
extends ContainerAp<TabPage> {
    private String imageKey;
    private boolean homeTab;
    private List<DropdownItem> tabPageOperationItems = new ArrayList<DropdownItem>();
    private boolean canFull;
    private Tips ctlTips;

    @CollectionPropertyAttribute(collectionItemPropertyType=DropdownItem.class)
    public List<DropdownItem> getTabPageOperationItems() {
        return this.tabPageOperationItems;
    }

    public void setTabPageOperationItems(List<DropdownItem> tabPageOperationItems) {
        this.tabPageOperationItems = tabPageOperationItems;
    }

    @SimplePropertyAttribute
    public String getImageKey() {
        return this.imageKey;
    }

    public void setImageKey(String imageKey) {
        this.imageKey = imageKey;
    }

    @SimplePropertyAttribute(name="HomeTab")
    public boolean isHomeTab() {
        return this.homeTab;
    }

    public void setHomeTab(boolean homeTab) {
        this.homeTab = homeTab;
    }

    public boolean isCanFull() {
        return this.canFull;
    }

    public void setCanFull(boolean canFull) {
        this.canFull = canFull;
    }

    public Tips getCtlTips() {
        return this.ctlTips;
    }

    public void setCtlTips(Tips ctlTips) {
        this.ctlTips = ctlTips;
    }

    @Override
    public Map<String, Object> createControl() {
        Map<String, Object> ctl = super.createControl();
        ctl.put("type", "tabpage");
        ctl.put("text", this.getName());
        if (StringUtils.isNotBlank((CharSequence)this.imageKey)) {
            ctl.put("imageKey", this.imageKey);
        }
        if (this.homeTab) {
            ctl.put("homet", this.homeTab);
        }
        if (this.tabPageOperationItems.size() > 0) {
            ctl.put("menus", this.createItems());
        }
        if (this.canFull) {
            ctl.put("canFull", this.canFull);
        }
        if (this.getCtlTips() != null) {
            ctl.put("tips", this.getCtlTips());
        }
        return ctl;
    }

    private List<Map<String, Object>> createItems() {
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>(10);
        for (DropdownItem item : this.tabPageOperationItems) {
            Optional<Operation> value;
            Map<String, Object> ctrl = item.createControl();
            if (StringUtils.isNotBlank((CharSequence)item.getOperationKey()) && this.formMetadata != null && (value = this.formMetadata.getEntityMetadata().getRootEntity().getOperations().stream().filter(o -> StringUtils.equals((CharSequence)item.getOperationKey(), (CharSequence)o.getKey())).findFirst()).isPresent()) {
                Optional<Operation> submit;
                Operation oper = value.get();
                if ("submitandnew".equalsIgnoreCase(oper.getOperationType()) && (submit = this.formMetadata.getEntityMetadata().getRootEntity().getOperations().stream().filter(o -> StringUtils.equals((CharSequence)"submit", (CharSequence)o.getOperationType())).findFirst()).isPresent() && StringUtils.isNotBlank((CharSequence)submit.get().getPermissionItemId())) {
                    ctrl.put("permissionId", submit.get().getPermissionItemId());
                }
                if (StringUtils.isNotBlank((CharSequence)oper.getPermissionItemId())) {
                    ctrl.put("permissionId", oper.getPermissionItemId());
                }
            }
            items.add(ctrl);
        }
        return items;
    }

    @Override
    protected TabPage createRuntimeControl() {
        return new TabPage();
    }
}

