/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.form.container;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.container.Container;
import kd.bos.form.container.Wizard;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.control.StepsOption;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class WizardAp
extends ContainerAp<Wizard> {
    private static final int DEFAULT_ARRAY_SIZE = 10;
    private static final int DEFAULT_STEP_LENGTH = 4;
    private String wizardType = "tab";
    private String tabId;
    private int wizardStyle;
    private String textDirection;
    private String statusIcon;
    private boolean nodeLinkageSubTab = false;
    private int stepLength = 4;
    private List<StepsOption> stepsOptions = new ArrayList<StepsOption>(10);

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="tab")
    public String getWizardType() {
        return this.wizardType;
    }

    public void setWizardType(String wizardType) {
        this.wizardType = wizardType;
    }

    @SimplePropertyAttribute
    public String getTextDirection() {
        return this.textDirection;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="")
    public void setTextDirection(String textDirection) {
        this.textDirection = textDirection;
    }

    @SimplePropertyAttribute
    public String getTabId() {
        return this.tabId;
    }

    public void setTabId(String tabId) {
        this.tabId = tabId;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="false")
    public boolean isNodeLinkageSubTab() {
        return this.nodeLinkageSubTab;
    }

    public void setNodeLinkageSubTab(boolean nodeLinkageSubTab) {
        this.nodeLinkageSubTab = nodeLinkageSubTab;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="0")
    public int getWizardStyle() {
        return this.wizardStyle;
    }

    public void setWizardStyle(int wizardStyle) {
        this.wizardStyle = wizardStyle;
    }

    @SimplePropertyAttribute
    public String getStatusIcon() {
        return this.statusIcon;
    }

    public void setStatusIcon(String statusIcon) {
        this.statusIcon = statusIcon;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="4")
    public int getStepLength() {
        return this.stepLength;
    }

    public void setStepLength(int stepLength) {
        this.stepLength = stepLength;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=StepsOption.class)
    public List<StepsOption> getStepsOptions() {
        return this.stepsOptions;
    }

    public void setStepsOptions(List<StepsOption> stepsOptions) {
        this.stepsOptions = stepsOptions;
    }

    @Override
    public Map<String, Object> createControl() {
        ControlAp<?> c;
        Map<String, Object> ctl = super.createControl();
        ctl.put("type", "wizard");
        ctl.put("wizardStyle", this.getWizardStyle());
        if (StringUtils.isNotBlank((CharSequence)this.getTabId()) && (c = this.formMetadata.getItem(this.getTabId())) != null) {
            ctl.put("tabid", c.getKey());
        }
        if (StringUtils.isNotBlank((CharSequence)this.textDirection)) {
            ctl.put("tDir", this.textDirection);
        }
        if (StringUtils.isNotBlank((CharSequence)this.wizardType) && !"tab".equals(this.wizardType)) {
            ctl.put("wizardType", this.wizardType);
        }
        if (StringUtils.isNotBlank((CharSequence)this.statusIcon)) {
            ctl.put("statusIcon", SerializationUtils.fromJsonString((String)this.statusIcon, Map.class));
        }
        ctl.put("stepLength", this.stepLength);
        if (!this.stepsOptions.isEmpty()) {
            ctl.put("stepsOptions", this.stepsOptions.stream().map(StepsOption::toMap).collect(Collectors.toList()));
        }
        if (this.isNodeLinkageSubTab()) {
            ctl.put("nodeLinkageSubTab", this.isNodeLinkageSubTab());
        }
        return ctl;
    }

    @Override
    public void resetItemId(Map<String, String> idMap) {
        super.resetItemId(idMap);
        String newid = idMap.get(this.getTabId());
        if (newid != null) {
            this.setTabId(newid);
        }
    }

    @Override
    protected Wizard createRuntimeControl() {
        return new Wizard();
    }

    @Override
    protected void setRuntimeSimpleProperties(Container ctl) {
        Wizard wizard = (Wizard)ctl;
        wizard.setStepsOptions(this.stepsOptions.stream().map(s -> new kd.bos.form.control.StepsOption(s.getTitle(), s.getDescription())).collect(Collectors.toList()));
        super.setRuntimeSimpleProperties((Container)wizard);
    }
}

