/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.form.control;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.form.control.CarouselFigure;
import kd.bos.form.control.CarouselFigureImageItem;
import kd.bos.metadata.form.control.ButtonAp;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class CarouselFigureAp
extends ButtonAp {
    private String basdataNumber;
    private String carouselTime = "4000";
    private boolean showSlideBar = true;
    private String slideBarAlign = "center";
    private String aspectRatio = "3:1";
    private List<CarouselFigureImageItem> carouselImg = new ArrayList<CarouselFigureImageItem>(1);
    private int carouselPoint;
    private int carouselPageTurn;
    private boolean carouselStopSpinning;

    @SimplePropertyAttribute
    public String getBasdataNumber() {
        return this.basdataNumber;
    }

    public void setBasdataNumber(String basdataNumber) {
        this.basdataNumber = basdataNumber;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="4000")
    public String getCarouselTime() {
        return this.carouselTime;
    }

    public void setCarouselTime(String carouselTime) {
        this.carouselTime = carouselTime;
    }

    @SimplePropertyAttribute(name="ShowSlideBar")
    @DefaultValueAttribute(value="true")
    public boolean isShowSlideBar() {
        return this.showSlideBar;
    }

    public void setShowSlideBar(boolean showSlideBar) {
        this.showSlideBar = showSlideBar;
    }

    @SimplePropertyAttribute(name="SlideBarAlign")
    @DefaultValueAttribute(value="center")
    public String getSlideBarAlign() {
        return this.slideBarAlign;
    }

    public void setSlideBarAlign(String slideBarAlign) {
        this.slideBarAlign = slideBarAlign;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="3:1")
    public String getAspectRatio() {
        return this.aspectRatio;
    }

    public void setAspectRatio(String aspectRatio) {
        this.aspectRatio = aspectRatio;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=CarouselFigureImageItem.class)
    public List<CarouselFigureImageItem> getCarouselImg() {
        return this.carouselImg;
    }

    public void setCarouselImg(List<CarouselFigureImageItem> carouselImg) {
        this.carouselImg = carouselImg;
    }

    @SimplePropertyAttribute(name="CarouselDotPosition")
    public int getCarouselPoint() {
        return this.carouselPoint;
    }

    public void setCarouselPoint(int carouselPoint) {
        this.carouselPoint = carouselPoint;
    }

    @SimplePropertyAttribute(name="CarouselSlideBtn")
    public int getCarouselPageTurn() {
        return this.carouselPageTurn;
    }

    public void setCarouselPageTurn(int carouselPageTurn) {
        this.carouselPageTurn = carouselPageTurn;
    }

    @SimplePropertyAttribute(name="CarouselStopOnHover")
    public boolean isCarouselStopSpinning() {
        return this.carouselStopSpinning;
    }

    public void setCarouselStopSpinning(boolean carouselStopSpinning) {
        this.carouselStopSpinning = carouselStopSpinning;
    }

    @Override
    public Map<String, Object> createControl() {
        Map<String, Object> ctl = super.createControl();
        ORM orm = ORM.create();
        ArrayList<String> urls = new ArrayList<String>();
        ctl.put("type", "carousel");
        if (this.basdataNumber != null) {
            QFilter filter = new QFilter("number", "=", (Object)this.basdataNumber);
            try (DataSet ds = orm.queryDataSet("CarouselFigureAp.createControl", "bos_carouselbase", "entryentity.picturefield picturefield", new QFilter[]{filter}, "");){
                DynamicObjectCollection rows = orm.toPlainDynamicObjectCollection(ds);
                if (rows.size() > 0) {
                    for (DynamicObject dynamicObject : rows) {
                        if (dynamicObject.get("picturefield") == null) continue;
                        urls.add(dynamicObject.getString("picturefield"));
                    }
                }
            }
        }
        ArrayList defaultImage = new ArrayList(10);
        if (this.carouselImg != null) {
            for (CarouselFigureImageItem item : this.carouselImg) {
                HashMap<String, String> map = new HashMap<String, String>(2);
                map.put("name", item.getName());
                map.put("url", item.getUrl());
                defaultImage.add(map);
            }
        }
        String[] a = new String[urls.size()];
        ctl.put("carouselpicture", urls.toArray(a));
        ctl.put("duration", this.getCarouselTime());
        ctl.put("showslidebar", this.isShowSlideBar());
        ctl.put("slidebaralign", this.getSlideBarAlign());
        ctl.put("aspectratio", this.getAspectRatio());
        ctl.put("defaultImage", defaultImage.toArray());
        if (this.getCarouselPoint() != 0) {
            ctl.put("carouseldp", this.getCarouselPoint());
        }
        if (this.getCarouselPoint() != 1 && this.getCarouselPageTurn() != 0) {
            ctl.put("carouselsb", this.getCarouselPageTurn());
        }
        if (this.isCarouselStopSpinning()) {
            ctl.put("carouselsoh", this.isCarouselStopSpinning());
        }
        return ctl;
    }

    @Override
    protected CarouselFigure createRuntimeControl() {
        CarouselFigure carouselFigure = new CarouselFigure();
        carouselFigure.setBasdataNumber(this.basdataNumber);
        carouselFigure.setImageItems(this.carouselImg);
        return carouselFigure;
    }
}

