/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.form.control;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.form.container.Container;
import kd.bos.form.control.EntryFieldContainer;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class EntryFieldContainerAp
extends ContainerAp<EntryFieldContainer> {
    private String direction = "row";
    private boolean wrap = true;

    @SimplePropertyAttribute
    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    @SimplePropertyAttribute(name="Wrap")
    @DefaultValueAttribute(value="true")
    public boolean isWrap() {
        return this.wrap;
    }

    public void setWrap(boolean warp) {
        this.wrap = warp;
    }

    @Override
    public Map<String, Object> createControl() {
        Map<String, Object> ctl = super.createControl();
        ctl.put("header", this.getName());
        ctl.put("children", this.createColumns());
        ctl.put("dataIndex", this.getKey().toLowerCase());
        ctl.put("type", "container");
        if (this.isInvisible()) {
            ctl.put("vi", 0);
        } else {
            ctl.put("vi", this.getVisibleValue());
        }
        ctl.put("dr", this.direction);
        ctl.put("wr", this.wrap);
        return ctl;
    }

    @Override
    protected void createChildControls(Map<String, Object> ctl) {
    }

    private List<Object> createColumns() {
        ArrayList<Object> cols = new ArrayList<Object>();
        for (ControlAp<?> item : this.getItems()) {
            if (item.getVisibleValue() == 0) continue;
            if (item instanceof EntryFieldContainerAp) {
                cols.add(item.createControl());
                continue;
            }
            EntryFieldAp fldAp = (EntryFieldAp)item;
            List<Object> newCols = fldAp.createColumns();
            cols.addAll(newCols);
        }
        return cols;
    }

    @Override
    protected EntryFieldContainer createRuntimeControl() {
        return new EntryFieldContainer();
    }

    @Override
    protected void setRuntimeSimpleProperties(Container ctl) {
        super.setRuntimeSimpleProperties(ctl);
    }
}

