/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.form.control;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.Tips;
import kd.bos.form.container.Container;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class EntryFieldGroupAp
extends ContainerAp<Container> {
    private static final String DEFAULT = "default";
    private static final String FILTER = "filter";
    private static final String SORT = "sort";
    private boolean hide;
    private boolean freeze;
    private boolean merge;
    private boolean groupCollapsible;
    private boolean groupDefaultCollapse;
    private String textAlign = "default";
    private Tips ctlTips;

    @ComplexPropertyAttribute
    public Tips getCtlTips() {
        return this.ctlTips;
    }

    public void setCtlTips(Tips ctlTips) {
        this.ctlTips = ctlTips;
    }

    @Override
    @SimplePropertyAttribute
    @DefaultValueAttribute(value="default")
    public String getTextAlign() {
        return this.textAlign;
    }

    @Override
    public void setTextAlign(String textAlign) {
        this.textAlign = textAlign;
    }

    @SimplePropertyAttribute(name="Freeze")
    public boolean isFreeze() {
        return this.freeze;
    }

    public void setFreeze(boolean isFreeze) {
        this.freeze = isFreeze;
    }

    @SimplePropertyAttribute(name="Hide")
    public boolean isHide() {
        return this.hide;
    }

    public void setHide(boolean isHide) {
        this.hide = isHide;
    }

    @SimplePropertyAttribute(name="Merge")
    public boolean isMerge() {
        return this.merge;
    }

    public void setMerge(boolean isMerge) {
        this.merge = isMerge;
    }

    @SimplePropertyAttribute(name="GroupCollapsible")
    public boolean isGroupCollapsible() {
        return this.groupCollapsible;
    }

    public void setGroupCollapsible(boolean groupCollapsible) {
        this.groupCollapsible = groupCollapsible;
    }

    @SimplePropertyAttribute(name="GroupDefaultCollapse")
    public boolean isGroupDefaultCollapse() {
        return this.groupDefaultCollapse;
    }

    public void setGroupDefaultCollapse(boolean groupDefaultCollapse) {
        this.groupDefaultCollapse = groupDefaultCollapse;
    }

    @Override
    public Map<String, Object> createControl() {
        HashMap<String, Object> ctl = new HashMap<String, Object>(6);
        ctl.put("header", this.getName());
        ctl.put("children", this.createColumns(0));
        ctl.put("dataIndex", this.getKey().toLowerCase());
        ctl.put("groupcollapsible", this.isGroupCollapsible());
        ctl.put("groupdefaultcollapse", this.isGroupDefaultCollapse());
        if (this.isInvisible()) {
            ctl.put("vi", 0);
        } else {
            ctl.put("vi", this.getVisibleValue());
        }
        if (!DEFAULT.equals(this.getTextAlign())) {
            ctl.put("text-align", this.getTextAlign());
        }
        if (this.getCtlTips() != null) {
            ctl.put("tips", this.getCtlTips());
        }
        return ctl;
    }

    public Map<String, Object> createControl(int orderAndFilter) {
        HashMap<String, Object> ctl = new HashMap<String, Object>(6);
        ctl.put("header", this.getName());
        ctl.put("children", this.createColumns(orderAndFilter));
        ctl.put("dataIndex", this.getKey().toLowerCase());
        ctl.put("groupcollapsible", this.isGroupCollapsible());
        ctl.put("groupdefaultcollapse", this.isGroupDefaultCollapse());
        if (this.isInvisible()) {
            ctl.put("vi", 0);
        } else {
            ctl.put("vi", this.getVisibleValue());
        }
        if (!DEFAULT.equals(this.getTextAlign())) {
            ctl.put("text-align", this.getTextAlign());
        }
        if (this.getCtlTips() != null) {
            ctl.put("tips", this.getCtlTips());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getTableHeaderCellBackColor())) {
            ctl.put("thcb", this.getTableHeaderCellBackColor());
        }
        return ctl;
    }

    @Override
    protected void createChildControls(Map<String, Object> ctl) {
    }

    private List<Object> createColumns(int orderAndFilter) {
        ArrayList<Object> cols = new ArrayList<Object>();
        for (ControlAp<?> item : this.getItems()) {
            if (item.getVisibleValue() == 0 || item.isHidden()) continue;
            if (item instanceof EntryFieldGroupAp) {
                EntryFieldGroupAp group = (EntryFieldGroupAp)item;
                cols.add(group.createControl(orderAndFilter));
                continue;
            }
            EntryFieldAp fldAp = (EntryFieldAp)item;
            List<Object> newCols = fldAp.createColumns();
            this.createOrderAndFilterColumn(newCols, orderAndFilter);
            cols.addAll(newCols);
        }
        return cols;
    }

    private void createOrderAndFilterColumn(List<Object> cols, int orderAndFilter) {
        if (cols == null || cols.isEmpty()) {
            return;
        }
        Map col = (Map)cols.get(0);
        col.put(FILTER, true);
        col.put(SORT, true);
        switch (orderAndFilter) {
            case 1: {
                col.put(FILTER, false);
                col.put(SORT, false);
                break;
            }
            case 2: {
                col.put(FILTER, false);
                break;
            }
            case 3: {
                col.put(SORT, false);
            }
        }
    }
}

