/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.form.control;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.container.Container;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.metadata.form.ContainerAp;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class OperationColumnAp
extends ContainerAp<OperationColumn> {
    private int operationColumnShowStyle;
    private List<OperationColItem> operationColItems = new ArrayList<OperationColItem>();

    @SimplePropertyAttribute
    public int getOperationColumnShowStyle() {
        return this.operationColumnShowStyle;
    }

    public void setOperationColumnShowStyle(int showStyle) {
        this.operationColumnShowStyle = showStyle;
    }

    @Override
    public Map<String, Object> createControl() {
        HashMap<String, Object> col = new HashMap<String, Object>();
        col.put("dataIndex", this.getKey());
        col.put("editor", this.createEditor());
        col.put("header", this.getName());
        if (this.isInvisible()) {
            col.put("vi", 0);
        } else {
            col.put("vi", this.getVisibleValue());
        }
        col.put("type", "operate");
        if (this.getWidth() != null) {
            col.put("w", this.getWidth());
        }
        if (!"default".equals(this.getTextAlign())) {
            col.put("text-align", this.getTextAlign());
        }
        if (this.getFontSize() != 12) {
            col.put("fs", this.getFontSize());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getForeColor())) {
            col.put("fc", this.getForeColor());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getBackColor())) {
            col.put("bc", this.getBackColor());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getTableHeaderCellBackColor())) {
            col.put("thcb", this.getTableHeaderCellBackColor());
        }
        return col;
    }

    private Map<String, Object> createEditor() {
        HashMap<String, Object> editor = new HashMap<String, Object>();
        editor.put("type", "operate");
        ArrayList<Map> items = new ArrayList<Map>();
        for (OperationColItem item : this.operationColItems) {
            Map ctl = item.createControl();
            items.add(ctl);
        }
        editor.put("opr", items);
        editor.put("showType", this.getOperationColumnShowStyle());
        return editor;
    }

    @Override
    protected OperationColumn createRuntimeControl() {
        return new OperationColumn();
    }

    @Override
    protected void setRuntimeSimpleProperties(Container ctl) {
        super.setRuntimeSimpleProperties(ctl);
        OperationColumn operationColumn = (OperationColumn)ctl;
        operationColumn.setOperationColItems(this.operationColItems);
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=OperationColItem.class)
    public List<OperationColItem> getOperationColItems() {
        return this.operationColItems;
    }

    public void setOperationColItems(List<OperationColItem> operationColItems) {
        this.operationColItems = operationColItems;
    }
}

