/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.form.control;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Rate;
import kd.bos.metadata.form.ControlAp;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class RateAp
extends ControlAp<Rate> {
    private String rateType = "normal";
    private BigDecimal totalScore = new BigDecimal("5");
    private int showTextType = 0;
    private int iconSize = 18;
    private int starsNum = 5;
    private int rateMode = 0;
    private boolean allowHalf;

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="normal")
    public String getRateType() {
        return this.rateType;
    }

    public void setRateType(String rateType) {
        this.rateType = rateType;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="5")
    public BigDecimal getTotalScore() {
        return this.totalScore;
    }

    public void setTotalScore(BigDecimal totalScore) {
        this.totalScore = totalScore;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="0")
    public int getShowTextType() {
        return this.showTextType;
    }

    public void setShowTextType(int showTextType) {
        this.showTextType = showTextType;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="18")
    public int getIconSize() {
        return this.iconSize;
    }

    public void setIconSize(int iconSize) {
        this.iconSize = iconSize;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="5")
    public int getStarsNum() {
        return this.starsNum;
    }

    public void setStarsNum(int starsNum) {
        this.starsNum = starsNum;
    }

    @SimplePropertyAttribute(name="AllowHalf")
    @DefaultValueAttribute(value="false")
    public boolean isAllowHalf() {
        return this.allowHalf;
    }

    public void setAllowHalf(boolean allowHalf) {
        this.allowHalf = allowHalf;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="0")
    public int getRateMode() {
        return this.rateMode;
    }

    public void setRateMode(int rateMode) {
        this.rateMode = rateMode;
    }

    @Override
    public Map<String, Object> createControl() {
        Map<String, Object> ctl = super.createControl();
        ctl.put("type", "rate");
        ctl.put("rateType", this.getRateType());
        if (this.getTotalScore().compareTo(BigDecimal.ZERO) <= 0) {
            throw new KDBizException(String.format(this.getTotalScoreErrorMessage(), this.getName(), this.getKey(), this.getTotalScore()));
        }
        ctl.put("totalScore", this.getTotalScore());
        ctl.put("showTextType", this.getShowTextType());
        ctl.put("iconSize", this.getIconSize());
        ctl.put("starsNum", this.getStarsNum());
        ctl.put("allowHalf", this.isAllowHalf());
        ctl.put("rateMode", this.getRateMode());
        return ctl;
    }

    @Override
    protected Rate createRuntimeControl() {
        return new Rate();
    }

    private String getTotalScoreErrorMessage() {
        return ResManager.loadKDString((String)"%1$s %2$s: \u603b\u5206\u5fc5\u987b\u5927\u4e8e0\uff0c\u5f53\u524d\u503c\u4e3a %3$s", (String)"RateAp_1", (String)"bos-metadata", (Object[])new Object[0]);
    }
}

