/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.form.control;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Slider;
import kd.bos.metadata.form.ControlAp;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class SliderAp
extends ControlAp<Slider> {
    private boolean range = false;
    private String dataScope = "[0, 100]";
    private BigDecimal stepValue = new BigDecimal("1");
    private String defValue = "[0, 0]";
    private boolean showCurrentValue = false;
    private boolean intervalDisplay = false;

    @SimplePropertyAttribute(name="IsRange")
    @DefaultValueAttribute(value="false")
    public boolean isRange() {
        return this.range;
    }

    public void setRange(boolean isRange) {
        this.range = isRange;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="[0, 100]")
    public String getDataScope() {
        return this.dataScope;
    }

    public void setDataScope(String dataScope) {
        this.dataScope = dataScope;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="1")
    public BigDecimal getStepValue() {
        return this.stepValue;
    }

    public void setStepValue(BigDecimal stepValue) {
        this.stepValue = stepValue;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="[0, 0]")
    public String getDefValue() {
        return this.defValue;
    }

    public void setDefValue(String defValue) {
        this.defValue = defValue;
    }

    @SimplePropertyAttribute(name="ShowCurrentValue")
    @DefaultValueAttribute(value="false")
    public boolean isShowCurrentValue() {
        return this.showCurrentValue;
    }

    public void setShowCurrentValue(boolean showCurrentValue) {
        this.showCurrentValue = showCurrentValue;
    }

    @SimplePropertyAttribute(name="IntervalDisplay")
    @DefaultValueAttribute(value="false")
    public boolean isIntervalDisplay() {
        return this.intervalDisplay;
    }

    public void setIntervalDisplay(boolean intervalDisplay) {
        this.intervalDisplay = intervalDisplay;
    }

    private BigDecimal[] getRangeValue(String dataScope, String defLeftValue, String defRightValue) {
        if (StringUtils.isBlank((String)dataScope)) {
            return new BigDecimal[]{new BigDecimal(defLeftValue), new BigDecimal(defRightValue)};
        }
        String clearBracketsDataScope = dataScope.replaceAll("[\\[\\]\\(\\)\\s]", "");
        String[] arr = clearBracketsDataScope.split(",");
        if (arr.length == 0) {
            return new BigDecimal[]{new BigDecimal(defLeftValue), new BigDecimal(defRightValue)};
        }
        if (arr.length == 1) {
            return new BigDecimal[]{new BigDecimal("0"), new BigDecimal(arr[0])};
        }
        if (StringUtils.isBlank((String)arr[0])) {
            arr[0] = defLeftValue;
        }
        if (StringUtils.isBlank((String)arr[1])) {
            arr[1] = defRightValue;
        }
        return new BigDecimal[]{new BigDecimal(arr[0]), new BigDecimal(arr[1])};
    }

    private RangeType getRangeType() {
        if (StringUtils.isBlank((String)this.dataScope)) {
            return RangeType.OPEN;
        }
        if (this.dataScope.startsWith("(") && this.dataScope.endsWith(")")) {
            return RangeType.CLOSE;
        }
        if (this.dataScope.startsWith("(") && this.dataScope.endsWith("]")) {
            return RangeType.RIGHT_OPEN;
        }
        if (this.dataScope.startsWith("[") && this.dataScope.endsWith(")")) {
            return RangeType.LEFT_OPEN;
        }
        return RangeType.OPEN;
    }

    @Override
    public Map<String, Object> createControl() {
        Map<String, Object> ctl = super.createControl();
        ctl.put("type", "slider");
        ctl.put("range", this.isRange());
        BigDecimal[] rangeValue = this.getRangeValue(this.getDataScope(), "0", "100");
        this.checkValid(rangeValue[0], rangeValue[1], this.getStepValue());
        ctl.put("min", rangeValue[0]);
        ctl.put("max", rangeValue[1]);
        ctl.put("step", this.getStepValue());
        String defStr = this.getDefValue();
        BigDecimal[] defVal = this.getRangeValue(defStr, "0", "0");
        RangeType rangeType = this.getRangeType();
        if (!defStr.equals("[0, 0]") && (rangeValue[0].compareTo(defVal[0]) > 0 && defVal[0].compareTo(BigDecimal.ZERO) > 0 || (rangeType == RangeType.OPEN || rangeType == RangeType.RIGHT_OPEN) && rangeValue[1].compareTo(defVal[1]) < 0 || (rangeType == RangeType.CLOSE || rangeType == RangeType.LEFT_OPEN) && rangeValue[1].compareTo(defVal[1]) <= 0)) {
            throw new KDBizException(String.format(this.getDefErrorMessage(), this.getName(), this.getKey(), this.getDataScope(), defStr));
        }
        ctl.put("defaultValue", defVal);
        ctl.put("showValue", this.isShowCurrentValue());
        if (this.isIntervalDisplay()) {
            ctl.put("intervalDisplay", this.isIntervalDisplay());
        }
        return ctl;
    }

    private void checkValid(BigDecimal leftValue, BigDecimal rightValue, BigDecimal step) {
        if (step.compareTo(BigDecimal.ZERO) <= 0) {
            throw new KDBizException(String.format(this.getStepErrorMessage(), this.getName(), this.getKey(), step));
        }
        BigDecimal result = leftValue.subtract(rightValue).divide(step, 10, 5);
        if (new BigDecimal(result.intValue()).compareTo(result) != 0) {
            throw new KDBizException(String.format(this.getDivisibleMessage(), this.getName(), this.getKey(), leftValue, rightValue, step));
        }
    }

    @Override
    protected Slider createRuntimeControl() {
        return new Slider();
    }

    private String getDivisibleMessage() {
        return ResManager.loadKDString((String)"%1$s %2$s: '(\u6700\u5927\u503c - \u6700\u5c0f\u503c) / \u6b65\u8fdb\u503c' \u7684\u7ed3\u679c\u5fc5\u987b\u4e3a\u6574\u6570\uff0c\u6700\u5927\u503c: %3$s\uff0c\u6700\u5c0f\u503c: %4$s\uff0c\u6b65\u8fdb\u503c: %5$s", (String)"SliderAp_3", (String)"bos-metadata", (Object[])new Object[0]);
    }

    private String getStepErrorMessage() {
        return ResManager.loadKDString((String)"%1$s %2$s: \u6b65\u8fdb\u503c\u5fc5\u987b\u5927\u4e8e0\uff0c\u5f53\u524d\u503c: %3$s", (String)"SliderAp_4", (String)"bos-metadata", (Object[])new Object[0]);
    }

    private String getDefErrorMessage() {
        return ResManager.loadKDString((String)"%1$s %2$s: \u7f3a\u7701\u503c\u5fc5\u987b\u5728'\u6570\u503c\u8303\u56f4:%3$s\u5185\uff0c\u5f53\u524d\u503c: %4$s\u3002", (String)"SliderAp_5", (String)"bos-metadata", (Object[])new Object[0]);
    }

    private static enum RangeType {
        CLOSE,
        LEFT_OPEN,
        RIGHT_OPEN,
        OPEN;

    }
}

