/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.form.control;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.form.control.Timeline;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.control.TimelineContentOption;
import kd.bos.metadata.form.control.TimelineLabelOption;
import kd.bos.metadata.form.control.TimelineOption;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class TimelineAp
extends ControlAp<Timeline> {
    private static final long serialVersionUID = -4231436393057911422L;
    private static final int DEFAULT_ARRAY_SIZE = 10;
    private String layoutType = "leftandright";
    private String axisPosition = "left";
    private List<TimelineOption> timelineOptions = new ArrayList<TimelineOption>(10);
    private int titleLine;
    private int descriptionLine;
    private int shrink = 0;

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="0")
    public int getTitleLine() {
        return this.titleLine;
    }

    public void setTitleLine(int titleLine) {
        this.titleLine = titleLine;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="leftandright")
    public String getLayoutType() {
        return this.layoutType;
    }

    public void setLayoutType(String layoutType) {
        this.layoutType = layoutType;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="left")
    public String getAxisPosition() {
        return this.axisPosition;
    }

    public void setAxisPosition(String axisPosition) {
        this.axisPosition = axisPosition;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=TimelineOption.class)
    public List<TimelineOption> getTimelineOptions() {
        return this.timelineOptions;
    }

    public void setTimelineOptions(List<TimelineOption> timelineOptions) {
        this.timelineOptions = timelineOptions;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="0")
    public int getDescriptionLine() {
        return this.descriptionLine;
    }

    public void setDescriptionLine(int descriptionLine) {
        this.descriptionLine = descriptionLine;
    }

    @Override
    @SimplePropertyAttribute
    public int getShrink() {
        return this.shrink;
    }

    @Override
    public void setShrink(int shrink) {
        this.shrink = shrink;
    }

    @Override
    public Map<String, Object> createControl() {
        Map<String, Object> ctl = super.createControl();
        ctl.put("type", "timeline");
        ctl.put("sk", this.shrink);
        ctl.put("axisPosition", this.axisPosition);
        ctl.put("timelineOptions", this.timelineOptions.stream().map(TimelineOption::toMap).collect(Collectors.toList()));
        ctl.put("titleLine", this.titleLine);
        ctl.put("descriptionLine", this.descriptionLine);
        ctl.put("layoutType", this.layoutType);
        return ctl;
    }

    @Override
    protected Timeline createRuntimeControl() {
        return new Timeline();
    }

    @Override
    protected void setRuntimeSimpleProperties(Timeline ctl) {
        ctl.setTimelineOptions(this.timelineOptions.stream().map(s -> {
            TimelineContentOption content = s.getContent();
            TimelineLabelOption label = s.getLabel();
            return new kd.bos.form.control.TimelineOption(new kd.bos.form.control.TimelineLabelOption(label.getTitle(), label.getDescription()), new kd.bos.form.control.TimelineContentOption(content.getTitle(), content.getDescription()));
        }).collect(Collectors.toList()));
        super.setRuntimeSimpleProperties(ctl);
    }
}

