/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.form.mcontrol.mobtable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.form.container.Container;
import kd.bos.form.mcontrol.mobtable.MobTable;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.orm.util.CollectionUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class MobTableAp
extends ContainerAp<MobTable> {
    private static final long serialVersionUID = 5332033872418004440L;
    private static final String ENTRY_TABLE = "entryTable";
    private String mobTableType = "entryTable";
    private Map<String, Object> mobTableDataSource;
    private boolean showSeq;
    private boolean verticalRoll;
    private boolean autoRowHeight;
    private String maxRowHeight;
    private List<Map<String, String>> freezeList;
    private boolean landscapeDisplay = true;

    @SimplePropertyAttribute(name="LandscapeDisplay")
    @DefaultValueAttribute(value="true")
    public boolean isLandscapeDisplay() {
        return this.landscapeDisplay;
    }

    public void setLandscapeDisplay(boolean landscapeDisplay) {
        this.landscapeDisplay = landscapeDisplay;
    }

    @SimplePropertyAttribute
    public List<Map<String, String>> getFreezeList() {
        return this.freezeList;
    }

    public void setFreezeList(List<Map<String, String>> freezeList) {
        this.freezeList = freezeList;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="entryTable")
    public String getMobTableType() {
        return this.mobTableType;
    }

    public void setMobTableType(String mobTableType) {
        this.mobTableType = mobTableType;
    }

    @SimplePropertyAttribute(name="ShowSeq")
    public boolean isShowSeq() {
        return this.showSeq;
    }

    public void setShowSeq(boolean showSeq) {
        this.showSeq = showSeq;
    }

    @SimplePropertyAttribute(name="VerticalRoll")
    public boolean isVerticalRoll() {
        return this.verticalRoll;
    }

    public void setVerticalRoll(boolean verticalRoll) {
        this.verticalRoll = verticalRoll;
    }

    @SimplePropertyAttribute(name="AutoRowHeight")
    public boolean isAutoRowHeight() {
        return this.autoRowHeight;
    }

    public void setAutoRowHeight(boolean autoRowHeight) {
        this.autoRowHeight = autoRowHeight;
    }

    @SimplePropertyAttribute
    public String getMaxRowHeight() {
        return this.maxRowHeight;
    }

    public void setMaxRowHeight(String maxRowHeight) {
        this.maxRowHeight = maxRowHeight;
    }

    @SimplePropertyAttribute
    public Map<String, Object> getMobTableDataSource() {
        return this.mobTableDataSource;
    }

    public void setMobTableDataSource(Map<String, Object> mobTableDataSource) {
        this.mobTableDataSource = mobTableDataSource;
    }

    @Override
    protected MobTable createRuntimeControl() {
        return new MobTable();
    }

    @Override
    public Map<String, Object> createControl() {
        Map<String, Object> ctl = super.createControl();
        ctl.put("type", "mobtable");
        ctl.put("seq", "fseq");
        ctl.put("vr", this.isVerticalRoll());
        ctl.put("arh", this.isAutoRowHeight());
        if (this.isAutoRowHeight()) {
            ctl.put("mrh", this.getMaxRowHeight());
        }
        ctl.put("lsd", this.isLandscapeDisplay());
        return ctl;
    }

    @Override
    protected void createChildControls(Map<String, Object> ctl) {
    }

    @Override
    protected void setRuntimeSimpleProperties(Container ctl) {
        super.setRuntimeSimpleProperties(ctl);
        MobTable mobTable = (MobTable)ctl;
        mobTable.setShowSeq(this.isShowSeq());
        mobTable.setMobTableDataSource(this.getMobTableDataSource());
        mobTable.setMobTableType(this.getMobTableType());
        mobTable.setFreezeList(this.handleFreezeList(this.getFreezeList()));
    }

    private List<Map<String, String>> handleFreezeList(List<Map<String, String>> freezeList) {
        ArrayList<Map<String, String>> newFreezeList = new ArrayList<Map<String, String>>(this.getItems().size());
        if (!CollectionUtils.isEmpty(freezeList)) {
            Map<String, Map> listMap = freezeList.stream().collect(Collectors.toMap(x -> (String)x.get("freezelistkey") + "_" + (String)x.get("listname"), v -> v, (k, v) -> v));
            for (ControlAp<?> item : this.getItems()) {
                Map<String, String> map = new HashMap<String, String>(1);
                String key = item.getKey() + "_" + item.getName().toString();
                if (listMap.containsKey(key)) {
                    map = listMap.get(key);
                } else {
                    map.put("freezelistkey", item.getKey());
                    map.put("listname", String.valueOf(item.getName()));
                    map.put("isfreeze", "false");
                }
                newFreezeList.add(map);
            }
        }
        return newFreezeList;
    }
}

