/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.form.rule;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.RaiseEventType;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.rule.FormRuleActionType;
import kd.bos.metadata.form.rule.FormRuleActionTypes;
import kd.bos.metadata.form.rule.ObjectMapper;
import kd.bos.utils.LocalMemroyCacheUtil;
import kd.bos.utils.LocaleBuildUtils;
import org.dom4j.Document;

public class FormRuleActionTypeCache {
    private static final Log LOG = LogFactory.getLog(FormRuleActionTypeCache.class);
    private static final String EXT_FORM_RULES_MAP = "extFormRulesMap";
    static Map<String, FormRuleActionTypes> formRuleActionTypesMap;
    static Map<String, Map<String, FormRuleActionType>> formRulesMap;
    private static final String SQL_FORMRULE = "select a.fid, a.fnumber, a.fformid, a.fisv, a.fclass, a.ftype, a.fload, a.fadd, a.ffieldchanged, a.fformrule, a.flist, a.freport, a.fcard, b.fname, b.fdesc from t_dm_rule a left join t_dm_rule_L b on B.FId=A.FId AND B.FLocaleId= ? where a.fenable = ?";

    private static synchronized FormRuleActionTypes getFormRules() throws IOException {
        String currentLang = Lang.get().toString();
        if (formRuleActionTypesMap == null) {
            formRuleActionTypesMap = new HashMap<String, FormRuleActionTypes>(16);
        }
        if (formRuleActionTypesMap.get(currentLang) == null) {
            FormRuleActionTypes formRules = FormRuleActionTypeCache.loadRuleAction(FormRuleActionTypes.class);
            formRuleActionTypesMap.put(currentLang, formRules);
        }
        return formRuleActionTypesMap.get(currentLang);
    }

    private static Map<String, FormRuleActionType> getFormDB(int maxSeq) {
        try {
            String lang = Lang.get().toString();
            SqlParameter langParam = new SqlParameter(12, (Object)lang);
            SqlParameter enable = new SqlParameter(1, (Object)"1");
            Object[] parameters = new SqlParameter[]{langParam, enable};
            return (Map)DB.query((DBRoute)DBRoute.meta, (String)SQL_FORMRULE, (Object[])parameters, rs -> {
                HashMap<String, FormRuleActionType> map = new HashMap<String, FormRuleActionType>(16);
                int seq = maxSeq;
                while (rs.next()) {
                    FormRuleActionType ruleActionType = new FormRuleActionType();
                    ruleActionType.setId(rs.getString("fnumber"));
                    String fname = rs.getString("fname");
                    if (StringUtils.isNotEmpty((CharSequence)fname)) {
                        fname = fname.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
                    }
                    ruleActionType.setName(fname);
                    String fdesc = rs.getString("fdesc");
                    if (StringUtils.isNotEmpty((CharSequence)fdesc)) {
                        fdesc = fdesc.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
                    }
                    ruleActionType.setDesc(fdesc);
                    ruleActionType.setFormid(rs.getString("fformid"));
                    ruleActionType.setMetaClass(rs.getString("fclass"));
                    ruleActionType.setMetaType(rs.getString("ftype"));
                    int serviceType = 0;
                    if (StringUtils.equals((CharSequence)rs.getString("fformrule"), (CharSequence)"1")) {
                        serviceType = 1;
                    }
                    if (StringUtils.equals((CharSequence)rs.getString("fcard"), (CharSequence)"1")) {
                        serviceType += 2;
                    }
                    if (StringUtils.equals((CharSequence)rs.getString("freport"), (CharSequence)"1")) {
                        serviceType += 4;
                    }
                    if (StringUtils.equals((CharSequence)rs.getString("flist"), (CharSequence)"1")) {
                        serviceType += 8;
                    }
                    ruleActionType.setServiceType(serviceType);
                    ruleActionType.setSeq(seq);
                    int type = 248;
                    int n = 0;
                    if (StringUtils.equals((CharSequence)rs.getString("fload"), (CharSequence)"1")) {
                        n |= RaiseEventType.Initialized.getValue();
                    }
                    if (StringUtils.equals((CharSequence)rs.getString("ffieldchanged"), (CharSequence)"1")) {
                        n |= RaiseEventType.FieldChanged.getValue();
                    }
                    if (StringUtils.equals((CharSequence)rs.getString("fadd"), (CharSequence)"1")) {
                        n |= RaiseEventType.ItemAdded.getValue();
                    }
                    ruleActionType.setRaiseEventType(type += n);
                    map.put(ruleActionType.getId(), ruleActionType);
                    ++seq;
                }
                return map;
            });
        }
        catch (Exception ex) {
            LOG.error("get formrule Form DB error :{}", (Throwable)ex);
            return new HashMap<String, FormRuleActionType>(1);
        }
    }

    public static void clearCache() {
        if (formRuleActionTypesMap != null) {
            formRuleActionTypesMap.clear();
        }
        if (formRulesMap != null) {
            formRulesMap.clear();
        }
        LocalMemroyCacheUtil.clear((String)EXT_FORM_RULES_MAP);
    }

    private static synchronized Map<String, FormRuleActionType> getFormRulesMap() throws IOException {
        String currentLang = Lang.get().toString();
        if (formRulesMap == null) {
            formRulesMap = new HashMap<String, Map<String, FormRuleActionType>>(16);
        }
        if (formRulesMap.get(currentLang) == null) {
            HashMap<String, FormRuleActionType> formRuleActionTypeMap = new HashMap<String, FormRuleActionType>(16);
            FormRuleActionTypes types = FormRuleActionTypeCache.getFormRules();
            for (FormRuleActionType type : types.getFormRuleActionTypes()) {
                formRuleActionTypeMap.put(type.getId(), type);
            }
            formRulesMap.put(currentLang, formRuleActionTypeMap);
        }
        return formRulesMap.get(currentLang);
    }

    public static FormRuleActionType geFormRuleActionType(String ruleId) {
        try {
            Map<String, FormRuleActionType> map = FormRuleActionTypeCache.getFormRulesMap();
            if (map.containsKey(ruleId)) {
                return map.get(ruleId);
            }
            Map<String, FormRuleActionType> dbMap = FormRuleActionTypeCache.getExtFormRuleActionTypeMap(map.size());
            if (dbMap.containsKey(ruleId)) {
                return dbMap.get(ruleId);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static Map<String, FormRuleActionType> getExtFormRuleActionTypeMap(int size) {
        Map<String, FormRuleActionType> dbMap = (Map<String, FormRuleActionType>)LocalMemroyCacheUtil.get((String)EXT_FORM_RULES_MAP);
        if (dbMap == null) {
            dbMap = FormRuleActionTypeCache.getFormDB(size);
            LocalMemroyCacheUtil.put((String)EXT_FORM_RULES_MAP, dbMap);
        }
        return dbMap;
    }

    public static List<FormRuleActionType> getAllFormRuleActionTypes() {
        ArrayList<FormRuleActionType> list = new ArrayList<FormRuleActionType>();
        try {
            FormRuleActionTypes types = FormRuleActionTypeCache.getFormRules();
            list.addAll(types.getFormRuleActionTypes());
            Map<String, FormRuleActionType> extFormRuleActionTypeMap = FormRuleActionTypeCache.getExtFormRuleActionTypeMap(list.size());
            list.addAll(extFormRuleActionTypeMap.values());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return list;
    }

    public static List<FormRuleActionType> getFormRuleActionTypesWithoutExt() {
        ArrayList<FormRuleActionType> list = new ArrayList<FormRuleActionType>();
        try {
            FormRuleActionTypes types = FormRuleActionTypeCache.getFormRules();
            list.addAll(types.getFormRuleActionTypes());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return list;
    }

    private static <T> T loadRuleAction(Class<T> serClass) {
        URL url = FormRuleActionTypes.class.getResource("/FormRuleActionTypes.xml");
        Object result = null;
        try {
            if (url == null) {
                return serClass.newInstance();
            }
            Document doc = LocaleBuildUtils.getSaxReader().read(url);
            LocaleBuildUtils.replaceLocaleVars((String)"FormRuleActionTypes.xml", (Document)doc, (String)Lang.get().toString());
            result = ObjectMapper.fromXML(doc.asXML(), serClass);
        }
        catch (Exception e) {
            try {
                result = serClass.newInstance();
            }
            catch (Exception exception) {
                result = null;
            }
        }
        return (T)result;
    }
}

