/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.form.rule;

public class OMScanner {
    private char[] _baseString;
    private int _index;

    public OMScanner(String string) {
        this._baseString = string.toCharArray();
        this._index = 0;
    }

    public String getScanString() {
        return new String(this._baseString);
    }

    public int getScanIndex() {
        return this._index;
    }

    public void setScanIndex(int index) {
        this._index = index;
    }

    public char readCharacter() {
        char character = this._baseString[this._index];
        ++this._index;
        return character;
    }

    public String readNextTagValue() {
        StringBuilder string = new StringBuilder();
        boolean done = false;
        int tempIndex = this._index;
        boolean saveChar = false;
        while (!done && tempIndex < this._baseString.length) {
            char readCharacter = this.readCharacter();
            if (readCharacter == '>') {
                saveChar = true;
                continue;
            }
            if (!saveChar) continue;
            if (readCharacter == '<') {
                this.skipToString(">");
                done = true;
                continue;
            }
            string.append(readCharacter);
        }
        return string.toString();
    }

    public char nextCharacter() {
        return this._baseString[this._index];
    }

    public String scanToChar(char c) {
        StringBuilder string = new StringBuilder();
        boolean done = false;
        while (!done) {
            char newChar = this.readCharacter();
            string.append(newChar);
            if (newChar != c) continue;
            done = true;
        }
        return string.toString();
    }

    public String scanToString(String string) {
        String returnString = "";
        String potentialMatchString = "";
        boolean done = false;
        while (!done) {
            char newChar = ' ';
            if (this._baseString.length <= this._index) {
                return returnString + potentialMatchString;
            }
            newChar = this.readCharacter();
            if (potentialMatchString.equals("")) {
                if (newChar == string.charAt(0)) {
                    if (string.length() == 1) {
                        done = true;
                        break;
                    }
                    potentialMatchString = potentialMatchString + newChar;
                    continue;
                }
            } else {
                if ((potentialMatchString + newChar).equals(string)) {
                    done = true;
                    break;
                }
                if ((potentialMatchString + newChar).equals(string.substring(0, (potentialMatchString + newChar).length()))) {
                    potentialMatchString = potentialMatchString + newChar;
                    continue;
                }
                returnString = returnString + potentialMatchString + newChar;
                potentialMatchString = "";
                continue;
            }
            returnString = returnString + newChar;
        }
        return returnString;
    }

    public void skipToString(String skipString) {
        StringBuilder string = new StringBuilder();
        boolean done = false;
        for (int tempIndex = this._index; !done && tempIndex < this._baseString.length; ++tempIndex) {
            string.append(this._baseString[tempIndex]);
            if (!string.toString().contains(skipString)) continue;
            this._index = tempIndex;
            done = true;
        }
    }

    public String nextXMLTag() {
        boolean done = false;
        StringBuilder string = new StringBuilder();
        boolean saveChar = false;
        for (int tempIndex = this._index; !done && tempIndex < this._baseString.length; ++tempIndex) {
            char c = this._baseString[tempIndex];
            if (c == '<') {
                saveChar = true;
                continue;
            }
            if (!saveChar) continue;
            if (this._baseString[tempIndex] == '>') {
                done = true;
                continue;
            }
            if (this._baseString[tempIndex] == ' ') {
                done = true;
                StringBuilder attributesString = new StringBuilder();
                while (this._baseString[tempIndex] != '>') {
                    attributesString.append(this._baseString[tempIndex]);
                    ++tempIndex;
                }
                if (!attributesString.toString().contains(" /")) continue;
                return string.append(" /").toString();
            }
            string.append(this._baseString[tempIndex]);
        }
        return string.toString();
    }

    public boolean hasNext() {
        return this._index < this._baseString.length;
    }

    public boolean startOfTag(String tag) {
        boolean done = false;
        StringBuilder string = new StringBuilder();
        boolean saveChar = false;
        for (int tempIndex = this._index; !done && tempIndex < this._baseString.length; ++tempIndex) {
            char c = this._baseString[tempIndex];
            if (c == '<') {
                saveChar = true;
                continue;
            }
            if (!saveChar) continue;
            if (this._baseString[tempIndex] == '>') {
                done = true;
                continue;
            }
            string.append(this._baseString[tempIndex]);
        }
        return string.toString().equals(tag);
    }

    public boolean endOfTag(String tag) {
        boolean done = false;
        StringBuilder string = new StringBuilder();
        boolean saveChar = false;
        for (int tempIndex = this._index; !done && tempIndex < this._baseString.length; ++tempIndex) {
            char c = this._baseString[tempIndex];
            if (c == '<') {
                saveChar = true;
                continue;
            }
            if (!saveChar) continue;
            if (this._baseString[tempIndex] == '>') {
                done = true;
                continue;
            }
            string.append(this._baseString[tempIndex]);
        }
        return string.toString().contains("/" + tag);
    }

    public void skipEmptyTag() {
        this.skipToString(" />");
    }
}

