/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.form.rule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.rule.DisplayStyle;
import kd.bos.metadata.form.rule.FieldId;
import kd.bos.metadata.form.rule.FormRuleAction;

public class SetFieldFmtAction
extends FormRuleAction {
    private List<DisplayStyle> displayStyles = new ArrayList<DisplayStyle>();
    private List<FieldId> fields = new ArrayList<FieldId>();

    @Override
    @CollectionPropertyAttribute(collectionItemPropertyType=FieldId.class)
    public List<FieldId> getFields() {
        return this.fields;
    }

    public void setFieldIds(List<FieldId> fieldIds) {
        this.fields = fieldIds;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=DisplayStyle.class)
    public List<DisplayStyle> getDisplayStyles() {
        return this.displayStyles;
    }

    public void setDisplayStyles(List<DisplayStyle> displayStyles) {
        this.displayStyles = displayStyles;
    }

    @Override
    public void buildClientAction(FormMetadata metaData, String ruleId, Map<String, Object> clientRuleActions) {
        HashMap<String, Object> action = new HashMap<String, Object>();
        ArrayList actionLists = new ArrayList();
        action.put("a", "setFieldsStyle");
        action.put("r", ruleId);
        HashMap actionList = new HashMap();
        HashMap<String, String> keyMap = new HashMap<String, String>();
        Map<Object, Object> styleMap = new HashMap();
        for (FieldId id : this.fields) {
            ControlAp<?> ap = metaData.getItem(id.getId());
            if (ap == null) continue;
            if (ap instanceof EntryFieldAp) {
                ControlAp<?> parentAp = this.getParentAp(metaData, ap.getParentId());
                String entryKey = parentAp.getKey();
                styleMap = this.createActionList();
                if (keyMap.isEmpty()) {
                    keyMap.put("key", entryKey);
                    actionList.putAll(keyMap);
                }
                actionList.putAll(styleMap);
                continue;
            }
            actionList.put("key", ap.getKey().toLowerCase());
        }
        actionLists.add(actionList);
        action.put("p", actionLists);
        clientRuleActions.put(this.getId(), action);
    }

    private Map<String, Object> createActionList() {
        HashMap<String, Object> actionList = new HashMap<String, Object>();
        ArrayList fieldsStyle = new ArrayList();
        for (DisplayStyle prop : this.displayStyles) {
            HashMap<String, Object> action = new HashMap<String, Object>();
            HashMap<String, Object> actionContent = new HashMap<String, Object>();
            if (prop.getForeColor() != null) {
                actionContent.put("fc", prop.getForeColor());
            }
            if (prop.getBackgroundColor() != null) {
                actionContent.put("bc", prop.getBackgroundColor());
            }
            actionContent.put("fs", prop.getFontSize());
            action.put("style", actionContent);
            action.put("fieldKey", prop.getId());
            fieldsStyle.add(action);
            actionList.put("fieldsStyle", fieldsStyle);
        }
        return actionList;
    }

    @Override
    public void resetItemId(Map<String, String> idMap) {
        for (FieldId id : this.fields) {
            if (!idMap.containsKey(id.getId())) continue;
            id.setId(idMap.get(id.getId()));
        }
    }
}

