/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.lang;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleValue;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.lang.STConverter;
import kd.bos.metadata.lang.LangItemBuilder;
import kd.bos.metadata.lang.LocaleItem;

public class LangWriter {
    private List<LocaleItem> localeItems;
    private Map<String, Map<String, Object>> langMaps;

    public LangWriter(DcBinder binder, Object entity, List<Map<String, Map<String, Object>>> langItems) {
        LangItemBuilder builder = new LangItemBuilder(binder);
        builder.builderResouces(entity, null);
        this.localeItems = builder.getLocaleItems();
        this.langMaps = new HashMap<String, Map<String, Object>>(langItems.size());
        for (Map<String, Map<String, Object>> item : langItems) {
            if (item.size() <= 0) continue;
            Map.Entry<String, Map<String, Object>> langItem = item.entrySet().iterator().next();
            this.langMaps.put(langItem.getKey(), langItem.getValue());
        }
    }

    public void setLoaceValue(List<String> langs) {
        this.setLocaleValue(langs, false);
    }

    public void setLocaleValue(List<String> langs, boolean ignoreNull) {
        for (LocaleItem item : this.localeItems) {
            Map<String, Object> langValue = this.langMaps.get(item.getId());
            if (langValue == null) continue;
            ILocaleValue value = (ILocaleValue)item.getProperty().getValue(item.getDataEntity());
            if (value == null) {
                value = new LocaleString();
                item.getProperty().setValue(item.getDataEntity(), (Object)value);
            }
            for (String lang : langs) {
                if (langValue.get(lang) == null && ignoreNull) continue;
                value.setItem(lang, (Object)((String)langValue.get(lang)));
            }
        }
    }

    public void setNullLoaceValue(String tlang, String slang) {
        this.setNullLoaceValue(tlang, slang, true);
    }

    public void setNullLoaceValue(String tlang, String slang, boolean ignoreHeightAndWidth) {
        for (LocaleItem item : this.localeItems) {
            String localeV;
            ILocaleValue value;
            if (ignoreHeightAndWidth && ("Height".equalsIgnoreCase(item.getProperty().getName()) || "Width".equalsIgnoreCase(item.getProperty().getName())) || "LabelWidth".equalsIgnoreCase(item.getProperty().getName()) || (value = (ILocaleValue)item.getProperty().getValue(item.getDataEntity())) == null || !StringUtils.isBlank((CharSequence)(localeV = (String)value.getItem(tlang))) || (localeV = (String)value.getItem(slang)) == null) continue;
            if ("zh_TW".equals(tlang) && "zh_CN".equals(slang)) {
                value.setItem(tlang, (Object)STConverter.sc2tc((String)localeV));
                continue;
            }
            value.setItem(tlang, (Object)localeV);
        }
    }
}

