/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.model.plugin;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.DesignMeta;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.entity.DesignEntityMeta;
import kd.bos.metadata.form.DesignFormMeta;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.model.plugin.IModelOperater;

public class AbstractModelOperater
implements IModelOperater {
    private static final String FORM_DESIGN_TABLE = "T_META_FORMDESIGN";
    private static final String ENTITY_DESIGN_TABLE = "T_META_ENTITYDESIGN";
    private static Log log = LogFactory.getLog(AbstractModelOperater.class);

    protected static DynamicObjectType getSubEntityType(String entityName, String selectProperties) {
        String[] properties = selectProperties.split(",");
        HashSet<String> select = new HashSet<String>(properties.length);
        for (String prop : properties) {
            select.add(prop.trim());
        }
        return EntityMetadataCache.getSubDataEntityType((String)entityName, select);
    }

    @Override
    public void init() {
        int split = 500;
        String[] formIds = this.getFormDesignIds();
        for (int i = 0; i < formIds.length; i += split) {
            int len = Math.min(i + split, formIds.length);
            String[] tempIds = Arrays.copyOfRange(formIds, i, len);
            List<AbstractMetadata> formMetas = this.getDesignFormMetaByIds(tempIds);
            for (AbstractMetadata formMeta : formMetas) {
                this.buildModel(formMeta);
            }
            formMetas = null;
        }
        String[] entityIds = this.getEntityDesignIds();
        for (int i = 0; i < entityIds.length; i += split) {
            int len = Math.min(i + split, entityIds.length);
            String[] tempIds = Arrays.copyOfRange(entityIds, i, len);
            List<AbstractMetadata> entityMetas = this.getDesignEntityMetaByIds(tempIds);
            for (AbstractMetadata entityMeta : entityMetas) {
                this.buildModel(entityMeta);
            }
            entityMetas = null;
        }
        this.saveModel();
    }

    protected void buildModel(AbstractMetadata metadata) {
    }

    protected void saveModel() {
    }

    protected void updateModel(String number) {
    }

    private List<AbstractMetadata> getDesignFormMetaByIds(String[] ids) {
        IDataEntityType deType = OrmUtils.getDataEntityType(DesignFormMeta.class);
        Object[] dms = BusinessDataReader.load((Object[])ids, (IDataEntityType)deType);
        ArrayList<AbstractMetadata> mts = new ArrayList<AbstractMetadata>();
        for (Object dm : dms) {
            DesignMeta dmt = (DesignMeta)dm;
            MetadataReader reader = new MetadataReader();
            try {
                AbstractMetadata mt = reader.design2Metadata(dmt, deType);
                if (mt == null) continue;
                mts.add(mt);
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
        dms = null;
        return mts;
    }

    private List<AbstractMetadata> getAllDesignFormMeta() {
        String[] ids = this.getFormDesignIds();
        return this.getDesignFormMetaByIds(ids);
    }

    private List<AbstractMetadata> getDesignEntityMetaByIds(String[] ids) {
        IDataEntityType deType = OrmUtils.getDataEntityType(DesignEntityMeta.class);
        Object[] dms = BusinessDataReader.load((Object[])ids, (IDataEntityType)deType);
        ArrayList<AbstractMetadata> mts = new ArrayList<AbstractMetadata>();
        for (Object dm : dms) {
            DesignMeta dmt = (DesignMeta)dm;
            MetadataReader reader = new MetadataReader();
            try {
                AbstractMetadata mt = reader.design2Metadata(dmt, deType);
                if (mt == null) continue;
                mts.add(mt);
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
        dms = null;
        return mts;
    }

    private List<AbstractMetadata> getAllDesignEntityMeta() {
        String[] ids = this.getEntityDesignIds();
        return this.getDesignEntityMetaByIds(ids);
    }

    private String[] getFormDesignIds() {
        return this.getIds(FORM_DESIGN_TABLE);
    }

    private String[] getEntityDesignIds() {
        return this.getIds(ENTITY_DESIGN_TABLE);
    }

    private String[] getIds(String tablename) {
        List ids = new ArrayList();
        String sql = "SELECT FID FROM " + tablename;
        try {
            ids = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, null, (ResultSetHandler)new ResultSetHandler<List<String>>(){

                public List<String> handle(ResultSet rs) throws SQLException {
                    ArrayList<String> ids = new ArrayList<String>(10);
                    while (rs.next()) {
                        String id = rs.getString(1);
                        ids.add(id);
                    }
                    return ids;
                }
            });
        }
        catch (Exception e) {
            String msg = String.format("error:%s;  sql:%s", e.getMessage(), sql);
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
        return ids.toArray(new String[0]);
    }

    @Override
    public void clear() {
    }

    @Override
    public void update(AbstractMetadata metadata1, AbstractMetadata metadata2) {
        this.buildModel(metadata1);
        this.buildModel(metadata2);
        String number = ((FormMetadata)metadata1).getKey();
        this.updateModel(number);
    }

    public static enum OBJECT_TYPE {
        DynamicFormModel,
        BillFormModel,
        BaseFormModel,
        MobileFormModel,
        MobileBillFormModel,
        ParameterFormModel_option,
        ParameterFormModel_public,
        ParameterFormModel_cloud,
        ParameterFormModel_listoption,
        ParameterFormModel_orgoption,
        ParameterFormModel_application,
        ParameterFormModel_billtype,
        WidgetFormModel,
        MobUserGuideFormModel,
        ReportFormModel,
        ReportQueryListModel,
        BalanceModel,
        PrintModel,
        QueryListModel;

    }

    public static enum REF_TYPE {
        FORM,
        OPERATER,
        OTHER;

    }

    public static enum PLUGIN_TYPE {
        FORM,
        LIST,
        OPERATER,
        OTHER;

    }
}

