/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.treebuilder;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SingleOrgContextHelper;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.metadata.treebuilder.BuildHelper;
import kd.bos.metadata.treebuilder.FilterFieldBuildOption;
import kd.bos.product.ICoreProductSettingService;
import kd.bos.service.ServiceFactory;

class FilterFieldBuilderImpl {
    private MainEntityType mainType;
    private FilterFieldBuildOption option;
    Set<String> selectedEntity = new HashSet<String>();
    private Set<String> disVisitFields = null;

    public FilterFieldBuilderImpl(MainEntityType mainType, FilterFieldBuildOption option) {
        this.mainType = mainType;
        this.option = option;
        this.initParameter();
    }

    private void initParameter() {
        this.initSelectedEntitys();
        this.option.addInvalidClassTypes(LinkEntryType.class);
    }

    private void initSelectedEntitys() {
        this.selectedEntity.addAll(this.option.getSelectedEntity());
        if (this.option.getSelectedEntity().isEmpty()) {
            for (Map.Entry entity : this.mainType.getAllEntities().entrySet()) {
                if (entity.getValue() instanceof LinkEntryType) continue;
                this.selectedEntity.add(((EntityType)entity.getValue()).getName());
            }
        }
    }

    public List<FilterField> buildFilterFields() {
        return this.buildFilterFields((EntityType)this.mainType);
    }

    public List<Map<String, Object>> buildFilterColumns() {
        List<FilterField> filterFields = this.buildFilterFields((EntityType)this.mainType);
        ArrayList<Map<String, Object>> filterColumns = new ArrayList<Map<String, Object>>(filterFields.size());
        for (FilterField filterField : filterFields) {
            Map filterColumn = filterField.createFilterColumn();
            filterColumns.add(filterColumn);
        }
        return filterColumns;
    }

    private List<FilterField> buildFilterFields(EntityType entityType) {
        ArrayList<FilterField> filterFields = new ArrayList<FilterField>(entityType.getProperties().size());
        ArrayList<EntityType> subEntityTypes = new ArrayList<EntityType>(4);
        for (IDataEntityProperty prop : entityType.getProperties()) {
            if (prop instanceof EntryProp) {
                DynamicObjectType subType = ((EntryProp)prop).getDynamicCollectionItemPropertyType();
                if (!(subType instanceof EntityType) || !this.selectedEntity.contains(prop.getName())) continue;
                subEntityTypes.add((EntityType)subType);
                continue;
            }
            filterFields.addAll(this.buildFilterField(prop));
        }
        for (EntityType subType : subEntityTypes) {
            filterFields.addAll(this.buildFilterFields(subType));
        }
        return filterFields;
    }

    private List<FilterField> buildFilterField(IDataEntityProperty prop) {
        if (!(prop instanceof IFieldHandle)) {
            return new ArrayList<FilterField>(0);
        }
        if (((IFieldHandle)prop).isSysField()) {
            return new ArrayList<FilterField>(0);
        }
        if (BuildHelper.isAssignableFrom(this.option.getInvalidClassTypes(), prop.getClass())) {
            return new ArrayList<FilterField>(0);
        }
        if (this.option.isCompatibleProductMode() && (this.isFormDisVisitField(prop) || SingleOrgContextHelper.isFieldNeedHide((IDataEntityProperty)prop))) {
            return new ArrayList<FilterField>(0);
        }
        List list = ((IFieldHandle)prop).createFilterFields(this.mainType);
        Iterator it = list.iterator();
        while (it.hasNext()) {
            FilterField ff = (FilterField)it.next();
            if (ff.isFieldPropAliasEmpty()) {
                it.remove();
                continue;
            }
            if (!this.option.isCompatibleProductMode()) continue;
            IDataEntityProperty ref1 = ff.getRefProp1();
            IDataEntityProperty ref2 = ff.getRefProp2();
            if (ref1 != null && SingleOrgContextHelper.isFieldNeedHide((IDataEntityProperty)ref1)) {
                it.remove();
                continue;
            }
            if (ref2 == null || !SingleOrgContextHelper.isFieldNeedHide((IDataEntityProperty)ref2)) continue;
            it.remove();
        }
        return list;
    }

    private boolean isFormDisVisitField(IDataEntityProperty prop) {
        if (this.disVisitFields == null) {
            ICoreProductSettingService pService;
            List list;
            this.disVisitFields = this.mainType == null ? new HashSet<String>(0) : ((list = (pService = (ICoreProductSettingService)ServiceFactory.getService(ICoreProductSettingService.class)).getFormDisVisitField(this.mainType.getName())) == null ? new HashSet<String>(0) : new HashSet<String>(list));
        }
        return this.disVisitFields.contains(prop.getName()) || SingleOrgContextHelper.isFieldNeedHide((IDataEntityProperty)prop);
    }
}

