/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.treebuilder;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.list.IListColumnAp;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.SubEntryEntity;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.IBillListAp;
import kd.bos.metadata.form.ICardRowPanelAp;
import kd.bos.metadata.form.IListGridViewAp;
import kd.bos.metadata.form.cardentry.CardEntryFieldAp;
import kd.bos.metadata.form.cardentry.CardEntryRowAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.metadata.treebuilder.BuildHelper;
import kd.bos.metadata.treebuilder.FormFieldTreeBuildOption;
import kd.bos.metadata.treebuilder.IFormTreeBuilder;

class FormFieldTreeBuilderImpl
implements IFormTreeBuilder {
    private FormMetadata formMetadata;
    private FormAp formAp;
    private EntityMetadata entityMetadata;
    private FormFieldTreeBuildOption option;
    private boolean includeHead = true;
    private Set<String> matchedEntitys = new HashSet<String>();

    private void initParameter() {
        if (StringUtils.isNotBlank((CharSequence)this.option.getCurrentEntityId())) {
            this.matchedEntitys.add(this.option.getCurrentEntityId());
            if (this.entityMetadata != null) {
                EntityItem<?> currItem = this.entityMetadata.getItemById(this.option.getCurrentEntityId());
                this.includeHead = this.option.isIncludeParentEntity();
                if (currItem != null) {
                    if (this.option.isIncludeParentEntity() && currItem instanceof SubEntryEntity) {
                        this.matchedEntitys.add(currItem.getParentId());
                    }
                    if (this.option.isIncludeChildEntity()) {
                        for (EntityItem entityItem : this.entityMetadata.getEntitys()) {
                            if (!StringUtils.equals((CharSequence)currItem.getId(), (CharSequence)entityItem.getParentId())) continue;
                            this.matchedEntitys.add(entityItem.getId());
                        }
                    }
                }
            }
        }
    }

    public FormFieldTreeBuilderImpl(FormMetadata formMetadata, EntityMetadata entityMetadata, FormFieldTreeBuildOption option) {
        this.formMetadata = formMetadata;
        this.formMetadata.createIndex();
        this.formAp = this.formMetadata.getRootAp();
        this.entityMetadata = entityMetadata;
        if (this.entityMetadata != null) {
            this.entityMetadata.createIndex();
        }
        this.option = option;
        if (this.option == null) {
            this.option = new FormFieldTreeBuildOption();
        }
        this.initParameter();
    }

    @Override
    public TreeNode build() {
        TreeNode root = this.buildRootNode();
        TreeNode headNode = this.buildHeadNode();
        ArrayList<TreeNode> entryNodes = new ArrayList<TreeNode>();
        for (ControlAp<?> controlAp : this.formMetadata.getItems()) {
            if (this.includeHead && controlAp instanceof FieldAp && !(controlAp instanceof EntryFieldAp) && !(controlAp instanceof CardEntryFieldAp)) {
                this.addItemNode(headNode, controlAp, null);
                continue;
            }
            if (this.option.isOnlyBillHead() || !(controlAp instanceof EntryAp) && !(controlAp instanceof IBillListAp) && !(controlAp instanceof IListGridViewAp) && !(controlAp instanceof CardEntryRowAp) && !(controlAp instanceof ICardRowPanelAp)) continue;
            TreeNode entryNode = this.buildEntryNode((ContainerAp)controlAp);
            entryNodes.add(entryNode);
        }
        if (headNode.getChildren() != null && !headNode.getChildren().isEmpty()) {
            root.addChild(headNode);
        }
        entryNodes.sort(new Comparator<TreeNode>(){

            @Override
            public int compare(TreeNode o1, TreeNode o2) {
                if (StringUtils.isBlank((Object)o1.getData())) {
                    return -1;
                }
                if (StringUtils.isBlank((Object)o2.getData())) {
                    return 1;
                }
                if (StringUtils.equals((CharSequence)o1.getData().toString(), (CharSequence)o2.getData().toString())) {
                    return 0;
                }
                if (StringUtils.equals((CharSequence)"1", (CharSequence)o1.getData().toString())) {
                    return -1;
                }
                return 1;
            }
        });
        for (TreeNode entryNode : entryNodes) {
            if (entryNode.getChildren() == null || entryNode.getChildren().isEmpty()) continue;
            entryNode.setParentid(root.getId());
            entryNode.setData(null);
            root.addChild(entryNode);
        }
        return root;
    }

    private TreeNode buildRootNode() {
        TreeNode root = new TreeNode();
        root.setParentid("");
        root.setId(this.formAp.getKey());
        root.setText(this.formAp.getName() == null ? this.formAp.getKey() : this.formAp.getName().toString());
        root.setLongText(root.getText());
        root.setIsOpened(true);
        return root;
    }

    private TreeNode buildHeadNode() {
        TreeNode headNode = new TreeNode();
        headNode.setParentid(this.formAp.getKey());
        headNode.setId("_headNode_");
        headNode.setText(ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"FormFieldTreeBuilderImpl_0", (String)"bos-metadata", (Object[])new Object[0]));
        headNode.setLongText(headNode.getText());
        headNode.setData((Object)this.formAp.getId());
        return headNode;
    }

    private TreeNode buildEntryNode(ContainerAp<?> entryAp) {
        boolean isCardRule;
        TreeNode entryNode = new TreeNode();
        EntityItem<?> entityItem = this.entityMetadata == null ? null : this.entityMetadata.getItemById(entryAp.getId());
        entryNode.setId(entryAp.getKey());
        if (entityItem instanceof SubEntryEntity) {
            entryNode.setText(entryAp.getName() == null ? String.format(ResManager.loadKDString((String)"%s(\u5b50\u5355\u636e\u4f53)", (String)"FormFieldTreeBuilderImpl_3", (String)"bos-metadata", (Object[])new Object[0]), entryAp.getKey()) : String.format(ResManager.loadKDString((String)"%s(\u5b50\u5355\u636e\u4f53)", (String)"FormFieldTreeBuilderImpl_3", (String)"bos-metadata", (Object[])new Object[0]), entryAp.getName().toString()));
            entryNode.setData((Object)"2");
        } else {
            entryNode.setText(entryAp.getName() == null ? String.format(ResManager.loadKDString((String)"%s(\u5355\u636e\u4f53)", (String)"FormFieldTreeBuilderImpl_4", (String)"bos-metadata", (Object[])new Object[0]), entryAp.getKey()) : String.format(ResManager.loadKDString((String)"%s(\u5355\u636e\u4f53)", (String)"FormFieldTreeBuilderImpl_4", (String)"bos-metadata", (Object[])new Object[0]), entryAp.getName().toString()));
            entryNode.setData((Object)"1");
        }
        String entityText = entryNode.getText();
        entryNode.setLongText(entryNode.getText());
        if (!this.canAddEntry(entryAp)) {
            return entryNode;
        }
        boolean bl = isCardRule = this.option.getCurrentEntityId() != null && (StringUtils.equals((CharSequence)this.option.getCurrentEntityId(), (CharSequence)entryAp.getId()) || StringUtils.equals((CharSequence)this.option.getCurrentEntityId(), (CharSequence)entryAp.getKey())) && entryAp instanceof CardEntryRowAp;
        if (!(entryAp instanceof EntryAp) && !isCardRule) {
            return entryNode;
        }
        for (ControlAp<?> item : entryAp.getItems()) {
            if (item instanceof FieldAp || item instanceof IListColumnAp) {
                this.addItemNode(entryNode, item, entityText);
                continue;
            }
            if (!(item instanceof ContainerAp)) continue;
            this.addContainer(entryNode, (ContainerAp)item, entityText);
        }
        return entryNode;
    }

    private void addContainer(TreeNode parentNode, ContainerAp<?> containerAp, String parentText) {
        for (ControlAp<?> item : containerAp.getItems()) {
            if (item instanceof IListColumnAp || item instanceof FieldAp) {
                this.addItemNode(parentNode, item, parentText);
                continue;
            }
            if (!(item instanceof ContainerAp)) continue;
            this.addContainer(parentNode, (ContainerAp)item, parentText);
        }
    }

    private void addItemNode(TreeNode parentNode, ControlAp<?> item, String parentText) {
        if (!this.canAddField(item)) {
            return;
        }
        TreeNode fieldNode = new TreeNode();
        fieldNode.setParentid(parentNode.getId());
        String fieldId = "";
        if (item instanceof IListColumnAp && StringUtils.isNotBlank((CharSequence)((IListColumnAp)item).getListFieldId())) {
            fieldId = ((IListColumnAp)item).getListFieldId();
        } else {
            fieldId = item.getKey();
            if (parentNode.getId().equalsIgnoreCase("_headNode_")) {
                String parentId = (String)parentNode.getData();
                Field<?> field = this.entityMetadata.getFieldByKey(fieldId);
                if (field != null && StringUtils.isNotBlank((CharSequence)field.getParentId()) && !field.getParentId().equalsIgnoreCase(parentId) && !field.getParentId().equalsIgnoreCase(this.entityMetadata.getRootEntity().getId())) {
                    return;
                }
            }
        }
        fieldNode.setId(fieldId);
        fieldNode.setData((Object)item.getId());
        fieldNode.setType(item.getClass().getSimpleName());
        fieldNode.setText(item.getName() == null ? fieldId : item.getName().toString() + "(" + fieldId + ")");
        String longText = fieldNode.getText();
        if (StringUtils.isNotBlank((CharSequence)parentText)) {
            longText = parentText + "." + longText;
        }
        fieldNode.setLongText(longText);
        parentNode.addChild(fieldNode);
    }

    private boolean canAddField(ControlAp<?> item) {
        if (BuildHelper.isAssignableFrom(this.option.getInvalidClassTypes(), item.getClass())) {
            return false;
        }
        return this.option.getMatchedClassTypes().isEmpty() || BuildHelper.isAssignableFrom(this.option.getMatchedClassTypes(), item.getClass());
    }

    private boolean canAddEntry(ContainerAp<?> entryAp) {
        if (!this.matchedEntitys.isEmpty()) {
            return this.matchedEntitys.contains(entryAp.getId()) || this.matchedEntitys.contains(entryAp.getKey());
        }
        return true;
    }
}

