/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.treebuilder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.metadata.treebuilder.BuildHelper;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;

class PropTreeBuildHelper
extends BuildHelper {
    PropTreeBuildHelper() {
    }

    public static boolean canAddEntry(EntityType entityType, Collection<Class<?>> invalidClsSet, Set<String> selectedEntity) {
        return !PropTreeBuildHelper.isAssignableFrom(invalidClsSet, entityType.getClass()) && selectedEntity.contains(entityType.getName());
    }

    public static boolean canAddProperty(IDataEntityProperty property, PropTreeBuildOption option) {
        if (PropTreeBuildHelper.isAssignableFrom(option.getInvalidClassTypes(), property.getClass())) {
            return false;
        }
        if (option.getMatchedClassTypes() != null && !option.getMatchedClassTypes().isEmpty() && !PropTreeBuildHelper.isAssignableFrom(option.getMatchedClassTypes(), property.getClass())) {
            return false;
        }
        if (option.getMatchedProperty() != null) {
            if (option.getMatchedProperty() instanceof ItemClassProp) {
                if (((BasedataProp)option.getMatchedProperty()).isFromSampleMaster(property)) {
                    return true;
                }
                Set<String> matchEntityNumbers = option.getMatchedItemClassTypes();
                Set<String> currEntityNumbers = null;
                currEntityNumbers = property instanceof ItemClassProp ? option.parseItemClassRefMasterEntity((ItemClassProp)property) : (property instanceof BasedataProp ? option.parseBDRefMasterEntity((BasedataProp)property) : new HashSet<String>(0));
                for (String entityNumber : currEntityNumbers) {
                    if (!matchEntityNumbers.contains(entityNumber)) continue;
                    return true;
                }
                return false;
            }
            if (option.getMatchedProperty() instanceof BasedataProp ? !((BasedataProp)option.getMatchedProperty()).isFromSampleMaster(property) : !option.getMatchedProperty().getClass().isInstance(property)) {
                return false;
            }
        }
        return true;
    }

    public static TreeNode buildPropNode(IDataEntityProperty property, TreeNode parentNode, String keyPrefix, String capPrefix, boolean isDynamicText) {
        TreeNode fldNode = new TreeNode();
        DynamicProperty prop = (DynamicProperty)property;
        if (prop != null) {
            String fldNodeName;
            String fullPropName;
            String fldNodeId = fullPropName = StringUtils.isBlank((CharSequence)keyPrefix) ? prop.getName() : keyPrefix + "." + prop.getName();
            if (isDynamicText) {
                fldNodeId = "{" + fullPropName + "}";
            }
            String string = fldNodeName = prop.getDisplayName() == null ? prop.getName() : prop.getDisplayName().toString();
            if (StringUtils.isNotBlank((CharSequence)capPrefix)) {
                fldNodeName = capPrefix + "." + fldNodeName;
            }
            fldNode = new TreeNode(parentNode.getId(), fldNodeId, fldNodeName);
            fldNode.setIsOpened(false);
        }
        return fldNode;
    }

    public static List<TreeNode> buildRefBaseDataTypeNodes(MainEntityType refBDType, TreeNode bdFieldNode, String keyPrefix, String capPrefix, PropTreeBuildOption option) {
        if (refBDType == null) {
            return new ArrayList<TreeNode>(0);
        }
        ArrayList<TreeNode> refNodes = new ArrayList<TreeNode>();
        for (IDataEntityProperty refProp : refBDType.getFields().values()) {
            if (refProp instanceof MulBasedataProp) {
                refNodes.addAll(PropTreeBuildHelper.buildRefMuliBaseProp2Node((MulBasedataProp)refProp, bdFieldNode, keyPrefix, capPrefix, option));
            }
            if (refProp instanceof ICollectionProperty) continue;
            if (refProp instanceof BasedataProp) {
                refNodes.addAll(PropTreeBuildHelper.buildRefBaseProp2Node((BasedataProp)refProp, bdFieldNode, keyPrefix, capPrefix, option));
                continue;
            }
            if (!PropTreeBuildHelper.canAddProperty(refProp, option)) continue;
            refNodes.add(PropTreeBuildHelper.buildPropNode(refProp, bdFieldNode, keyPrefix, capPrefix, option.isDynamicText()));
        }
        return refNodes;
    }

    private static List<TreeNode> buildRefBaseProp2Node(BasedataProp refBDProp, TreeNode bdFieldNode, String keyPrefix, String capPrefix, PropTreeBuildOption option) {
        String capPrefix2;
        MainEntityType bdType2;
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        boolean matched = PropTreeBuildHelper.canAddProperty((IDataEntityProperty)refBDProp, option);
        TreeNode refPropNode = PropTreeBuildHelper.buildPropNode((IDataEntityProperty)refBDProp, bdFieldNode, keyPrefix, capPrefix, option.isDynamicText());
        if (matched) {
            nodes.add(refPropNode);
        }
        if ((bdType2 = (MainEntityType)refBDProp.getComplexType()) == null) {
            return nodes;
        }
        String keyPrefix2 = keyPrefix + "." + refBDProp.getName();
        List<TreeNode> refNodes2 = PropTreeBuildHelper.buildRefBaseDataTypeNodes(bdType2, refPropNode, keyPrefix2, capPrefix2 = capPrefix + "." + (refBDProp.getDisplayName() == null ? refBDProp.getName() : refBDProp.getDisplayName().toString()), option);
        if (refNodes2.size() > 0) {
            if (!matched) {
                nodes.add(refPropNode);
            } else if (option.isIncludeBDPropPK()) {
                TreeNode idNode = PropTreeBuildHelper.buildPropNode((IDataEntityProperty)bdType2.getPrimaryKey(), refPropNode, keyPrefix2, capPrefix2, option.isDynamicText());
                idNode.setText(String.format(ResManager.loadKDString((String)"%1$s.\u5185\u7801(%2$s)", (String)"PropTreeBuildHelper_2", (String)"bos-metadata", (Object[])new Object[0]), capPrefix2, idNode.getId()));
                refPropNode.addChild(idNode);
            }
            refPropNode.addChildren(refNodes2);
        }
        return nodes;
    }

    private static List<TreeNode> buildRefMuliBaseProp2Node(MulBasedataProp refMuliBDProp, TreeNode bdFieldNode, String keyPrefix, String capPrefix, PropTreeBuildOption option) {
        String capPrefix2;
        String keyPrefix2;
        BasedataProp refBDProp;
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        boolean matched = PropTreeBuildHelper.canAddProperty((IDataEntityProperty)refMuliBDProp, option);
        TreeNode refPropNode = PropTreeBuildHelper.buildPropNode((IDataEntityProperty)refMuliBDProp, bdFieldNode, keyPrefix, capPrefix, option.isDynamicText());
        if (matched) {
            nodes.add(refPropNode);
        }
        if ((refBDProp = (BasedataProp)refMuliBDProp.getRefBaseProp()) == null || refBDProp.getComplexType() == null) {
            return nodes;
        }
        MainEntityType bdType2 = (MainEntityType)refBDProp.getComplexType();
        List<TreeNode> refNodes2 = PropTreeBuildHelper.buildRefBaseDataTypeNodes(bdType2, refPropNode, keyPrefix2 = keyPrefix + "." + refMuliBDProp.getName(), capPrefix2 = capPrefix + "." + (refMuliBDProp.getDisplayName() == null ? refMuliBDProp.getName() : refMuliBDProp.getDisplayName().toString()), option);
        if (refNodes2.size() > 0) {
            if (!matched) {
                nodes.add(refPropNode);
            } else if (option.isIncludeBDPropPK()) {
                TreeNode idNode = PropTreeBuildHelper.buildPropNode((IDataEntityProperty)bdType2.getPrimaryKey(), refPropNode, keyPrefix2, capPrefix2, option.isDynamicText());
                idNode.setText(String.format(ResManager.loadKDString((String)"%1$s.\u5185\u7801(%2$s)", (String)"PropTreeBuildHelper_2", (String)"bos-metadata", (Object[])new Object[0]), capPrefix2, idNode.getId()));
                refPropNode.addChild(idNode);
            }
            refPropNode.addChildren(refNodes2);
        }
        return nodes;
    }

    public static List<TreeNode> buildPKFieldNode(EntityType entityType, TreeNode entityNode, PropTreeBuildOption option) {
        DynamicProperty seqProp;
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        if (entityType.getPrimaryKey() != null && PropTreeBuildHelper.canAddProperty((IDataEntityProperty)entityType.getPrimaryKey(), option)) {
            String prefix = entityType instanceof MainEntityType ? "" : entityNode.getId();
            TreeNode idNode = PropTreeBuildHelper.buildPropNode((IDataEntityProperty)entityType.getPrimaryKey(), entityNode, prefix, "", option.isDynamicText());
            idNode.setText(String.format(ResManager.loadKDString((String)"%1$s.\u5185\u7801(%2$s)", (String)"PropTreeBuildHelper_2", (String)"bos-metadata", (Object[])new Object[0]), entityNode.getText(), idNode.getId()));
            nodes.add(idNode);
        }
        if (entityType instanceof EntryType && (seqProp = entityType.getProperty("seq")) != null && PropTreeBuildHelper.canAddProperty((IDataEntityProperty)seqProp, option)) {
            TreeNode seqNode = PropTreeBuildHelper.buildPropNode((IDataEntityProperty)seqProp, entityNode, entityNode.getId(), "", option.isDynamicText());
            seqNode.setText(String.format(ResManager.loadKDString((String)"%s.\u5e8f\u53f7", (String)"PropTreeBuildHelper_3", (String)"bos-metadata", (Object[])new Object[0]), entityNode.getText()));
            nodes.add(seqNode);
        }
        return nodes;
    }
}

