/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.treebuilder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MasterBasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.metadata.treebuilder.IFormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildHelper;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;

class PropTreeBuilderImpl
implements IFormTreeBuilder {
    private MainEntityType mainType;
    private PropTreeBuildOption option;
    Set<String> selectedEntity = new HashSet<String>();

    private void initParameter() {
        this.initSelectedEntitys();
        this.option.addInvalidClassTypes(LinkEntryType.class);
    }

    private void initSelectedEntitys() {
        this.selectedEntity.addAll(this.option.getSelectedEntity());
        if (StringUtils.isBlank((CharSequence)this.option.getCurrentEntity())) {
            this.selectedEntity.addAll(this.mainType.getAllEntities().keySet());
        } else {
            EntityType entityType = (EntityType)this.mainType.getAllEntities().get(this.option.getCurrentEntity());
            if (entityType != null) {
                this.selectedEntity.add(this.option.getCurrentEntity());
                if (this.option.isIncludeParentEntity()) {
                    for (IDataEntityType parentType = entityType.getParent(); parentType != null; parentType = parentType.getParent()) {
                        this.selectedEntity.add(parentType.getName());
                    }
                }
                if (this.option.isIncludeChildEntity()) {
                    if (entityType instanceof MainEntityType) {
                        this.selectedEntity.addAll(this.mainType.getAllEntities().keySet());
                    } else {
                        for (EntityType entityType2 : this.mainType.getAllEntities().values()) {
                            if (entityType2.getParent() == null || !StringUtils.equals((CharSequence)entityType2.getParent().getName(), (CharSequence)entityType.getName())) continue;
                            this.selectedEntity.add(entityType2.getName());
                        }
                    }
                }
            }
        }
    }

    public PropTreeBuilderImpl(MainEntityType mainType, PropTreeBuildOption option) {
        this.mainType = mainType;
        this.option = option;
        if (this.option == null) {
            this.option = new PropTreeBuildOption();
        }
        this.initParameter();
    }

    @Override
    public TreeNode build() {
        TreeNode root = new TreeNode("", this.mainType.getName(), this.mainType.getDisplayName().toString());
        root.setIsOpened(true);
        List<TreeNode> fldNodes = this.buildFldTreeNodes();
        HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>(16);
        for (TreeNode node : fldNodes) {
            nodeMap.put(node.getId(), node);
        }
        for (TreeNode node : fldNodes) {
            TreeNode parentNode = (TreeNode)nodeMap.get(node.getParentid());
            if (parentNode == null) {
                node.setParentid(root.getId());
                root.addChild(node);
                continue;
            }
            parentNode.addChild(node);
        }
        return root;
    }

    private List<TreeNode> buildFldTreeNodes() {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        for (Map.Entry entry : this.mainType.getAllEntities().entrySet()) {
            EntityType entityType = (EntityType)entry.getValue();
            if (!PropTreeBuildHelper.canAddEntry(entityType, this.option.getInvalidClassTypes(), this.selectedEntity)) continue;
            TreeNode entityNode = this.buildEntityNode(entityType);
            ArrayList<TreeNode> entityFldNodes = new ArrayList<TreeNode>();
            if (this.option.isIncludePKField()) {
                entityFldNodes.addAll(PropTreeBuildHelper.buildPKFieldNode(entityType, entityNode, this.option));
            }
            String bdKeyPrefix = this.option.isIncludeEntryEntityAsKeyPrefix() && entityType instanceof EntryType ? entityType.getName() : "";
            for (IDataEntityProperty property : entityType.getFields().values()) {
                if (property instanceof ICollectionProperty) {
                    if (!(property instanceof MulBasedataProp)) continue;
                    entityFldNodes.addAll(this.buildMuliBDFieldNode((MulBasedataProp)property, entityNode, bdKeyPrefix));
                    continue;
                }
                if (property instanceof IComplexProperty) {
                    if (!(property instanceof BasedataProp)) continue;
                    entityFldNodes.addAll(this.buildBDFieldNode((BasedataProp)property, entityNode, bdKeyPrefix));
                    continue;
                }
                if (!(property instanceof ISimpleProperty)) continue;
                entityFldNodes.addAll(this.buildFieldNode((ISimpleProperty)property, entityNode, bdKeyPrefix));
            }
            if (entityFldNodes.size() <= 0) continue;
            nodes.add(entityNode);
            nodes.addAll(entityFldNodes);
        }
        return nodes;
    }

    private TreeNode buildEntityNode(EntityType entityType) {
        String entityNodeId = entityType.getName();
        String entityNodeName = "";
        if (entityType instanceof MainEntityType) {
            entityNodeName = ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"PropTreeBuilderImpl_0", (String)"bos-metadata", (Object[])new Object[0]);
            entityNodeId = "billhead";
        } else if (entityType.getDisplayName() != null) {
            entityNodeName = entityType.getDisplayName().toString();
        }
        TreeNode entityNode = new TreeNode(this.mainType.getName(), entityNodeId, entityNodeName);
        entityNode.setIsOpened(true);
        return entityNode;
    }

    private List<TreeNode> buildFieldNode(ISimpleProperty property, TreeNode entityNode, String keyPrefix) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        if (this.option.isOnlyPhysicsField() && StringUtils.isBlank((CharSequence)property.getAlias())) {
            return nodes;
        }
        if ("id".equalsIgnoreCase(property.getName()) || "seq".equalsIgnoreCase(property.getName())) {
            return nodes;
        }
        if (PropTreeBuildHelper.canAddProperty((IDataEntityProperty)property, this.option)) {
            TreeNode node = PropTreeBuildHelper.buildPropNode((IDataEntityProperty)property, entityNode, keyPrefix, "", this.option.isDynamicText());
            if (this.option.isTestIncludeFiledNumber()) {
                node.setText(node.getText() + "(" + node.getId() + ")");
            }
            nodes.add(node);
        }
        return nodes;
    }

    private List<TreeNode> buildMuliBDFieldNode(MulBasedataProp muliBDProp, TreeNode entityNode, String keyPrefix) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        boolean matched = PropTreeBuildHelper.canAddProperty((IDataEntityProperty)muliBDProp, this.option);
        TreeNode fldNode = PropTreeBuildHelper.buildPropNode((IDataEntityProperty)muliBDProp, entityNode, keyPrefix, "", this.option.isDynamicText());
        if (muliBDProp.getRefBaseProp() == null || muliBDProp.getRefBaseProp().getComplexType() == null) {
            return nodes;
        }
        if (this.option.isIncludeBDRefProp()) {
            MainEntityType bdType = (MainEntityType)muliBDProp.getRefBaseProp().getComplexType();
            BasedataEntityType refMulType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)muliBDProp.getBaseEntityId());
            String refKeyPrefix = StringUtils.isBlank((CharSequence)keyPrefix) ? muliBDProp.getName() : keyPrefix + "." + muliBDProp.getName();
            List<TreeNode> refNodes = PropTreeBuildHelper.buildRefBaseDataTypeNodes(bdType, fldNode, refKeyPrefix, muliBDProp.getDisplayName().toString(), this.option);
            if (refNodes.size() > 0) {
                if (matched && this.option.isIncludeBDPropPK()) {
                    TreeNode idNode = PropTreeBuildHelper.buildPropNode((IDataEntityProperty)bdType.getPrimaryKey(), fldNode, refKeyPrefix, muliBDProp.getDisplayName().toString(), this.option.isDynamicText());
                    idNode.setText(String.format(ResManager.loadKDString((String)"%1$s.\u5185\u7801(%2$s)", (String)"PropTreeBuilderImpl_2", (String)"bos-metadata", (Object[])new Object[0]), fldNode.getText(), idNode.getId()));
                    refNodes.add(idNode);
                }
                if (this.option.isSpecialTreatmentMulBDProp()) {
                    Iterator<TreeNode> refPropNodeItertor = refNodes.iterator();
                    while (refPropNodeItertor.hasNext()) {
                        int length;
                        TreeNode refPropNode = refPropNodeItertor.next();
                        String[] ids = refPropNode.getId().split("\\.");
                        if (ids[(length = ids.length) - 1].equals(refMulType.getNameProperty()) || ids[length - 1].equals(refMulType.getNumberProperty())) continue;
                        refPropNodeItertor.remove();
                    }
                }
                fldNode.addChildren(refNodes);
            }
        }
        if (this.option.isTestIncludeFiledNumber()) {
            fldNode.setText(fldNode.getText() + "(" + fldNode.getId() + ")");
        }
        if (matched || fldNode.getChildren() != null && !fldNode.getChildren().isEmpty()) {
            nodes.add(fldNode);
        }
        return nodes;
    }

    private List<TreeNode> buildBDFieldNode(BasedataProp bdProp, TreeNode entityNode, String keyPrefix) {
        String refKeyPrefix;
        List<TreeNode> refNodes;
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        boolean matched = PropTreeBuildHelper.canAddProperty((IDataEntityProperty)bdProp, this.option);
        TreeNode fldNode = PropTreeBuildHelper.buildPropNode((IDataEntityProperty)bdProp, entityNode, keyPrefix, "", this.option.isDynamicText());
        MainEntityType bdType = bdProp instanceof MasterBasedataProp && this.option.isIncludeAllMasterProps() ? this.getMasterIdEntityType(bdProp.getBaseEntityId()) : (MainEntityType)bdProp.getComplexType();
        if (this.option.isIncludeBDRefProp() && (refNodes = PropTreeBuildHelper.buildRefBaseDataTypeNodes(bdType, fldNode, refKeyPrefix = StringUtils.isBlank((CharSequence)keyPrefix) ? bdProp.getName() : keyPrefix + "." + bdProp.getName(), bdProp.getDisplayName().toString(), this.option)).size() > 0) {
            if (matched && this.option.isIncludeBDPropPK()) {
                TreeNode idNode = PropTreeBuildHelper.buildPropNode((IDataEntityProperty)bdType.getPrimaryKey(), fldNode, refKeyPrefix, bdProp.getDisplayName().toString(), this.option.isDynamicText());
                idNode.setText(String.format(ResManager.loadKDString((String)"%1$s.\u5185\u7801(%2$s)", (String)"PropTreeBuilderImpl_2", (String)"bos-metadata", (Object[])new Object[0]), fldNode.getText(), idNode.getId()));
                fldNode.addChild(idNode);
            }
            fldNode.addChildren(refNodes);
        }
        if (this.option.isTestIncludeFiledNumber()) {
            fldNode.setText(fldNode.getText() + "(" + fldNode.getId() + ")");
        }
        if (matched || fldNode.getChildren() != null && !fldNode.getChildren().isEmpty()) {
            nodes.add(fldNode);
        }
        return nodes;
    }

    private MainEntityType getMasterIdEntityType(String number) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)number);
        for (IDataEntityProperty refProp : dataEntityType.getFields().values()) {
            BasedataProp basedataProp;
            MainEntityType complexType;
            if (refProp instanceof MulBasedataProp) {
                IComplexProperty refBaseProp = ((MulBasedataProp)refProp).getRefBaseProp();
                if (!(refBaseProp instanceof BasedataProp) || refBaseProp.getComplexType() == null) continue;
                complexType = (MainEntityType)refBaseProp.getComplexType();
                ((BasedataProp)refBaseProp).setComplexType((IDataEntityType)complexType.getSubEntityType(new ArrayList(0)));
                continue;
            }
            if (!(refProp instanceof BasedataProp) || (basedataProp = (BasedataProp)refProp).getComplexType() == null) continue;
            complexType = (MainEntityType)basedataProp.getComplexType();
            basedataProp.setComplexType((IDataEntityType)complexType.getSubEntityType(new ArrayList(0)));
        }
        return dataEntityType;
    }
}

