/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.treebuilder;

import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;

public class SingleFieldTreePlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
SearchEnterListener {
    private static final Log LOG = LogFactory.getLog(SingleFieldTreePlugin.class);
    private static final String CACHE_KEY_NODES = "treenodes";
    private static final String CACHEKEY_SELECTED_NODEIDS = "selectednodeids";
    private static final String KEY_BTN_OK = "btnok";
    private static final String KEY_BTN_CANCEL = "btncancel";
    private static final String KEY_TREEVIEW = "tv_fields";
    private static final String KEY_SEARCH_FIELD = "searchfield";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{KEY_BTN_OK, KEY_BTN_CANCEL});
        TreeView tv = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getView().getControl(KEY_SEARCH_FIELD);
        if (search != null) {
            search.addEnterListener((SearchEnterListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String json = this.getNodeFromParent();
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entitynumber");
        if (StringUtils.isNotBlank((CharSequence)json)) {
            this.fillTreeNodes(json);
        } else if (StringUtils.isNotBlank((CharSequence)entityNumber)) {
            this.buildTreeRootNode(entityNumber);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if (KEY_BTN_OK.equalsIgnoreCase(ctlSource.getKey())) {
            String currNodeId = this.getPageCache().get(CACHEKEY_SELECTED_NODEIDS);
            if (StringUtils.isNotBlank((CharSequence)currNodeId)) {
                this.getView().returnDataToParent((Object)currNodeId);
            }
            this.getView().close();
        } else if (KEY_BTN_CANCEL.equalsIgnoreCase(ctlSource.getKey())) {
            this.getView().close();
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String currNodeId = (String)e.getNodeId();
        if ("0".equals(currNodeId)) {
            currNodeId = "";
        }
        this.getPageCache().put(CACHEKEY_SELECTED_NODEIDS, currNodeId);
    }

    public void treeNodeDoubleClick(TreeNodeEvent e) {
        String currNodeId = (String)e.getNodeId();
        if ("0".equals(currNodeId)) {
            currNodeId = "";
        }
        if (StringUtils.isBlank((CharSequence)currNodeId)) {
            return;
        }
        this.getView().returnDataToParent((Object)currNodeId);
        this.getView().close();
    }

    public void search(SearchEnterEvent evt) {
        Search search = (Search)evt.getSource();
        if (StringUtils.equals((CharSequence)KEY_SEARCH_FIELD, (CharSequence)search.getKey())) {
            String searchText = evt.getText();
            this.doSearch(searchText);
        }
    }

    private void fillTreeNodes(String strJson) {
        TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)strJson, TreeNode.class);
        TreeView tree = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        tree.addNode(rootNode);
        this.getPageCache().putBigObject(CACHE_KEY_NODES, strJson);
    }

    private void buildTreeRootNode(String entityNumber) {
        MainEntityType mainEntityType = null;
        try {
            mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        }
        catch (RuntimeException exp) {
            LOG.error((Throwable)exp);
            return;
        }
        PropTreeBuildOption option = new PropTreeBuildOption();
        TreeNode root = FormTreeBuilder.buildDynamicPropertyTree(mainEntityType, option);
        TreeView tree = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        tree.addNode(root);
        String strJson = SerializationUtils.toJsonString((Object)root);
        this.getPageCache().putBigObject(CACHE_KEY_NODES, strJson);
    }

    private void doSearch(String searchText) {
        if (StringUtils.isBlank((CharSequence)searchText)) {
            return;
        }
        String json = this.getPageCache().getBigObject(CACHE_KEY_NODES);
        if (StringUtils.isNotBlank((CharSequence)json)) {
            TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)json, TreeNode.class);
            if (rootNode.getChildren() == null || rootNode.getChildren().isEmpty()) {
                return;
            }
            List<TreeNode> findNodes = this.getContains(rootNode.getChildren(), searchText);
            rootNode.setChildren(findNodes);
            TreeView tree = (TreeView)this.getView().getControl(KEY_TREEVIEW);
            tree.updateNode(rootNode);
        }
    }

    private List<TreeNode> getContains(List<TreeNode> childrens, String searchText) {
        Iterator<TreeNode> iterator = childrens.iterator();
        while (iterator.hasNext()) {
            TreeNode treeNode = iterator.next();
            if (treeNode.getChildren() != null && !treeNode.getChildren().isEmpty()) {
                treeNode.setChildren(this.getContains(treeNode.getChildren(), searchText));
            }
            if (treeNode.getChildren() != null && !treeNode.getChildren().isEmpty() || treeNode.getText().contains(searchText)) continue;
            iterator.remove();
        }
        return childrens;
    }

    private String getNodeFromParent() {
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        if (StringUtils.isBlank((CharSequence)parentPageId)) {
            return null;
        }
        IFormView parentView = this.getView().getViewNoPlugin(parentPageId);
        if (parentView == null) {
            return null;
        }
        return parentView.getPageCache().getBigObject("fieldtreeshow_treenodejson");
    }
}

