/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.vercompare;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.DcAction;
import kd.bos.dataentity.utils.StringUtils;

public final class DcTreeNode
implements Serializable {
    private static final long serialVersionUID = 276274238678610087L;
    private static final String TYPE_SIMPLE = "simple";
    private static final String TYPE_COMPLEX = "complex";
    private static final String TYPE_COLLECTION = "collection";
    private String type;
    private String name;
    private String caption;
    private String action;
    private List<DcTreeNode> childNodes;
    private String itemId;
    private String itemName;
    private Map<String, String> attributes;
    private Map<String, Object> custProps;
    private PropValue baseValue;
    private PropValue currValue;

    public DcTreeNode() {
    }

    public DcTreeNode(String type, String name, String caption) {
        this.type = type;
        this.name = name;
        this.caption = caption;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @JsonIgnore(value=true)
    public boolean isSimpleNode() {
        return StringUtils.equals((CharSequence)this.type, (CharSequence)TYPE_SIMPLE);
    }

    @JsonIgnore(value=true)
    public boolean isComplexNode() {
        return StringUtils.isBlank((CharSequence)this.type) || StringUtils.equals((CharSequence)this.type, (CharSequence)TYPE_COMPLEX);
    }

    @JsonIgnore(value=true)
    public boolean isCollectionNode() {
        return StringUtils.equals((CharSequence)this.type, (CharSequence)TYPE_COLLECTION);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    @JsonIgnore(value=true)
    public boolean isAddAction() {
        return StringUtils.isBlank((CharSequence)this.getAction()) || StringUtils.equalsIgnoreCase((CharSequence)this.getAction(), (CharSequence)"add");
    }

    @JsonIgnore(value=true)
    public boolean isEditAction() {
        return StringUtils.equalsIgnoreCase((CharSequence)this.getAction(), (CharSequence)"edit");
    }

    @JsonIgnore(value=true)
    public boolean isRemoveAction() {
        return StringUtils.equalsIgnoreCase((CharSequence)this.getAction(), (CharSequence)"remove");
    }

    @JsonIgnore(value=true)
    public boolean isSetNullAction() {
        return StringUtils.equalsIgnoreCase((CharSequence)this.getAction(), (CharSequence)"setnull");
    }

    @JsonIgnore(value=true)
    public boolean isClearAction() {
        return StringUtils.equalsIgnoreCase((CharSequence)this.getAction(), (CharSequence)DcAction.ListAction_Clear.getActionName());
    }

    public boolean isPropsDiff() {
        if (this.isSimpleNode()) {
            if (this.baseValue == null && this.currValue == null) {
                return false;
            }
            if (this.baseValue == null || this.currValue == null) {
                return true;
            }
            return !StringUtils.equals((CharSequence)this.getBaseString(), (CharSequence)this.getCurrString());
        }
        if (this.isComplexNode()) {
            if (this.isAddAction() || this.isSetNullAction() || this.isRemoveAction()) {
                return true;
            }
            if (this.isChildNodesEmpty()) {
                return false;
            }
            for (DcTreeNode childNode : this.getChildNodes()) {
                if (!childNode.isSimpleNode() || !childNode.isDiff()) continue;
                return true;
            }
            return false;
        }
        if (this.isCollectionNode()) {
            return false;
        }
        return false;
    }

    @JsonIgnore(value=true)
    public boolean isDiff() {
        if (this.isSimpleNode()) {
            String currValue;
            if (this.baseValue == null && this.currValue == null) {
                return false;
            }
            if (this.baseValue == null || this.currValue == null) {
                return true;
            }
            String baseValue = this.getBaseValue().getValue();
            return !StringUtils.equals((CharSequence)baseValue, (CharSequence)(currValue = this.getCurrValue().getValue()));
        }
        if (this.isComplexNode()) {
            if (this.isAddAction() || this.isSetNullAction() || this.isRemoveAction()) {
                return true;
            }
            if (this.isChildNodesEmpty()) {
                return false;
            }
            for (DcTreeNode childNode : this.getChildNodes()) {
                if (!childNode.isDiff()) continue;
                return true;
            }
            return false;
        }
        if (this.isCollectionNode()) {
            if (this.isClearAction()) {
                return true;
            }
            if (this.isChildNodesEmpty()) {
                return false;
            }
            for (DcTreeNode childNode : this.getChildNodes()) {
                if (!childNode.isDiff()) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public String getItemName() {
        return this.itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public List<DcTreeNode> getChildNodes() {
        return this.childNodes;
    }

    public void setChildNodes(List<DcTreeNode> childNodes) {
        this.childNodes = childNodes;
    }

    @JsonIgnore(value=true)
    public boolean isChildNodesEmpty() {
        return this.childNodes == null || this.childNodes.isEmpty();
    }

    public DcTreeNode addSimplePropNode(String name, LocaleString displayName) {
        if (this.childNodes == null) {
            this.childNodes = new ArrayList<DcTreeNode>(8);
        }
        String caption = displayName == null ? null : displayName.toString();
        DcTreeNode node = new DcTreeNode(TYPE_SIMPLE, name, caption);
        this.childNodes.add(node);
        return node;
    }

    public DcTreeNode addComplexNode(String name, LocaleString displayName) {
        if (this.childNodes == null) {
            this.childNodes = new ArrayList<DcTreeNode>(8);
        }
        String caption = displayName == null ? null : displayName.toString();
        DcTreeNode node = new DcTreeNode(TYPE_COMPLEX, name, caption);
        this.childNodes.add(node);
        return node;
    }

    public DcTreeNode addCollectionNode(String name, LocaleString displayName) {
        if (this.childNodes == null) {
            this.childNodes = new ArrayList<DcTreeNode>(8);
        }
        String caption = displayName == null ? null : displayName.toString();
        DcTreeNode node = new DcTreeNode(TYPE_COLLECTION, name, caption);
        this.childNodes.add(node);
        return node;
    }

    public boolean remove(DcTreeNode childNode) {
        if (this.childNodes == null) {
            return false;
        }
        return this.childNodes.remove(childNode);
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public void putAttribute(String name, String value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>(2);
        }
        this.attributes.put(name, value);
    }

    public void putAttributes(Map<String, String> attributes) {
        if (attributes == null || attributes.isEmpty()) {
            return;
        }
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>(attributes);
        } else {
            this.attributes.putAll(attributes);
        }
    }

    public Map<String, Object> getCustProps() {
        return this.custProps;
    }

    public void setCustProps(Map<String, Object> custProps) {
        this.custProps = custProps;
    }

    @JsonIgnore(value=true)
    public String getBaseString() {
        if (this.baseValue == null) {
            return "";
        }
        return this.baseValue.toString();
    }

    public PropValue getBaseValue() {
        return this.baseValue;
    }

    public void setBaseValue(PropValue baseValue) {
        this.baseValue = baseValue;
    }

    @JsonIgnore(value=true)
    public String getCurrString() {
        if (this.currValue == null) {
            return "";
        }
        return this.currValue.toString();
    }

    public PropValue getCurrValue() {
        return this.currValue;
    }

    public void setCurrValue(PropValue currValue) {
        this.currValue = currValue;
    }

    public String toString() {
        if (this.isComplexNode() && StringUtils.isNotBlank((CharSequence)this.itemName)) {
            return String.format("%s, %s", this.name, this.itemName);
        }
        return String.format("%s, %s", this.name, this.caption);
    }

    public static class PropValue {
        private String value;
        private String action;

        public PropValue() {
        }

        public PropValue(String value) {
            this.value = value;
        }

        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        @JsonIgnore(value=true)
        public boolean isSetValueAction() {
            return StringUtils.isBlank((CharSequence)this.action);
        }

        @JsonIgnore(value=true)
        public boolean isSetNullAction() {
            return StringUtils.equalsIgnoreCase((CharSequence)this.action, (CharSequence)"setnull");
        }

        @JsonIgnore(value=true)
        public boolean isResetAction() {
            return StringUtils.equalsIgnoreCase((CharSequence)this.action, (CharSequence)"reset");
        }

        public String toString() {
            if (this.isSetValueAction()) {
                return this.value;
            }
            return this.action;
        }
    }
}

