/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.vercompare;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.metadata.vercompare.DcTreeNode;

public final class DcTreeNodeUtil {
    private static final String CUST_PROPS = "CustProps";
    private static final String BOS_METADATA = "bos-metadata";

    private DcTreeNodeUtil() {
    }

    public static TreeNode buildTreeNode(DcTreeNode dcTreeNode) {
        return DcTreeNodeUtil.buildTreeNode(dcTreeNode, BuildTreeOption.getDefOption());
    }

    public static TreeNode buildTreeNode(DcTreeNode dcTreeNode, BuildTreeOption option) {
        if (dcTreeNode == null || !dcTreeNode.isComplexNode()) {
            return null;
        }
        TreeNode rootNode = new TreeNode("", dcTreeNode.getName(), dcTreeNode.getCaption());
        DcTreeNodeUtil.buildChildNode(dcTreeNode, rootNode, option);
        DcTreeNodeUtil.setNodeActionFlag(dcTreeNode, rootNode, option);
        return rootNode;
    }

    public static TreeNode buildMetadataTree(DcTreeNode dcTreeNode, BuildTreeOption option) {
        if (dcTreeNode == null || !dcTreeNode.isComplexNode() || dcTreeNode.isChildNodesEmpty()) {
            return null;
        }
        DcTreeNode dcTreeItemsNode = DcTreeNodeUtil.findPropNode(dcTreeNode, "Items");
        if (dcTreeItemsNode == null || dcTreeItemsNode.isChildNodesEmpty()) {
            return null;
        }
        dcTreeNode.remove(dcTreeItemsNode);
        TreeNode rootNode = new TreeNode("", dcTreeNode.getName(), dcTreeNode.getCaption());
        DcTreeNodeUtil.buildChildNode(dcTreeNode, rootNode, option);
        DcTreeNodeUtil.setNodeActionFlag(dcTreeNode, rootNode, option);
        HashMap<String, TreeNode> itemTreeNodes = new HashMap<String, TreeNode>(dcTreeItemsNode.getChildNodes().size());
        TreeNode formRootNode = null;
        String formId = DcTreeNodeUtil.findPropValue(dcTreeNode, "Id");
        String itemsPath = dcTreeNode.getName() + option.getPathSeparator() + dcTreeItemsNode.getName();
        for (DcTreeNode dcTreeItemNode : dcTreeItemsNode.getChildNodes()) {
            String itemPath = itemsPath + option.getPathSeparator() + dcTreeItemNode.getItemId();
            String itemName = DcTreeNodeUtil.buildCollItemName(dcTreeItemNode, option);
            TreeNode treeItemNode = new TreeNode("", itemPath, itemName);
            DcTreeNodeUtil.setNodeActionFlag(dcTreeItemNode, treeItemNode, option);
            itemTreeNodes.put(dcTreeItemNode.getItemId(), treeItemNode);
            DcTreeNodeUtil.buildChildNode(dcTreeItemNode, treeItemNode, option);
            if (formRootNode != null || !StringUtils.equalsIgnoreCase((CharSequence)formId, (CharSequence)DcTreeNodeUtil.findPropValue(dcTreeItemNode, "Id"))) continue;
            formRootNode = treeItemNode;
        }
        if (formRootNode == null) {
            return null;
        }
        for (DcTreeNode dcTreeItemNode : dcTreeItemsNode.getChildNodes()) {
            TreeNode itemNode = (TreeNode)itemTreeNodes.get(dcTreeItemNode.getItemId());
            String parentId = DcTreeNodeUtil.findParentId(dcTreeItemNode);
            if (StringUtils.isBlank((CharSequence)parentId)) {
                if (StringUtils.equalsIgnoreCase((CharSequence)itemNode.getId(), (CharSequence)formRootNode.getId())) continue;
                formRootNode.addChild(itemNode);
                continue;
            }
            TreeNode parentNode = (TreeNode)itemTreeNodes.get(parentId);
            if (parentNode == null) continue;
            parentNode.addChild(itemNode);
        }
        rootNode.addChild(formRootNode);
        return rootNode;
    }

    private static String findParentId(DcTreeNode dcTreeItemNode) {
        DcTreeNode propNode = DcTreeNodeUtil.findPropNode(dcTreeItemNode, "ParentId");
        if (propNode == null) {
            return null;
        }
        return propNode.getCurrString();
    }

    private static String findPropValue(DcTreeNode dcTreeItemNode, String propName) {
        DcTreeNode propNode = DcTreeNodeUtil.findPropNode(dcTreeItemNode, propName);
        if (propNode == null) {
            return null;
        }
        return propNode.getCurrString();
    }

    private static DcTreeNode findPropNode(DcTreeNode dcTreeItemNode, String propName) {
        if (dcTreeItemNode.isChildNodesEmpty()) {
            return null;
        }
        for (DcTreeNode propNode : dcTreeItemNode.getChildNodes()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)propName, (CharSequence)propNode.getName())) continue;
            return propNode;
        }
        return null;
    }

    private static void buildChildNode(DcTreeNode dcTreeNode, TreeNode treeNode, BuildTreeOption option) {
        if (dcTreeNode.isChildNodesEmpty() && dcTreeNode.getCustProps() == null) {
            return;
        }
        ArrayList<Map<String, String>> propValues = new ArrayList<Map<String, String>>(dcTreeNode.getChildNodes().size());
        for (DcTreeNode dcTreePropNode : dcTreeNode.getChildNodes()) {
            if (option.isOnlyDiff() && !dcTreePropNode.isDiff()) continue;
            if (dcTreePropNode.isSimpleNode()) {
                DcTreeNodeUtil.buildSimplePropNode(dcTreePropNode, treeNode, propValues, option);
                continue;
            }
            if (dcTreePropNode.isComplexNode()) {
                DcTreeNodeUtil.buildComplexPropNode(dcTreePropNode, treeNode, option);
                continue;
            }
            DcTreeNodeUtil.buildCollPropNode(dcTreePropNode, treeNode, option);
        }
        if (dcTreeNode.getCustProps() != null) {
            Map<String, String> custValue = DcTreeNodeUtil.packSimplePropValue(treeNode.getId() + option.getPathSeparator() + CUST_PROPS, CUST_PROPS, ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u5c5e\u6027", (String)"DcTreeNodeUtil_01", (String)BOS_METADATA, (Object[])new Object[0]), "", SerializationUtils.toJsonString(dcTreeNode.getCustProps()));
            propValues.add(custValue);
        }
        if (!propValues.isEmpty()) {
            treeNode.setData(propValues);
        }
    }

    private static void buildSimplePropNode(DcTreeNode dcTreePropNode, TreeNode treeNode, List<Map<String, String>> propValues, BuildTreeOption option) {
        if (dcTreePropNode.isDiff()) {
            String baseValue = dcTreePropNode.getBaseValue() == null ? "" : dcTreePropNode.getBaseValue().getValue();
            String currValue = dcTreePropNode.getCurrValue() == null ? "" : dcTreePropNode.getCurrValue().getValue();
            Map<String, String> propValue = DcTreeNodeUtil.packSimplePropValue(treeNode.getId() + option.getPathSeparator() + dcTreePropNode.getName(), dcTreePropNode.getName(), dcTreePropNode.getCaption(), baseValue, currValue);
            propValues.add(propValue);
        }
    }

    private static Map<String, String> packSimplePropValue(String id, String name, String caption, String baseValue, String currValue) {
        HashMap<String, String> propValue = new HashMap<String, String>(4);
        propValue.put("id", id);
        propValue.put("name", name);
        propValue.put("caption", caption);
        propValue.put("baseValue", baseValue);
        propValue.put("currValue", currValue);
        return propValue;
    }

    private static void buildComplexPropNode(DcTreeNode dcTreePropNode, TreeNode treeNode, BuildTreeOption option) {
        String path = treeNode.getId() + option.getPathSeparator() + dcTreePropNode.getName();
        TreeNode treePropNode = new TreeNode(treeNode.getId(), path, dcTreePropNode.getCaption());
        DcTreeNodeUtil.setNodeActionFlag(dcTreePropNode, treePropNode, option);
        treeNode.addChild(treePropNode);
        if (!dcTreePropNode.isChildNodesEmpty()) {
            treePropNode.setId(treePropNode.getId() + option.getPathSeparator() + dcTreePropNode.getChildNodes().get(0).getName());
            DcTreeNodeUtil.setNodeActionFlag(dcTreePropNode.getChildNodes().get(0), treePropNode, option);
            DcTreeNodeUtil.buildChildNode(dcTreePropNode.getChildNodes().get(0), treePropNode, option);
        }
    }

    private static void buildCollPropNode(DcTreeNode dcTreePropNode, TreeNode treeNode, BuildTreeOption option) {
        String path = treeNode.getId() + option.getPathSeparator() + dcTreePropNode.getName();
        TreeNode treePropNode = new TreeNode(treeNode.getId(), path, dcTreePropNode.getCaption());
        DcTreeNodeUtil.setNodeActionFlag(dcTreePropNode, treePropNode, option);
        treeNode.addChild(treePropNode);
        if (!dcTreePropNode.isChildNodesEmpty()) {
            for (DcTreeNode dcTreeSubItemNode : dcTreePropNode.getChildNodes()) {
                if (option.onlyDiff && !dcTreeSubItemNode.isDiff()) continue;
                String itemPath = treePropNode.getId() + option.getPathSeparator() + dcTreeSubItemNode.getItemId();
                String itemName = DcTreeNodeUtil.buildCollItemName(dcTreeSubItemNode, option);
                TreeNode treeItemNode = new TreeNode(treePropNode.getId(), itemPath, !StringUtils.isBlank((CharSequence)itemName) ? itemName : dcTreePropNode.getName());
                DcTreeNodeUtil.setNodeActionFlag(dcTreeSubItemNode, treeItemNode, option);
                treePropNode.addChild(treeItemNode);
                DcTreeNodeUtil.buildChildNode(dcTreeSubItemNode, treeItemNode, option);
            }
        }
    }

    private static String buildCollItemName(DcTreeNode itemNode, BuildTreeOption option) {
        String itemName = null;
        itemName = option.isShowNameOnly() && StringUtils.isNotBlank((CharSequence)itemNode.getItemName()) ? itemNode.getItemName() : (option.isShowTypeOnly() || StringUtils.isBlank((CharSequence)itemNode.getItemName()) ? itemNode.getCaption() : String.format("%s ( %s )", itemNode.getItemName(), itemNode.getCaption()));
        return itemName;
    }

    private static void setNodeActionFlag(DcTreeNode dcTreeNode, TreeNode treeNode, BuildTreeOption option) {
        if (dcTreeNode.isAddAction()) {
            treeNode.setColor(option.getAddNodeColor());
            treeNode.setCheckable(true);
            treeNode.setDisabled(false);
        } else if (dcTreeNode.isRemoveAction() || dcTreeNode.isSetNullAction() || dcTreeNode.isClearAction()) {
            treeNode.setColor(option.getRemoveNodeColor());
            treeNode.setCheckable(true);
            treeNode.setDisabled(false);
        } else if (dcTreeNode.isPropsDiff()) {
            treeNode.setColor(option.getEditNodeColor());
            treeNode.setCheckable(true);
            treeNode.setDisabled(false);
        } else {
            treeNode.setCheckable(false);
            treeNode.setDisabled(!dcTreeNode.isDiff());
        }
    }

    public static DcTreeNode findDcTreeNode(DcTreeNode dcTreeNode, String path) {
        return DcTreeNodeUtil.findDcTreeNode(dcTreeNode, path, "\\$\\$");
    }

    public static DcTreeNode findDcTreeNode(DcTreeNode dcTreeNode, String path, String pathSeparator) {
        if (dcTreeNode == null || !dcTreeNode.isComplexNode() || StringUtils.isBlank((CharSequence)path)) {
            return null;
        }
        String[] paths = path.split(pathSeparator);
        String rootPath = paths[0];
        if (!StringUtils.equals((CharSequence)dcTreeNode.getName(), (CharSequence)rootPath)) {
            return null;
        }
        DcTreeNode node = dcTreeNode;
        for (int i = 1; i < paths.length; ++i) {
            String childNodeName = paths[i];
            boolean find = false;
            if (!node.isChildNodesEmpty()) {
                for (DcTreeNode childNode : node.getChildNodes()) {
                    if (!StringUtils.equals((CharSequence)childNode.getName(), (CharSequence)childNodeName) && (!childNode.isComplexNode() || !StringUtils.equals((CharSequence)childNode.getItemId(), (CharSequence)childNodeName))) continue;
                    find = true;
                    node = childNode;
                    break;
                }
            }
            if (find) continue;
            return null;
        }
        return node;
    }

    public static DcTreeNode selectNodes(DcTreeNode dcTreeNode, String[] selectNodePaths) {
        return DcTreeNodeUtil.selectNodes(dcTreeNode, selectNodePaths, "$$");
    }

    public static DcTreeNode selectNodes(DcTreeNode dcTreeNode, String[] selectNodePaths, String pathSeparator) {
        if (dcTreeNode == null) {
            throw new IllegalArgumentException("dcTreeNode is null");
        }
        if (StringUtils.isBlank((CharSequence)pathSeparator)) {
            throw new IllegalArgumentException("pathSeparator is null");
        }
        if (selectNodePaths == null || selectNodePaths.length == 0) {
            return null;
        }
        HashSet<String> paths = new HashSet<String>(selectNodePaths.length);
        for (String path : selectNodePaths) {
            paths.add(path);
        }
        if (DcTreeNodeUtil.isSelect(dcTreeNode, dcTreeNode.getName(), pathSeparator, paths)) {
            return dcTreeNode;
        }
        return null;
    }

    private static boolean isSelect(DcTreeNode node, String nodePath, String pathSeparator, Set<String> selectNodePaths) {
        String custPropPath;
        if (selectNodePaths.contains(nodePath)) {
            return true;
        }
        boolean isChildSelected = false;
        if (!node.isChildNodesEmpty()) {
            for (int i = node.getChildNodes().size() - 1; i >= 0; --i) {
                DcTreeNode childNode = node.getChildNodes().get(i);
                String childNodePath = null;
                childNodePath = node.isCollectionNode() ? nodePath + pathSeparator + childNode.getItemId() : nodePath + pathSeparator + childNode.getName();
                if (DcTreeNodeUtil.isSelect(childNode, childNodePath, pathSeparator, selectNodePaths)) {
                    isChildSelected = true;
                    continue;
                }
                node.getChildNodes().remove(i);
            }
        }
        if (selectNodePaths.contains(custPropPath = nodePath + pathSeparator + CUST_PROPS)) {
            isChildSelected = true;
        }
        return isChildSelected;
    }

    public static class BuildTreeOption {
        public static final String DEFAULT_ID_SEPARATOR = "$$";
        public static final String ID_SEPARATOR = "\\$\\$";
        private static final String FLAG_TEXT_ADD = "[+] ";
        private static final String FLAG_TEXT_REMOVE = "[-] ";
        private static final String FLAG_TEXT_EDIT = "[!] ";
        private static final String FLAG_TEXT_EQUALS = "[=] ";
        private static final String NODE_COLOR_ADD = "#1BA854";
        private static final String NODE_COLOR_REMOVE = "#FB2323";
        private static final String NODE_COLOR_EDIT = "#FF991C";
        private static final String ICON_NEW = "kdfont kdfont-tianjia5";
        private static final String ICON_REMOVE = "kdfont kdfont-shanchu9";
        private static final String ICON_EDIT = "kdfont kdfont-zhuangtai_jingshi";
        private static final String TEXT_FORMAT_NAME_TYPE = "name_type";
        private static final String TEXT_FORMAT_NAME = "name";
        private static final String TEXT_FORMAT_TYPE = "type";
        private boolean onlyDiff;
        private String pathSeparator = "$$";
        private String addFlagText = "[+] ";
        private String removeFlagText = "[-] ";
        private String editFlagText = "[!] ";
        private String equalsFlagText = "[=] ";
        private String addNodeColor = "#1BA854";
        private String removeNodeColor = "#FB2323";
        private String editNodeColor = "#FF991C";
        private String addIcon = "kdfont kdfont-tianjia5";
        private String removeIcon = "kdfont kdfont-shanchu9";
        private String editIcon = "kdfont kdfont-zhuangtai_jingshi";
        private String textFormat = "name_type";

        public static BuildTreeOption getDefOption() {
            BuildTreeOption defOption = new BuildTreeOption();
            defOption.onlyDiff = true;
            defOption.pathSeparator = DEFAULT_ID_SEPARATOR;
            return defOption;
        }

        public boolean isOnlyDiff() {
            return this.onlyDiff;
        }

        public void setOnlyDiff(boolean onlyDiff) {
            this.onlyDiff = onlyDiff;
        }

        public String getPathSeparator() {
            return StringUtils.isBlank((CharSequence)this.pathSeparator) ? DEFAULT_ID_SEPARATOR : this.pathSeparator;
        }

        public void setPathSeparator(String pathSeparator) {
            this.pathSeparator = pathSeparator;
        }

        public String getAddFlagText() {
            return this.addFlagText;
        }

        public void setAddFlagText(String addFlagText) {
            this.addFlagText = addFlagText;
        }

        public String getRemoveFlagText() {
            return this.removeFlagText;
        }

        public void setRemoveFlagText(String removeFlagText) {
            this.removeFlagText = removeFlagText;
        }

        public String getEditFlagText() {
            return this.editFlagText;
        }

        public void setEditFlagText(String editFlagText) {
            this.editFlagText = editFlagText;
        }

        public String getEqualsFlagText() {
            return this.equalsFlagText;
        }

        public void setEqualsFlagText(String equalsFlagText) {
            this.equalsFlagText = equalsFlagText;
        }

        public String getAddNodeColor() {
            return this.addNodeColor;
        }

        public void setAddNodeColor(String addNodeColor) {
            this.addNodeColor = addNodeColor;
        }

        public String getRemoveNodeColor() {
            return this.removeNodeColor;
        }

        public void setRemoveNodeColor(String removeNodeColor) {
            this.removeNodeColor = removeNodeColor;
        }

        public String getEditNodeColor() {
            return this.editNodeColor;
        }

        public void setEditNodeColor(String editNodeColor) {
            this.editNodeColor = editNodeColor;
        }

        public String getAddIcon() {
            return this.addIcon;
        }

        public void setAddIcon(String addIcon) {
            this.addIcon = addIcon;
        }

        public String getRemoveIcon() {
            return this.removeIcon;
        }

        public void setRemoveIcon(String removeIcon) {
            this.removeIcon = removeIcon;
        }

        public String getEditIcon() {
            return this.editIcon;
        }

        public void setEditIcon(String editIcon) {
            this.editIcon = editIcon;
        }

        public String getTextFormat() {
            return this.textFormat;
        }

        public void setTextFormat(String textFormat) {
            this.textFormat = textFormat;
        }

        public boolean isShowNameAndType() {
            return !this.isShowNameOnly() && !this.isShowTypeOnly();
        }

        public boolean isShowNameOnly() {
            return StringUtils.equalsIgnoreCase((CharSequence)this.textFormat, (CharSequence)TEXT_FORMAT_NAME);
        }

        public boolean isShowTypeOnly() {
            return StringUtils.equalsIgnoreCase((CharSequence)this.textFormat, (CharSequence)TEXT_FORMAT_TYPE);
        }
    }
}

